/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.osm.Node;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoyNota
extends Buoy {
    public BuoyNota(SmpDialogAction dia, int type) {
        super(dia);
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem("Not set");
        this.dlg.cbM01Kennung.addItem("Fl");
        this.dlg.cbM01Kennung.addItem("Fl(2)");
        this.dlg.cbM01Kennung.addItem("Fl(3)");
        this.dlg.cbM01Kennung.addItem("Fl(4)");
        this.dlg.cbM01Kennung.addItem("Fl(5)");
        this.dlg.cbM01Kennung.addItem("Oc(2)");
        this.dlg.cbM01Kennung.addItem("Oc(3)");
        this.dlg.cbM01Kennung.addItem("Q");
        this.dlg.cbM01Kennung.addItem("IQ");
        this.dlg.cbM01Kennung.setSelectedIndex(0);
        this.dlg.cbM01Colour.removeAllItems();
        this.dlg.cbM01Colour.addItem("Not set");
        this.dlg.cbM01Colour.addItem("R");
        this.dlg.cbM01Colour.addItem("G");
        this.dlg.cbM01Colour.addItem("W");
        this.dlg.cbM01Colour.setEnabled(true);
        this.setBuoyIndex(type);
        this.setStyleIndex(0);
        this.setLightColour();
        this.setFired(true);
        this.setTopMark(false);
        this.refreshStyles();
        this.paintSign();
    }

    public void refreshStyles() {
        int type = this.getBuoyIndex();
        int style = this.getStyleIndex();
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem("Not set");
        this.dlg.cbM01StyleOfMark.addItem("Lighthouse");
        this.dlg.cbM01StyleOfMark.addItem("Major Light");
        this.dlg.cbM01StyleOfMark.addItem("Minor Light");
        this.dlg.cbM01StyleOfMark.addItem("Light Float");
        if (style >= this.dlg.cbM01StyleOfMark.getItemCount()) {
            style = 0;
        }
        this.setStyleIndex(style);
        this.dlg.cbM01StyleOfMark.setSelectedIndex(style);
    }

    public void paintSign() {
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        this.dlg.tfM01Name.setEnabled(true);
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01Fired.setSelected(true);
        this.dlg.cM01Fired.setEnabled(false);
        this.dlg.cM01TopMark.setEnabled(false);
        this.dlg.cM01TopMark.setSelected(false);
        switch (this.getStyleIndex()) {
            case 1: 
            case 2: {
                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Major.png")));
                break;
            }
            case 3: {
                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Minor.png")));
                break;
            }
            case 4: {
                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Major_Float.png")));
                break;
            }
        }
        if (this.getLightColour() == "W") {
            this.dlg.lM01Icon03.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_White.png")));
        } else if (this.getLightColour() == "R") {
            this.dlg.lM01Icon03.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Red.png")));
        } else if (this.getLightColour() == "G") {
            this.dlg.lM01Icon03.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Green.png")));
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        switch (this.getStyleIndex()) {
            case 1: {
                super.saveSign("lighthouse");
                break;
            }
            case 2: {
                super.saveSign("major_light");
                break;
            }
            case 3: {
                super.saveSign("minor_light");
                break;
            }
            case 4: {
                super.saveSign("major_floating_light");
                break;
            }
        }
        this.saveLightData("white");
    }

    public void setLightColour() {
    }

    public boolean parseTopMark(Node node) {
        return false;
    }

    public boolean parseLight(Node node) {
        boolean ret = true;
        this.setFired(true);
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:light:colour")) {
            String str = (String)keys.get("seamark:light:colour");
            if (keys.containsKey("seamark:light:character")) {
                String c;
                this.setLightGroup(keys);
                String ce = c = (String)keys.get("seamark:light:character");
                this.setLightChar(c);
                this.setLightPeriod(keys);
            }
            this.setLightColour(str);
        }
        return ret;
    }
}

