/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoySpec
extends Buoy {
    public BuoySpec(SmpDialogAction dia, int type) {
        super(dia);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem("Not set");
        this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Sphere Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Barrel");
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem("Not set");
        this.dlg.cbM01Colour.removeAllItems();
        this.dlg.cbM01Colour.addItem("W");
        this.dlg.cbM01Colour.setSelectedIndex(0);
        this.dlg.cbM01Colour.setEnabled(false);
        this.dlg.cM01Fired.setSelected(false);
        this.dlg.cM01TopMark.setSelected(false);
        this.setColour(11);
        this.setLightColour("W");
        this.setBuoyIndex(type);
        this.paintSign();
    }

    public void paintSign() {
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        this.dlg.tfM01Name.setEnabled(true);
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01Fired.setEnabled(true);
        this.dlg.cM01TopMark.setEnabled(true);
        switch (this.getStyleIndex()) {
            case 1: {
                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Special_Purpose_Pillar.png")));
                break;
            }
            case 2: {
                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Special_Purpose_Spar.png")));
                break;
            }
            case 3: {
                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Special_Purpose_Sphere.png")));
                break;
            }
            case 4: {
                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Special_Purpose_Barrel.png")));
                break;
            }
        }
        if (this.getLightChar() != "") {
            String c = this.getLightChar();
            this.dlg.cbM01Kennung.setSelectedItem(c);
            if (this.dlg.cbM01Kennung.getSelectedItem() == "Not set") {
                String string = "";
            }
        }
        switch (this.getStyleIndex()) {
            case 1: 
            case 2: {
                this.Checker("/images/Cross_Top_Buoy_Yellow.png", "/images/Light_White.png");
                break;
            }
            case 3: 
            case 4: {
                this.Checker("/images/Cross_Top_Sphere_Yellow.png", "/images/Light_White.png");
                break;
            }
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        super.saveSign("buoy_special_purpose");
        switch (this.getStyleIndex()) {
            case 1: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "pillar"));
                break;
            }
            case 2: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "spar"));
                break;
            }
            case 3: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "sphere"));
                break;
            }
            case 4: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "barrel"));
                break;
            }
        }
        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
        this.saveTopMarkData("cross", "yellow");
        this.saveLightData("white");
    }

    public boolean parseTopMark(Node node) {
        if (node == null) {
            return false;
        }
        boolean ret = true;
        this.setTopMark(false);
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:topmark:shape")) {
            String str = (String)keys.get("seamark:topmark:shape");
            if (str.compareTo("cross") == 0) {
                this.setTopMark(true);
            } else {
                this.setErrMsg("Parse-Error: Topmark unbekannt");
                ret = false;
            }
        }
        return ret;
    }

    public boolean parseLight(Node node) {
        boolean ret = true;
        this.setFired(false);
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:light:colour")) {
            String str = (String)keys.get("seamark:light:colour");
            if (keys.containsKey("seamark:light:character")) {
                this.setLightGroup(keys);
                String c = (String)keys.get("seamark:light:character");
                this.setLightChar(c);
                this.setLightPeriod(keys);
            }
            if (str.compareTo("white") == 0) {
                this.setFired(true);
                this.setLightColour("W");
            } else {
                if (this.getErrMsg() == null) {
                    this.setErrMsg("Parse-Error: Licht falsch");
                } else {
                    this.setErrMsg(this.getErrMsg() + " / Licht falsch");
                }
                ret = false;
            }
        }
        return ret;
    }

    public void setLightColour() {
        super.setLightColour("W");
    }

    public boolean parseShape(Node node) {
        boolean ret = true;
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:buoy_special_purpose:shape")) {
            String str = (String)keys.get("seamark:buoy_special_purpose:shape");
            if (str.compareTo("pillar") == 0) {
                this.setStyleIndex(1);
            } else if (str.compareTo("spar") == 0) {
                this.setStyleIndex(2);
            } else if (str.compareTo("sphere") == 0) {
                this.setStyleIndex(3);
            } else if (str.compareTo("barrel") == 0) {
                this.setStyleIndex(4);
            } else {
                ret = false;
            }
        }
        return ret;
    }
}

