/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoyLat
extends Buoy {
    public BuoyLat(SmpDialogAction dia, int type) {
        super(dia);
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem("Not set");
        this.dlg.cbM01Kennung.addItem("Fl");
        this.dlg.cbM01Kennung.addItem("Fl(2)");
        this.dlg.cbM01Kennung.addItem("Fl(3)");
        this.dlg.cbM01Kennung.addItem("Fl(4)");
        this.dlg.cbM01Kennung.addItem("Fl(5)");
        this.dlg.cbM01Kennung.addItem("Oc(2)");
        this.dlg.cbM01Kennung.addItem("Oc(3)");
        this.dlg.cbM01Kennung.addItem("Q");
        this.dlg.cbM01Kennung.addItem("IQ");
        this.dlg.cbM01Kennung.setSelectedIndex(0);
        this.dlg.cbM01Colour.removeAllItems();
        this.dlg.cbM01Colour.addItem("");
        this.dlg.cbM01Colour.addItem("R");
        this.dlg.cbM01Colour.addItem("G");
        this.dlg.cbM01Colour.setSelectedIndex(0);
        this.dlg.cbM01Colour.setEnabled(false);
        this.setBuoyIndex(type);
        this.setStyleIndex(0);
        this.setLightColour();
        this.setFired(false);
        this.setTopMark(false);
        this.refreshStyles();
        this.paintSign();
    }

    public void refreshStyles() {
        int type = this.getBuoyIndex();
        int style = this.getStyleIndex();
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem("Not set");
        switch (type) {
            case 1: {
                this.dlg.cbM01StyleOfMark.addItem("Can Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Beacon");
                this.dlg.cbM01StyleOfMark.addItem("Tower");
                this.dlg.cbM01StyleOfMark.addItem("Float");
                this.dlg.cbM01StyleOfMark.addItem("Perch");
                break;
            }
            case 2: {
                this.dlg.cbM01StyleOfMark.addItem("Cone Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Beacon");
                this.dlg.cbM01StyleOfMark.addItem("Tower");
                this.dlg.cbM01StyleOfMark.addItem("Float");
                this.dlg.cbM01StyleOfMark.addItem("Perch");
                break;
            }
            case 3: {
                this.dlg.cbM01StyleOfMark.addItem("Can Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Beacon");
                this.dlg.cbM01StyleOfMark.addItem("Tower");
                break;
            }
            case 4: {
                this.dlg.cbM01StyleOfMark.addItem("Cone Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Beacon");
                this.dlg.cbM01StyleOfMark.addItem("Tower");
                break;
            }
        }
        if (style >= this.dlg.cbM01StyleOfMark.getItemCount()) {
            style = 0;
        }
        this.setStyleIndex(style);
        this.dlg.cbM01StyleOfMark.setSelectedIndex(style);
    }

    public void paintSign() {
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        this.dlg.tfM01Name.setEnabled(true);
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01Fired.setEnabled(true);
        this.dlg.cM01TopMark.setEnabled(true);
        int cat = this.getBuoyIndex();
        int region = this.getRegion();
        int style = this.getStyleIndex();
        block0 : switch (this.getBuoyIndex()) {
            case 1: {
                if (region != 2) {
                    switch (style) {
                        case 1: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Can_Red.png")));
                            break block0;
                        }
                        case 2: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Pillar_Red.png")));
                            break block0;
                        }
                        case 3: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Spar_Red.png")));
                            break block0;
                        }
                        case 4: {
                            if (this.isFired()) {
                                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Lit_Red.png")));
                                break block0;
                            }
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Red.png")));
                            break block0;
                        }
                        case 5: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Tower_Red.png")));
                            break block0;
                        }
                        case 6: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Float_Red.png")));
                            break block0;
                        }
                        case 7: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Perch_Port.png")));
                            break block0;
                        }
                    }
                    break;
                }
                switch (style) {
                    case 1: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Can_Green.png")));
                        break block0;
                    }
                    case 2: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Pillar_Green.png")));
                        break block0;
                    }
                    case 3: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Spar_Green.png")));
                        break block0;
                    }
                    case 4: {
                        if (this.isFired()) {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Lit_Green.png")));
                            break block0;
                        }
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Green.png")));
                        break block0;
                    }
                    case 5: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Tower_Green.png")));
                        break block0;
                    }
                    case 6: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Float_Green.png")));
                        break block0;
                    }
                    case 7: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Perch_Port.png")));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (region != 2) {
                    switch (style) {
                        case 1: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cone_Green.png")));
                            break block0;
                        }
                        case 2: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Pillar_Green.png")));
                            break block0;
                        }
                        case 3: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Spar_Green.png")));
                            break block0;
                        }
                        case 4: {
                            if (this.isFired()) {
                                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Lit_Green.png")));
                                break block0;
                            }
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Green.png")));
                            break block0;
                        }
                        case 5: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Tower_Green.png")));
                            break block0;
                        }
                        case 6: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Float_Green.png")));
                            break block0;
                        }
                        case 7: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Perch_Starboard.png")));
                            break block0;
                        }
                    }
                    break;
                }
                switch (style) {
                    case 1: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cone_Red.png")));
                        break block0;
                    }
                    case 2: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Pillar_Red.png")));
                        break block0;
                    }
                    case 3: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Spar_Red.png")));
                        break block0;
                    }
                    case 4: {
                        if (this.isFired()) {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Lit_Red.png")));
                            break block0;
                        }
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Red.png")));
                        break block0;
                    }
                    case 5: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Tower_Red.png")));
                        break block0;
                    }
                    case 6: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Float_Red.png")));
                        break block0;
                    }
                    case 7: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Perch_Starboard.png")));
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                if (region != 2) {
                    switch (style) {
                        case 1: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Can_Red_Green_Red.png")));
                            break block0;
                        }
                        case 2: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Pillar_Red_Green_Red.png")));
                            break block0;
                        }
                        case 3: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Spar_Red_Green_Red.png")));
                            break block0;
                        }
                        case 4: {
                            if (this.isFired()) {
                                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Lit_Red_Green_Red.png")));
                                break block0;
                            }
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Red_Green_Red.png")));
                            break block0;
                        }
                        case 5: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Tower_Red_Green_Red.png")));
                            break block0;
                        }
                    }
                    break;
                }
                switch (style) {
                    case 1: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Can_Green_Red_Green.png")));
                        break block0;
                    }
                    case 2: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Pillar_Green_Red_Green.png")));
                        break block0;
                    }
                    case 3: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Spar_Green_Red_Green.png")));
                        break block0;
                    }
                    case 4: {
                        if (this.isFired()) {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Lit_Green_Red_Green.png")));
                            break block0;
                        }
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Green_Red_Green.png")));
                        break block0;
                    }
                    case 5: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Tower_Green_Red_Green.png")));
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                if (region != 2) {
                    switch (style) {
                        case 1: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cone_Green_Red_Green.png")));
                            break block0;
                        }
                        case 2: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Pillar_Green_Red_Green.png")));
                            break block0;
                        }
                        case 3: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Spar_Green_Red_Green.png")));
                            break block0;
                        }
                        case 4: {
                            if (this.isFired()) {
                                this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Lit_Green_Red_Green.png")));
                                break block0;
                            }
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Green_Red_Green.png")));
                            break block0;
                        }
                        case 5: {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Tower_Green_Red_Green.png")));
                            break block0;
                        }
                    }
                    break;
                }
                switch (style) {
                    case 1: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cone_Red_Green_Red.png")));
                        break block0;
                    }
                    case 2: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Pillar_Red_Green_Red.png")));
                        break block0;
                    }
                    case 3: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Spar_Red_Green_Red.png")));
                        break block0;
                    }
                    case 4: {
                        if (this.isFired()) {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Li_Red_Green_Red.png")));
                            break block0;
                        }
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Beacon_Red_Green_Red.png")));
                        break block0;
                    }
                    case 5: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Lateral_Tower_Red_Green_Red.png")));
                        break block0;
                    }
                }
                break;
            }
        }
        if (this.getLightChar() != "") {
            String c = this.getLightChar();
            if (this.getLightGroup() != "") {
                c = c + "(" + this.getLightGroup() + ")";
            }
            this.dlg.cbM01Kennung.setSelectedItem(c);
            if (this.dlg.cbM01Kennung.getSelectedItem() == "Not set") {
                c = "";
            }
        }
        if (cat == 1 || cat == 3) {
            switch (style) {
                case 1: {
                    if (region != 2) {
                        this.Checker("/images/Can_Top_Can_Red.png", "/images/Light_Red.png");
                        break;
                    }
                    this.Checker("/images/Can_Top_Can_Green.png", "/images/Light_Green.png");
                    break;
                }
                case 2: 
                case 3: {
                    if (region != 2) {
                        this.Checker("/images/Can_Top_Buoy_Red.png", "/images/Light_Red.png");
                        break;
                    }
                    this.Checker("/images/Can_Top_Buoy_Green.png", "/images/Light_Green.png");
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (region != 2) {
                        this.Checker("/images/Can_Top_Post_Red.png", "/images/Light_Red.png");
                        break;
                    }
                    this.Checker("/images/Can_Top_Post_Green.png", "/images/Light_Green.png");
                    break;
                }
            }
        } else {
            switch (style) {
                case 1: {
                    if (region != 2) {
                        this.Checker("/images/Cone_Top_Cone_Green.png", "/images/Light_Green.png");
                        break;
                    }
                    this.Checker("/images/Cone_Top_Cone_Red.png", "/images/Light_Red.png");
                    break;
                }
                case 2: 
                case 3: {
                    if (region != 2) {
                        this.Checker("/images/Cone_Top_Buoy_Green.png", "/images/Light_Green.png");
                        break;
                    }
                    this.Checker("/images/Cone_Top_Buoy_Red.png", "/images/Light_Red.png");
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (region != 2) {
                        this.Checker("/images/Cone_Top_Post_Green.png", "/images/Light_Green.png");
                        break;
                    }
                    this.Checker("/images/Cone_Top_Post_Red.png", "/images/Light_Red.png");
                    break;
                }
            }
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        int cat = this.getBuoyIndex();
        String shape = "";
        String colour = "";
        switch (cat) {
            case 1: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "can"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "stake"));
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "float"));
                        break;
                    }
                    case 7: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "perch"));
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "port"));
                        if (this.getRegion() != 2) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green"));
                        colour = "green";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "port"));
                        if (this.getRegion() != 2) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green"));
                        colour = "green";
                    }
                }
                shape = "cylinder";
                break;
            }
            case 3: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "can"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "stake"));
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "float"));
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "preferred_channel_port"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour_pattern", "horizontal stripes"));
                        if (this.getRegion() != 2) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red;green;red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green;red;green"));
                        colour = "green";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "preferred_channel_port"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour_pattern", "horizontal stripes"));
                        if (this.getRegion() != 2) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red;green;red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green;red;green"));
                        colour = "green";
                    }
                }
                shape = "cylinder";
                break;
            }
            case 2: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "conical"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "stake"));
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "float"));
                        break;
                    }
                    case 7: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "perch"));
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "starboard"));
                        if (this.getRegion() != 2) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red"));
                        colour = "red";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "starboard"));
                        if (this.getRegion() != 2) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red"));
                        colour = "red";
                    }
                }
                shape = "cone, point up";
                break;
            }
            case 4: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "conical"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "stake"));
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "preferred_channel_starboard"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour_pattern", "horizontal stripes"));
                        if (this.getRegion() != 2) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green;red;green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red;green;red"));
                        colour = "red";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "preferred_channel_starboard"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour_pattern", "horizontal stripes"));
                        if (this.getRegion() != 2) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green;red;green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red;green;red"));
                        colour = "red";
                    }
                }
                shape = "cone, point up";
                break;
            }
        }
        this.saveTopMarkData(shape, colour);
        this.saveLightData(colour);
    }

    public boolean parseTopMark(Node node) {
        if (node == null) {
            return false;
        }
        boolean ret = true;
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:topmark:shape")) {
            String str = (String)keys.get("seamark:topmark:shape");
            int cat = this.getBuoyIndex();
            switch (cat) {
                case 1: 
                case 3: {
                    if (str.compareTo("cylinder") == 0) {
                        this.setTopMark(true);
                        break;
                    }
                    this.setTopMark(false);
                    ret = false;
                    break;
                }
                case 2: 
                case 4: {
                    if (str.compareTo("cone, point up") == 0 || str.compareTo("cone") == 0) {
                        this.setTopMark(true);
                        break;
                    }
                    this.setTopMark(false);
                    ret = false;
                    break;
                }
                default: {
                    ret = false;
                }
            }
            if (!this.hasTopMark()) {
                this.setErrMsg("Parse-Error: Topmark falsch");
                ret = false;
            }
        }
        return ret;
    }

    public boolean parseLight(Node node) {
        boolean ret = true;
        this.setFired(false);
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:light:colour")) {
            String str = (String)keys.get("seamark:light:colour");
            if (keys.containsKey("seamark:light:character")) {
                this.setLightGroup(keys);
                String c = (String)keys.get("seamark:light:character");
                this.setLightChar(c);
                this.setLightPeriod(keys);
            }
            this.setLightColour(str);
            if (!this.isFired()) {
                if (this.getErrMsg() == null) {
                    this.setErrMsg("Parse-Error: Befeuerung falsch");
                } else {
                    this.setErrMsg(this.getErrMsg() + " / Befeuerung falsch");
                }
            }
        }
        return ret;
    }

    public void setLightColour() {
        if (this.getRegion() != 2 && (this.getBuoyIndex() == 1 || this.getBuoyIndex() == 3)) {
            super.setLightColour("R");
            this.dlg.cbM01Colour.setSelectedIndex(1);
        } else {
            super.setLightColour("G");
            this.dlg.cbM01Colour.setSelectedIndex(2);
        }
    }

    public void setLightColour(String str) {
        int cat = this.getBuoyIndex();
        if (str == null) {
            return;
        }
        switch (cat) {
            case 1: 
            case 3: {
                if (str.compareTo("red") == 0) {
                    this.setFired(true);
                    super.setLightColour("R");
                    break;
                }
                super.setLightColour("");
                break;
            }
            case 2: 
            case 4: {
                if (str.compareTo("green") == 0) {
                    this.setFired(true);
                    super.setLightColour("G");
                    break;
                }
                super.setLightColour("");
                break;
            }
        }
    }

    public boolean parseShape(Node node) {
        boolean ret = true;
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:buoy_lateral:shape")) {
            String str = (String)keys.get("seamark:buoy_lateral:shape");
            int cat = this.getBuoyIndex();
            switch (cat) {
                case 1: {
                    if (str.compareTo("can") == 0) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.compareTo("pillar") == 0) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (str.compareTo("spar") == 0) {
                        this.setStyleIndex(3);
                        break;
                    }
                    if (str.compareTo("float") == 0) {
                        this.setStyleIndex(6);
                        break;
                    }
                    if (str.compareTo("perch") == 0) {
                        this.setStyleIndex(7);
                        break;
                    }
                    ret = false;
                    break;
                }
                case 3: {
                    if (str.compareTo("can") == 0) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.compareTo("pillar") == 0) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (str.compareTo("spar") == 0) {
                        this.setStyleIndex(3);
                        break;
                    }
                    ret = false;
                    break;
                }
                case 2: {
                    if (str.compareTo("conical") == 0) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.compareTo("pillar") == 0) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (str.compareTo("spar") == 0) {
                        this.setStyleIndex(3);
                        break;
                    }
                    if (str.compareTo("float") == 0) {
                        this.setStyleIndex(6);
                        break;
                    }
                    if (str.compareTo("perch") == 0) {
                        this.setStyleIndex(7);
                        break;
                    }
                    ret = false;
                    break;
                }
                case 4: {
                    if (str.compareTo("conical") == 0) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.compareTo("pillar") == 0) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (str.compareTo("spar") == 0) {
                        this.setStyleIndex(3);
                        break;
                    }
                    ret = false;
                    break;
                }
                default: {
                    ret = false;
                    break;
                }
            }
        } else if (keys.containsKey("seamark:beacon_lateral:shape")) {
            String str = (String)keys.get("seamark:beacon_lateral:shape");
            int cat = this.getBuoyIndex();
            switch (cat) {
                case 1: {
                    if (str.compareTo("stake") == 0) {
                        this.setStyleIndex(4);
                        break;
                    }
                    if (str.compareTo("tower") == 0) {
                        this.setStyleIndex(5);
                        break;
                    }
                    ret = false;
                    break;
                }
                case 3: {
                    if (str.compareTo("stake") == 0) {
                        this.setStyleIndex(4);
                        break;
                    }
                    if (str.compareTo("tower") == 0) {
                        this.setStyleIndex(5);
                        break;
                    }
                    ret = false;
                    break;
                }
                case 2: {
                    if (str.compareTo("stake") == 0) {
                        this.setStyleIndex(4);
                        break;
                    }
                    if (str.compareTo("tower") == 0) {
                        this.setStyleIndex(5);
                        break;
                    }
                    ret = false;
                    break;
                }
                case 4: {
                    if (str.compareTo("stake") == 0) {
                        this.setStyleIndex(4);
                        break;
                    }
                    if (str.compareTo("tower") == 0) {
                        this.setStyleIndex(5);
                        break;
                    }
                    ret = false;
                    break;
                }
                default: {
                    ret = false;
                }
            }
        }
        return ret;
    }
}

