/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.dialogs;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyTypes;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.PreferenceAccessParameters;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.VehiclePropertyStringParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessParameterDialog
extends JDialog {
    private static final Map<VehiclePropertyType<Float>, String> FLOAT_PROPERTIES = new LinkedHashMap<VehiclePropertyType<Float>, String>();
    private static final Collection<Character> FORBIDDEN_CHARS;
    private boolean existingBookmark = false;
    private final Collection<String> existingBookmarkNames;
    private final BookmarkAction okAction;
    private final BookmarkNamePanel bookmarkNamePanel;
    private final AccessClassPanel accessClassPanel;
    private final AccessTypesPanel accessTypesPanel;
    private final VehiclePropertiesPanel vehiclePropertiesPanel;
    private final RoadQualityPanel roadQualityPanel;

    public AccessParameterDialog(Frame owner, boolean existingBookmark, String initialName, Collection<String> existingBookmarkNames, PreferenceAccessParameters initialAccessParameters, BookmarkAction okAction) {
        super(owner, "edit access parameters", true);
        this.existingBookmark = existingBookmark;
        this.existingBookmarkNames = existingBookmarkNames;
        this.okAction = okAction;
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.bookmarkNamePanel = new BookmarkNamePanel(initialName);
        gbc.gridy = 0;
        layout.setConstraints(this.bookmarkNamePanel, gbc);
        this.add(this.bookmarkNamePanel);
        this.accessClassPanel = new AccessClassPanel(initialAccessParameters);
        gbc.gridy = 1;
        layout.setConstraints(this.accessClassPanel, gbc);
        this.add(this.accessClassPanel);
        this.accessTypesPanel = new AccessTypesPanel(initialAccessParameters);
        gbc.gridy = 2;
        layout.setConstraints(this.accessTypesPanel, gbc);
        this.add(this.accessTypesPanel);
        this.vehiclePropertiesPanel = new VehiclePropertiesPanel(initialAccessParameters);
        gbc.gridy = 3;
        layout.setConstraints(this.vehiclePropertiesPanel, gbc);
        this.add(this.vehiclePropertiesPanel);
        this.roadQualityPanel = new RoadQualityPanel(initialAccessParameters);
        gbc.gridy = 4;
        layout.setConstraints(this.roadQualityPanel, gbc);
        this.add(this.roadQualityPanel);
        OkCancelPanel okCancelPanel = new OkCancelPanel();
        gbc.gridy = 5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        layout.setConstraints(okCancelPanel, gbc);
        this.add(okCancelPanel);
        this.pack();
    }

    private PreferenceAccessParameters getAccessParameters() {
        String accessClass = this.accessClassPanel.getAccessClass();
        Collection<AccessType> usableAccessTypes = this.accessTypesPanel.getUsableAccessTypes();
        Map<VehiclePropertyType<?>, String> vehiclePropertyStrings = this.vehiclePropertiesPanel.getVehiclePropertyStrings();
        Map<VehiclePropertyType<?>, String> additionalVehiclePropertyStrings = this.roadQualityPanel.getVehiclePropertyStrings();
        if (accessClass != null && usableAccessTypes != null && vehiclePropertyStrings != null && additionalVehiclePropertyStrings != null) {
            vehiclePropertyStrings.putAll(additionalVehiclePropertyStrings);
            try {
                return new PreferenceAccessParameters(accessClass, usableAccessTypes, vehiclePropertyStrings);
            }
            catch (VehiclePropertyStringParser.PropertyValueSyntaxException e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
                return null;
            }
        }
        return null;
    }

    static {
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.HEIGHT, "height (m)");
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.WIDTH, "width (m)");
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.LENGTH, "length (m)");
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.SPEED, "speed (km/h)");
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.WEIGHT, "weight (t)");
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.AXLELOAD, "axleload (t)");
        FORBIDDEN_CHARS = Arrays.asList(Character.valueOf(','), Character.valueOf(';'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('='), Character.valueOf('|'));
    }

    private class OkCancelPanel
    extends JPanel {
        public OkCancelPanel() {
            new BoxLayout(this, 0);
            JButton okButton = new JButton(AccessParameterDialog.this.existingBookmark ? "Change bookmark" : "Create bookmark");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceAccessParameters parameters;
                    String bookmarkName = AccessParameterDialog.this.bookmarkNamePanel.getBookmarkName();
                    if (bookmarkName != null && (parameters = AccessParameterDialog.this.getAccessParameters()) != null) {
                        AccessParameterDialog.this.okAction.execute(bookmarkName, parameters);
                        AccessParameterDialog.this.dispose();
                    }
                }
            });
            this.add(okButton);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccessParameterDialog.this.dispose();
                }
            });
            this.add(cancelButton);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RoadQualityPanel
    extends JPanel {
        private JTextField inclineUpTextField;
        private JTextField inclineDownTextField;
        private JTextField surfaceTextField;
        private JTextField tracktypeTextField;

        public RoadQualityPanel(PreferenceAccessParameters initialParameters) {
            this.setBorder(BorderFactory.createTitledBorder("road requirements"));
            this.setLayout(new GridLayout(4, 2));
            JLabel inclineUpLabel = new JLabel("max. incline up (%, pos.)");
            inclineUpLabel.setToolTipText("maximum incline the vehicle can go up");
            this.add(inclineUpLabel);
            this.inclineUpTextField = new JTextField();
            String vehiclePropertyString = initialParameters.getVehiclePropertyString(VehiclePropertyTypes.MAX_INCLINE_UP);
            if (vehiclePropertyString != null) {
                this.inclineUpTextField.setText(vehiclePropertyString);
            }
            this.inclineUpTextField.setToolTipText("maximum incline the vehicle can go up");
            this.add(this.inclineUpTextField);
            JLabel inclineDownLabel = new JLabel("max. incline down (%, pos.)");
            inclineDownLabel.setToolTipText("maximum incline the vehicle can go down");
            this.add(inclineDownLabel);
            this.inclineDownTextField = new JTextField();
            vehiclePropertyString = initialParameters.getVehiclePropertyString(VehiclePropertyTypes.MAX_INCLINE_DOWN);
            if (vehiclePropertyString != null) {
                this.inclineDownTextField.setText(vehiclePropertyString);
            }
            this.inclineDownTextField.setToolTipText("maximum incline the vehicle can go down");
            this.add(this.inclineDownTextField);
            JLabel surfaceLabel = new JLabel("surface blacklist");
            surfaceLabel.setToolTipText("list of surfaces the vehicle cannot use, values are separated by semicolons (;)");
            this.add(surfaceLabel);
            this.surfaceTextField = new JTextField();
            vehiclePropertyString = initialParameters.getVehiclePropertyString(VehiclePropertyTypes.SURFACE_BLACKLIST);
            if (vehiclePropertyString != null) {
                this.surfaceTextField.setText(vehiclePropertyString);
            }
            this.surfaceTextField.setToolTipText("list of surfaces the vehicle cannot use, values are separated by semicolons (;)");
            this.add(this.surfaceTextField);
            JLabel tracktypeLabel = new JLabel("max. tracktype grade");
            tracktypeLabel.setToolTipText("worst tracktype (1-5) the vehicle can still use, 0 for none");
            this.add(tracktypeLabel);
            this.tracktypeTextField = new JTextField();
            vehiclePropertyString = initialParameters.getVehiclePropertyString(VehiclePropertyTypes.MAX_TRACKTYPE);
            if (vehiclePropertyString != null) {
                this.tracktypeTextField.setText(vehiclePropertyString);
            }
            this.tracktypeTextField.setToolTipText("worst tracktype (1-5) the vehicle can still use, 0 for none");
            this.add(this.tracktypeTextField);
        }

        public Map<VehiclePropertyType<?>, String> getVehiclePropertyStrings() {
            String tracktypeString;
            String surfaceString;
            String incDownString;
            HashMap vehiclePropertyStrings = new HashMap();
            String incUpString = this.inclineUpTextField.getText();
            if (incUpString.trim().length() > 0) {
                vehiclePropertyStrings.put(VehiclePropertyTypes.MAX_INCLINE_UP, incUpString);
            }
            if ((incDownString = this.inclineDownTextField.getText()).trim().length() > 0) {
                vehiclePropertyStrings.put(VehiclePropertyTypes.MAX_INCLINE_DOWN, incDownString);
            }
            if ((surfaceString = this.surfaceTextField.getText()).trim().length() > 0) {
                vehiclePropertyStrings.put(VehiclePropertyTypes.SURFACE_BLACKLIST, surfaceString);
            }
            if ((tracktypeString = this.tracktypeTextField.getText()).trim().length() > 0) {
                vehiclePropertyStrings.put(VehiclePropertyTypes.MAX_TRACKTYPE, tracktypeString);
            }
            return vehiclePropertyStrings;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VehiclePropertiesPanel
    extends JPanel {
        private static final int COLS = 2;
        private final Map<VehiclePropertyType<Float>, JTextField> floatPropertyTextFields = new HashMap<VehiclePropertyType<Float>, JTextField>();

        public VehiclePropertiesPanel(PreferenceAccessParameters initialParameters) {
            this.setBorder(BorderFactory.createTitledBorder("vehicle properties"));
            this.setLayout(new GridLayout((1 + FLOAT_PROPERTIES.size()) / 2, 4));
            for (VehiclePropertyType vehicleProperty : FLOAT_PROPERTIES.keySet()) {
                JLabel label = new JLabel((String)FLOAT_PROPERTIES.get(vehicleProperty));
                this.add(label);
                JTextField textField = new JTextField();
                String vehiclePropertyString = initialParameters.getVehiclePropertyString(vehicleProperty);
                if (vehiclePropertyString != null) {
                    textField.setText(vehiclePropertyString);
                }
                this.floatPropertyTextFields.put(vehicleProperty, textField);
                this.add(textField);
            }
        }

        public Map<VehiclePropertyType<?>, String> getVehiclePropertyStrings() {
            HashMap vehiclePropertyStrings = new HashMap();
            for (VehiclePropertyType<Float> vehicleProperty : this.floatPropertyTextFields.keySet()) {
                String textFieldContent = this.floatPropertyTextFields.get(vehicleProperty).getText();
                if (textFieldContent.trim().length() <= 0) continue;
                vehiclePropertyStrings.put(vehicleProperty, textFieldContent);
            }
            return vehiclePropertyStrings;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessTypesPanel
    extends JPanel {
        private static final int COLS = 4;
        private final Map<AccessType, JCheckBox> accessTypeCheckBoxes = new EnumMap<AccessType, JCheckBox>(AccessType.class);

        public AccessTypesPanel(PreferenceAccessParameters initialParameters) {
            this.setBorder(BorderFactory.createTitledBorder("access types"));
            this.setLayout(new GridLayout((3 + AccessType.values().length) / 4, 4));
            for (AccessType accessType : AccessType.values()) {
                JCheckBox checkBox = new JCheckBox(accessType.toString());
                checkBox.setSelected(initialParameters.getAccessTypeUsable(accessType));
                this.accessTypeCheckBoxes.put(accessType, checkBox);
                this.add(checkBox);
            }
        }

        public Collection<AccessType> getUsableAccessTypes() {
            LinkedList<AccessType> usableAccessTypes = new LinkedList<AccessType>();
            for (AccessType accessType : AccessType.values()) {
                if (!this.accessTypeCheckBoxes.get((Object)accessType).isSelected()) continue;
                usableAccessTypes.add(accessType);
            }
            return usableAccessTypes;
        }
    }

    private static class AccessClassPanel
    extends JPanel {
        private final JTextField accessClassTextField;

        public AccessClassPanel(PreferenceAccessParameters initialParameters) {
            this.setBorder(BorderFactory.createTitledBorder("access class"));
            this.setLayout(new BoxLayout(this, 0));
            this.accessClassTextField = new JTextField(initialParameters.getAccessClass());
            this.add(this.accessClassTextField);
        }

        public String getAccessClass() {
            String name = this.accessClassTextField.getText();
            for (char nameChar : name.toCharArray()) {
                if (!FORBIDDEN_CHARS.contains(Character.valueOf(nameChar))) continue;
                JOptionPane.showMessageDialog(this, "Access class must not contain '" + nameChar + "'!");
                return null;
            }
            return name;
        }
    }

    private class BookmarkNamePanel
    extends JPanel {
        private final JTextField bookmarkNameTextField;

        public BookmarkNamePanel(String initialName) {
            this.setBorder(BorderFactory.createTitledBorder("bookmark name"));
            this.setLayout(new BoxLayout(this, 0));
            this.bookmarkNameTextField = new JTextField(initialName);
            this.add(this.bookmarkNameTextField);
        }

        public String getBookmarkName() {
            String name = this.bookmarkNameTextField.getText();
            if (AccessParameterDialog.this.existingBookmarkNames.contains(name)) {
                JOptionPane.showMessageDialog(this, "Bookmark name already exists!");
                return null;
            }
            for (char nameChar : name.toCharArray()) {
                if (!FORBIDDEN_CHARS.contains(Character.valueOf(nameChar))) continue;
                JOptionPane.showMessageDialog(this, "Bookmark name must not contain '" + nameChar + "'!");
                return null;
            }
            return name;
        }
    }

    public static interface BookmarkAction {
        public void execute(String var1, PreferenceAccessParameters var2);
    }
}

