/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedWay
extends Test {
    protected static final int EMPTY_WAY = 301;
    protected static final int UNTAGGED_WAY = 302;
    protected static final int UNNAMED_WAY = 303;
    protected static final int ONE_NODE_WAY = 304;
    protected static final int UNNAMED_JUNCTION = 305;
    protected static final int COMMENTED_WAY = 306;
    private LinkedList<Way> multipolygonways;
    public static final Set<String> NAMED_WAYS = new HashSet<String>();

    public UntaggedWay() {
        super(I18n.tr((String)"Untagged, empty and one node ways."), I18n.tr((String)"This test checks for untagged, empty and one node ways."));
    }

    public void visit(Way w) {
        String highway;
        if (!w.isUsable()) {
            return;
        }
        Map tags = w.getKeys();
        if (tags.size() != 0 && (highway = (String)tags.get("highway")) != null && NAMED_WAYS.contains(highway) && !tags.containsKey("name") && !tags.containsKey("ref")) {
            boolean isRoundabout = false;
            boolean hasName = false;
            for (String key : w.keySet()) {
                boolean bl = hasName = key.startsWith("name:") || key.endsWith("_name") || key.endsWith("_ref");
                if (hasName) break;
                if (!key.equals("junction")) continue;
                isRoundabout = w.get("junction").equals("roundabout");
                break;
            }
            if (!hasName && !isRoundabout) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Unnamed ways"), 303, (OsmPrimitive)w));
            } else if (isRoundabout) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Unnamed junction"), 305, (OsmPrimitive)w));
            }
        }
        if (!w.isTagged() && !this.multipolygonways.contains(w)) {
            if (w.hasKeys()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Untagged ways (commented)"), 306, (OsmPrimitive)w));
            } else {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Untagged ways"), 302, (OsmPrimitive)w));
            }
        }
        if (w.getNodesCount() == 0) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Empty ways"), 301, (OsmPrimitive)w));
        } else if (w.getNodesCount() == 1) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"One node ways"), 304, (OsmPrimitive)w));
        }
    }

    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.multipolygonways = new LinkedList();
        for (Relation r : Main.main.getCurrentDataSet().getRelations()) {
            if (!r.isUsable() || !"multipolygon".equals(r.get("type"))) continue;
            for (RelationMember m : r.getMembers()) {
                if (m.getMember() == null || !(m.getMember() instanceof Way) || !m.getMember().isUsable() || m.getMember().isTagged()) continue;
                this.multipolygonways.add((Way)m.getMember());
            }
        }
    }

    public void endTest() {
        this.multipolygonways = null;
        super.endTest();
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedWay) {
            return testError.getCode() == 301 || testError.getCode() == 304;
        }
        return false;
    }

    public Command fixError(TestError testError) {
        return DeleteCommand.delete((OsmDataLayer)Main.map.mapView.getEditLayer(), testError.getPrimitives());
    }

    static {
        NAMED_WAYS.add("motorway");
        NAMED_WAYS.add("trunk");
        NAMED_WAYS.add("primary");
        NAMED_WAYS.add("secondary");
        NAMED_WAYS.add("tertiary");
        NAMED_WAYS.add("residential");
        NAMED_WAYS.add("pedestrian");
    }
}

