/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.AdvancedSettingsDialog;
import buildings_tools.ToolSettings;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BuildingSizeDialog
extends ExtendedDialog {
    private JFormattedTextField twidth = new JFormattedTextField(NumberFormat.getInstance());
    private JFormattedTextField tlenstep = new JFormattedTextField(NumberFormat.getInstance());
    private JCheckBox caddr = new JCheckBox(I18n.tr((String)"Use Address dialog"));
    private JCheckBox cAutoSelect = new JCheckBox(I18n.tr((String)"Auto-select building"));

    static void addLabelled(JPanel panel, String str, Component c) {
        JLabel label = new JLabel(str);
        panel.add((Component)label, GBC.std());
        label.setLabelFor(c);
        panel.add(c, GBC.eol().fill(2));
    }

    public BuildingSizeDialog() {
        super(Main.parent, I18n.tr((String)"Set buildings size"), new String[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")}, true);
        this.contentInsets = new Insets(15, 15, 5, 15);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        JPanel panel = new JPanel(new GridBagLayout());
        BuildingSizeDialog.addLabelled(panel, I18n.tr((String)"Buildings width:"), this.twidth);
        BuildingSizeDialog.addLabelled(panel, I18n.tr((String)"Length step:"), this.tlenstep);
        panel.add((Component)this.caddr, GBC.eol().fill(2));
        panel.add((Component)this.cAutoSelect, GBC.eol().fill(2));
        this.twidth.setValue(ToolSettings.getWidth());
        this.tlenstep.setValue(ToolSettings.getLenStep());
        this.caddr.setSelected(ToolSettings.isUsingAddr());
        this.cAutoSelect.setSelected(ToolSettings.isAutoSelect());
        JButton bAdv = new JButton(I18n.tr((String)"Advanced..."));
        bAdv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AdvancedSettingsDialog dlg = new AdvancedSettingsDialog();
                if (dlg.getValue() == 1) {
                    dlg.saveSettings();
                }
            }
        });
        panel.add((Component)bAdv, GBC.eol().insets(0, 5, 0, 0).anchor(13));
        this.setContent(panel);
        this.setupDialog();
        this.setVisible(true);
    }

    public double width() {
        try {
            return NumberFormat.getInstance().parse(this.twidth.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public double lenstep() {
        try {
            return NumberFormat.getInstance().parse(this.tlenstep.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public boolean useAddr() {
        return this.caddr.isSelected();
    }

    public void saveSettings() {
        ToolSettings.setSizes(this.width(), this.lenstep());
        ToolSettings.setAddrDialog(this.useAddr());
        ToolSettings.setAutoSelect(this.cAutoSelect.isSelected());
    }
}

