/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurnRestrictionsListModel
extends AbstractListModel {
    private final ArrayList<Relation> turnrestrictions = new ArrayList();
    private DefaultListSelectionModel selectionModel;

    public TurnRestrictionsListModel(DefaultListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public Relation getTurnRestriction(int idx) {
        return this.turnrestrictions.get(idx);
    }

    public void sort() {
        Collections.sort(this.turnrestrictions, new Comparator<Relation>(){
            NameFormatter formatter = DefaultNameFormatter.getInstance();

            @Override
            public int compare(Relation r1, Relation r2) {
                return r1.getDisplayName(this.formatter).compareTo(r2.getDisplayName(this.formatter));
            }
        });
    }

    protected boolean isValid(Relation r) {
        return !r.isDeleted() && r.isVisible() && !r.isIncomplete();
    }

    protected boolean isTurnRestriction(OsmPrimitive primitive) {
        if (primitive == null) {
            return false;
        }
        if (!(primitive instanceof Relation)) {
            return false;
        }
        String type = primitive.get("type");
        return type != null && type.equals("restriction");
    }

    public void setTurnRestrictions(Collection<Relation> turnrestrictions) {
        List<Relation> sel = this.getSelectedTurnRestrictions();
        this.turnrestrictions.clear();
        if (turnrestrictions == null) {
            this.selectionModel.clearSelection();
            this.fireContentsChanged(this, 0, this.getSize());
            return;
        }
        for (Relation r : turnrestrictions) {
            if (!this.isValid(r) || !this.isTurnRestriction((OsmPrimitive)r)) continue;
            this.turnrestrictions.add(r);
        }
        this.sort();
        this.fireIntervalAdded(this, 0, this.getSize());
        this.setSelectedTurnRestrictions(sel);
    }

    public void addTurnRestrictions(Collection<? extends OsmPrimitive> addedPrimitives) {
        boolean added = false;
        for (OsmPrimitive osmPrimitive : addedPrimitives) {
            Relation r;
            if (!this.isTurnRestriction(osmPrimitive) || !this.isValid(r = (Relation)osmPrimitive) || this.turnrestrictions.contains(r)) continue;
            this.turnrestrictions.add(r);
            added = true;
        }
        if (added) {
            List<Relation> sel = this.getSelectedTurnRestrictions();
            this.sort();
            this.fireIntervalAdded(this, 0, this.getSize());
            this.setSelectedTurnRestrictions(sel);
        }
    }

    public void removeTurnRestrictions(Collection<? extends OsmPrimitive> removedPrimitives) {
        if (removedPrimitives == null) {
            return;
        }
        HashSet<Relation> removedTurnRestrictions = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : removedPrimitives) {
            if (!this.isTurnRestriction(osmPrimitive)) continue;
            removedTurnRestrictions.add((Relation)osmPrimitive);
        }
        if (removedTurnRestrictions.isEmpty()) {
            return;
        }
        int size = this.turnrestrictions.size();
        this.turnrestrictions.removeAll(removedTurnRestrictions);
        if (size != this.turnrestrictions.size()) {
            List<Relation> list = this.getSelectedTurnRestrictions();
            this.sort();
            this.fireContentsChanged(this, 0, this.getSize());
            this.setSelectedTurnRestrictions(list);
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this.turnrestrictions.get(index);
    }

    @Override
    public int getSize() {
        return this.turnrestrictions.size();
    }

    public List<Relation> getSelectedNonNewRelations() {
        ArrayList<Relation> ret = new ArrayList<Relation>();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i) || this.turnrestrictions.get(i).isNew()) continue;
            ret.add(this.turnrestrictions.get(i));
        }
        return ret;
    }

    public List<Relation> getSelectedTurnRestrictions() {
        ArrayList<Relation> ret = new ArrayList<Relation>();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ret.add(this.turnrestrictions.get(i));
        }
        return ret;
    }

    public void setSelectedTurnRestrictions(List<Relation> sel) {
        this.selectionModel.clearSelection();
        if (sel == null || sel.isEmpty()) {
            return;
        }
        for (Relation r : sel) {
            int i = this.turnrestrictions.indexOf(r);
            if (i < 0) continue;
            this.selectionModel.addSelectionInterval(i, i);
        }
    }

    public int getTurnRestrictionIndex(Relation tr) {
        int i = this.turnrestrictions.indexOf(tr);
        if (i < 0) {
            return -1;
        }
        return i;
    }
}

