/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class TurnrestrictionTest
extends Test {
    protected static final int NO_VIA = 1801;
    protected static final int NO_FROM = 1802;
    protected static final int NO_TO = 1803;
    protected static final int MORE_VIA = 1804;
    protected static final int MORE_FROM = 1805;
    protected static final int MORE_TO = 1806;
    protected static final int UNKNOWN_ROLE = 1807;
    protected static final int UNKNOWN_TYPE = 1808;
    protected static final int FROM_VIA_NODE = 1809;
    protected static final int TO_VIA_NODE = 1810;
    protected static final int FROM_VIA_WAY = 1811;
    protected static final int TO_VIA_WAY = 1812;

    public TurnrestrictionTest() {
        super(I18n.tr((String)"Turnrestriction"), I18n.tr((String)"This test checks if turnrestrictions are valid"));
    }

    public void visit(Relation r) {
        Node viaNode;
        if (!"restriction".equals(r.get("type"))) {
            return;
        }
        Way fromWay = null;
        Way toWay = null;
        Node via = null;
        boolean morefrom = false;
        boolean moreto = false;
        boolean morevia = false;
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete()) {
                return;
            }
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(r);
            l.add(m.getMember());
            if (m.isWay()) {
                Way w = m.getWay();
                if (w.getNodesCount() < 2) continue;
                if ("from".equals(m.getRole())) {
                    if (fromWay != null) {
                        morefrom = true;
                        continue;
                    }
                    fromWay = w;
                    continue;
                }
                if ("to".equals(m.getRole())) {
                    if (toWay != null) {
                        moreto = true;
                        continue;
                    }
                    toWay = w;
                    continue;
                }
                if ("via".equals(m.getRole())) {
                    if (via != null) {
                        morevia = true;
                        continue;
                    }
                    via = w;
                    continue;
                }
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Unknown role"), 1807, l, Collections.singletonList(m)));
                continue;
            }
            if (m.isNode()) {
                Node n = m.getNode();
                if ("via".equals(m.getRole())) {
                    if (via != null) {
                        morevia = true;
                        continue;
                    }
                    via = n;
                    continue;
                }
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Unknown role"), 1807, l, Collections.singletonList(m)));
                continue;
            }
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Unknown member type"), 1808, l, Collections.singletonList(m)));
        }
        if (morefrom) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"More than one \"from\" way found"), 1805, (OsmPrimitive)r));
        }
        if (moreto) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"More than one \"to\" way found"), 1806, (OsmPrimitive)r));
        }
        if (morevia) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"More than one \"via\" way found"), 1804, (OsmPrimitive)r));
        }
        if (fromWay == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"No \"from\" way found"), 1802, (OsmPrimitive)r));
            return;
        }
        if (toWay == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"No \"to\" way found"), 1803, (OsmPrimitive)r));
            return;
        }
        if (via == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"No \"via\" node or way found"), 1801, (OsmPrimitive)r));
            return;
        }
        if (via instanceof Node) {
            viaNode = via;
            if (!fromWay.isFirstLastNode(viaNode)) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"The \"from\" way does not start or end at a \"via\" node"), 1809, (OsmPrimitive)r));
                return;
            }
            if (!toWay.isFirstLastNode(viaNode)) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"The \"to\" way does not start or end at a \"via\" node"), 1810, (OsmPrimitive)r));
            }
        } else {
            Way viaWay = (Way)via;
            Node firstNode = viaWay.firstNode();
            Node lastNode = viaWay.lastNode();
            Boolean onewayvia = false;
            String onewayviastr = viaWay.get("oneway");
            if (onewayviastr != null) {
                if ("-1".equals(onewayviastr)) {
                    onewayvia = true;
                    Node tmp = firstNode;
                    firstNode = lastNode;
                    lastNode = tmp;
                } else {
                    onewayvia = OsmUtils.getOsmBoolean((String)onewayviastr);
                    if (onewayvia == null) {
                        onewayvia = false;
                    }
                }
            }
            if (fromWay.isFirstLastNode(firstNode)) {
                viaNode = firstNode;
            } else if (!onewayvia.booleanValue() && fromWay.isFirstLastNode(lastNode)) {
                viaNode = lastNode;
            } else {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"The \"from\" way does not start or end at a \"via\" way."), 1811, (OsmPrimitive)r));
                return;
            }
            if (!toWay.isFirstLastNode(viaNode == firstNode ? lastNode : firstNode)) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"The \"to\" way does not start or end at a \"via\" way."), 1812, (OsmPrimitive)r));
            }
        }
    }
}

