/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.ErrorTreeRenderer;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.plugins.validator.util.MultipleNameVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorTreePanel
extends JTree {
    private static final long serialVersionUID = 2952292777351992696L;
    protected DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private List<TestError> errors;
    private Set<OsmPrimitive> filter = null;
    private int updateCount;

    public ErrorTreePanel(List<TestError> errors) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(this.treeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRow(0);
        this.setVisibleRowCount(8);
        this.setCellRenderer(new ErrorTreeRenderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setErrorList(errors);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String res = null;
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof TestError) {
                TestError error = (TestError)nodeInfo;
                MultipleNameVisitor v = new MultipleNameVisitor();
                v.visit(error.getPrimitives());
                res = "<html>" + v.getText() + "<br>" + error.getMessage();
                String d = error.getDescription();
                if (d != null) {
                    res = res + "<br>" + d;
                }
                res = res + "</html>";
            } else {
                res = node.toString();
            }
        }
        return res;
    }

    public ErrorTreePanel() {
        this((List<TestError>)null);
    }

    @Override
    public void setVisible(boolean v) {
        if (v) {
            this.buildTree();
        } else {
            this.treeModel.setRoot(new DefaultMutableTreeNode());
        }
        super.setVisible(v);
    }

    public void buildTree() {
        ++this.updateCount;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        if (this.errors == null || this.errors.isEmpty()) {
            this.treeModel.setRoot(rootNode);
            return;
        }
        HashSet<Object> oldSelectedRows = new HashSet<Object>();
        Enumeration<TreePath> expanded = this.getExpandedDescendants(new TreePath(this.getRoot()));
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                TreePath path = expanded.nextElement();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof Severity) {
                    oldSelectedRows.add(userObject);
                    continue;
                }
                if (!(userObject instanceof String)) continue;
                String msg = (String)userObject;
                msg = msg.substring(0, msg.lastIndexOf(" ("));
                oldSelectedRows.add(msg);
            }
        }
        HashMap errorTree = new HashMap();
        HashMap errorTreeDeep = new HashMap();
        for (Severity s : Severity.values()) {
            errorTree.put(s, new Bag(20));
            errorTreeDeep.put(s, new HashMap());
        }
        for (TestError e : this.errors) {
            if (e.getIgnored().booleanValue()) continue;
            Severity s = e.getSeverity();
            String d = e.getDescription();
            String m = e.getMessage();
            if (this.filter != null) {
                boolean found = false;
                for (OsmPrimitive osmPrimitive : e.getPrimitives()) {
                    if (!this.filter.contains(osmPrimitive)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (d != null) {
                Bag<String, TestError> b = (Bag<String, TestError>)((HashMap)errorTreeDeep.get((Object)s)).get(m);
                if (b == null) {
                    b = new Bag<String, TestError>(20);
                    ((HashMap)errorTreeDeep.get((Object)s)).put(m, b);
                }
                b.add(d, e);
                continue;
            }
            ((Bag)errorTree.get((Object)s)).add(m, e);
        }
        ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
        for (Severity s : Severity.values()) {
            Bag severityErrors = (Bag)errorTree.get((Object)s);
            Map severityErrorsDeep = (Map)errorTreeDeep.get((Object)s);
            if (severityErrors.isEmpty() && severityErrorsDeep.isEmpty()) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode((Object)s);
            rootNode.add(defaultMutableTreeNode);
            if (oldSelectedRows.contains((Object)s)) {
                expandedPaths.add(new TreePath(new Object[]{rootNode, defaultMutableTreeNode}));
            }
            for (Map.Entry msgErrors : severityErrors.entrySet()) {
                List errors = (List)msgErrors.getValue();
                String msg = (String)msgErrors.getKey() + " (" + errors.size() + ")";
                DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(msg);
                defaultMutableTreeNode.add(messageNode);
                if (oldSelectedRows.contains(msgErrors.getKey())) {
                    expandedPaths.add(new TreePath(new Object[]{rootNode, defaultMutableTreeNode, messageNode}));
                }
                for (TestError error : errors) {
                    DefaultMutableTreeNode errorNode = new DefaultMutableTreeNode(error);
                    messageNode.add(errorNode);
                }
            }
            for (Map.Entry bag : severityErrorsDeep.entrySet()) {
                Bag errorlist = (Bag)bag.getValue();
                DefaultMutableTreeNode groupNode = null;
                if (errorlist.size() > 1) {
                    String nmsg = (String)bag.getKey() + " (" + errorlist.size() + ")";
                    groupNode = new DefaultMutableTreeNode(nmsg);
                    defaultMutableTreeNode.add(groupNode);
                    if (oldSelectedRows.contains(bag.getKey())) {
                        expandedPaths.add(new TreePath(new Object[]{rootNode, defaultMutableTreeNode, groupNode}));
                    }
                }
                for (Map.Entry msgErrors : errorlist.entrySet()) {
                    List errors = (List)msgErrors.getValue();
                    String msg = groupNode != null ? (String)msgErrors.getKey() + " (" + errors.size() + ")" : (String)bag.getKey() + " - " + (String)msgErrors.getKey() + " (" + errors.size() + ")";
                    DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(msg);
                    if (groupNode != null) {
                        groupNode.add(messageNode);
                    } else {
                        defaultMutableTreeNode.add(messageNode);
                    }
                    if (oldSelectedRows.contains(msgErrors.getKey())) {
                        if (groupNode != null) {
                            expandedPaths.add(new TreePath(new Object[]{rootNode, defaultMutableTreeNode, groupNode, messageNode}));
                        } else {
                            expandedPaths.add(new TreePath(new Object[]{rootNode, defaultMutableTreeNode, messageNode}));
                        }
                    }
                    for (TestError error : errors) {
                        DefaultMutableTreeNode errorNode = new DefaultMutableTreeNode(error);
                        messageNode.add(errorNode);
                    }
                }
            }
        }
        this.treeModel.setRoot(rootNode);
        for (TreePath path : expandedPaths) {
            this.expandPath(path);
        }
    }

    public void setErrorList(List<TestError> errors) {
        this.errors = errors;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void setErrors(List<TestError> newerrors) {
        if (this.errors == null) {
            return;
        }
        this.errors.clear();
        for (TestError error : newerrors) {
            if (error.getIgnored().booleanValue()) continue;
            this.errors.add(error);
        }
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public List<TestError> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public Set<OsmPrimitive> getFilter() {
        return this.filter;
    }

    public void setFilter(Set<OsmPrimitive> filter) {
        this.filter = filter != null && filter.size() == 0 ? null : filter;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void resetErrors() {
        ArrayList<TestError> e = new ArrayList<TestError>(this.errors);
        this.setErrors(e);
    }

    public void expandAll() {
        DefaultMutableTreeNode root = this.getRoot();
        int row = 0;
        Enumeration<TreeNode> children = root.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            children.nextElement();
            this.expandRow(row++);
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.treeModel.getRoot();
    }

    public int getUpdateCount() {
        return this.updateCount;
    }
}

