/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.roadsigns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.plugins.roadsigns.ParametrizedString;
import org.openstreetmap.josm.plugins.roadsigns.Sign;
import org.openstreetmap.josm.plugins.roadsigns.javacc.ParseException;
import org.openstreetmap.josm.plugins.roadsigns.javacc.TokenMgrError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoadSignsReader {
    public static final String lang = LanguageInfo.getLanguageCodeXML();
    private InputSource inputSource;
    private final boolean debug = false;
    private int unknownLevel;

    public RoadSignsReader(InputStream source) throws IOException {
        this.inputSource = new InputSource(new InputStreamReader(source, "UTF-8"));
    }

    public List<Sign> parse() throws SAXException, IOException {
        SignParser parser = new SignParser();
        parser.allSigns = new ArrayList<Sign>();
        parser.supplementIds = new HashMap<Sign, List<String>>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.newSAXParser().parse(this.inputSource, (DefaultHandler)parser);
            parser.wireSupplements();
            return parser.allSigns;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public static class ExtendedParsingException
    extends SAXException {
        private int columnNumber;
        private int lineNumber;

        public ExtendedParsingException() {
        }

        public ExtendedParsingException(Exception e) {
            super(e);
        }

        public ExtendedParsingException(String message, Exception e) {
            super(message, e);
        }

        public ExtendedParsingException(String message) {
            super(message);
        }

        public ExtendedParsingException rememberLocation(Locator locator) {
            if (locator == null) {
                return this;
            }
            this.columnNumber = locator.getColumnNumber();
            this.lineNumber = locator.getLineNumber();
            return this;
        }

        public String getMessage() {
            String msg = super.getMessage();
            if (this.lineNumber == 0 && this.columnNumber == 0) {
                return msg;
            }
            System.err.println(".");
            if (msg == null) {
                msg = this.getClass().getName();
            }
            msg = msg + " " + I18n.tr((String)"(at line {0}, column {1})", (Object[])new Object[]{this.lineNumber, this.columnNumber});
            return msg;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    private class SignParser
    extends DefaultHandler {
        public List<Sign> allSigns;
        public Map<Sign, List<String>> supplementIds;
        String characters = "";
        List<Sign> folders = new ArrayList<Sign>();
        Sign curSign;
        Sign.Tag curTag;
        private Locator locator;

        private SignParser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String ns, String lname, String qname, Attributes atts) throws SAXException {
            if (RoadSignsReader.this.unknownLevel > 0) {
                RoadSignsReader.this.unknownLevel++;
            } else if (!qname.equals("roadsignpreset")) {
                if (qname.equals("sign")) {
                    if (this.curSign != null) {
                        this.throwException("found sign inside sign");
                    }
                    this.curSign = new Sign();
                    this.supplementIds.put(this.curSign, new ArrayList());
                    try {
                        this.curSign.ref = ParametrizedString.create(atts.getValue("ref"));
                        this.curSign.traffic_sign_tag = ParametrizedString.create(atts.getValue("traffic_sign_tag"));
                    }
                    catch (ParseException ex) {
                        throw new SAXException(ex);
                    }
                    catch (TokenMgrError ex) {
                        this.throwException(ex.toString());
                    }
                    this.curSign.id = atts.getValue("id");
                    if (this.curSign.id == null) {
                        if (this.curSign.ref == null) {
                            this.throwException("Both id and ref attribute missing.");
                        }
                        this.curSign.id = this.curSign.ref.toString();
                    }
                    this.curSign.name = this.getLocalized(atts, "name");
                    if (this.curSign.name == null) {
                        this.throwException("missing attribute: name");
                    }
                    this.curSign.long_name = this.getLocalized(atts, "long_name");
                    String iconURL = atts.getValue("icon");
                    if (iconURL == null) {
                        iconURL = this.curSign.id;
                        iconURL = iconURL.replace(':', '_');
                        iconURL = iconURL.replace('.', '_');
                    }
                    this.curSign.iconURL = iconURL;
                    if ("yes".equals(atts.getValue("supplementary"))) {
                        this.curSign.isSupplementing = true;
                    }
                    this.curSign.wiki = atts.getValue("wiki");
                    this.curSign.loc_wiki = this.getLocalized(atts, "wiki");
                    this.curSign.help = this.getLocalized(atts, "help");
                } else if (this.curSign != null && qname.equals("tag")) {
                    if (this.curSign == null) {
                        this.throwException("found tag outside sign");
                    }
                    if (this.curTag != null) {
                        this.throwException("found tag inside tag");
                    }
                    this.curTag = new Sign.Tag();
                    this.curTag.ident = atts.getValue("ident");
                    this.curTag.tag_ref = atts.getValue("tag_ref");
                    try {
                        this.curTag.key = ParametrizedString.create(atts.getValue("key"));
                        this.curTag.value = ParametrizedString.create(atts.getValue("value"));
                        this.curTag.append_value = ParametrizedString.create(atts.getValue("append_value"));
                        this.curTag.condition = ParametrizedString.create(atts.getValue("condition"));
                    }
                    catch (ParseException ex) {
                        throw new SAXException(ex);
                    }
                    catch (TokenMgrError ex) {
                        throw new SAXException(ex.toString());
                    }
                } else if (this.curSign != null && qname.equals("supplementary")) {
                    this.supplementIds.get(this.curSign).add(this.getMandatoryAttribute(atts, "id"));
                } else if (this.curSign != null && qname.equals("parameter")) {
                    String inputType = this.getMandatoryAttribute(atts, "input");
                    Sign.SignParameter p = new Sign.SignParameter(inputType);
                    p.ident = this.getMandatoryAttribute(atts, "ident");
                    p.deflt = this.getMandatoryAttribute(atts, "default");
                    p.prefix = atts.getValue("prefix");
                    p.suffix = atts.getValue("suffix");
                    String width = atts.getValue("field_width");
                    if (width != null) {
                        p.fieldWidth = Integer.parseInt(width);
                    }
                    this.curSign.params.add(p);
                } else {
                    this.warning("unknown element: " + qname);
                    RoadSignsReader.this.unknownLevel++;
                }
            }
        }

        public void endElement(String ns, String lname, String qname) throws SAXException {
            if (RoadSignsReader.this.unknownLevel > 0) {
                RoadSignsReader.this.unknownLevel--;
            } else if (qname.equals("sign")) {
                this.allSigns.add(this.curSign);
                this.curSign = null;
            } else if (qname.equals("tag")) {
                this.curSign.tags.add(this.curTag);
                this.curTag = null;
            }
            this.characters = this.characters.trim();
            if (!this.characters.equals("")) {
                this.characters = "";
            }
        }

        public void characters(char[] ch, int start, int length) {
            String s = new String(ch, start, length);
            this.characters = this.characters + s;
        }

        private String getLocalized(Attributes atts, String ident) {
            String result = atts.getValue(lang + ident);
            if (result == null) {
                result = atts.getValue(ident);
                if (result == null) {
                    return null;
                }
                result = I18n.tr((String)result);
            }
            return result;
        }

        private String getMandatoryAttribute(Attributes atts, String ident) throws OsmDataParsingException {
            String result = atts.getValue(ident);
            if (result == null) {
                this.throwException("missing attribute: " + ident);
            }
            return result;
        }

        public void error(SAXParseException e) throws SAXException {
            this.throwException(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.throwException(e);
        }

        protected void throwException(Exception e) throws ExtendedParsingException {
            throw new ExtendedParsingException(e).rememberLocation(this.locator);
        }

        protected void throwException(String msg) throws OsmDataParsingException {
            throw new OsmDataParsingException(msg).rememberLocation(this.locator);
        }

        private void warning(String s) {
            try {
                this.throwException(s);
            }
            catch (OsmDataParsingException ex) {
                System.err.println("Warning: " + ex.getMessage());
            }
        }

        public void wireSupplements() throws OsmDataParsingException {
            HashMap<String, Sign> map = new HashMap<String, Sign>();
            for (Sign sign : this.allSigns) {
                if (map.get(sign.id) != null) {
                    this.throwException("Found 2 signs with same ref " + sign.ref);
                }
                map.put(sign.id, sign);
            }
            for (Sign sign : this.allSigns) {
                for (String id : this.supplementIds.get(sign)) {
                    Sign supp = (Sign)map.get(id);
                    if (supp == null) {
                        this.throwException("Missing supplement definition " + id + " for sign " + sign.id + ".");
                    }
                    sign.supplements.add(supp);
                }
            }
        }
    }
}

