/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.GeorefImage;
import wmsplugin.WMSLayer;
import wmsplugin.WMSPlugin;

public abstract class Grabber
extends Thread {
    protected ProjectionBounds b;
    protected Projection proj;
    protected double pixelPerDegree;
    protected MapView mv;
    protected WMSLayer layer;
    protected GeorefImage image;
    protected CacheFiles cache;

    Grabber(ProjectionBounds b, GeorefImage image, MapView mv, WMSLayer layer, CacheFiles cache) {
        if (b.min != null && b.max != null && WMSPlugin.doOverlap) {
            double eastSize = b.max.east() - b.min.east();
            double northSize = b.max.north() - b.min.north();
            double eastCoef = (double)WMSPlugin.overlapEast / 100.0;
            double northCoef = (double)WMSPlugin.overlapNorth / 100.0;
            this.b = new ProjectionBounds(new EastNorth(b.min.east(), b.min.north()), new EastNorth(b.max.east() + eastCoef * eastSize, b.max.north() + northCoef * northSize));
        } else {
            this.b = b;
        }
        this.proj = Main.proj;
        this.pixelPerDegree = layer.pixelPerDegree;
        this.image = image;
        this.mv = mv;
        this.layer = layer;
        this.cache = cache;
    }

    abstract void fetch() throws Exception;

    int width() {
        return (int)((this.b.max.north() - this.b.min.north()) * this.pixelPerDegree);
    }

    int height() {
        return (int)((this.b.max.east() - this.b.min.east()) * this.pixelPerDegree);
    }

    protected void grabError(Exception e) {
        e.printStackTrace();
        BufferedImage img = new BufferedImage(this.width(), this.height(), 2);
        Graphics g = img.getGraphics();
        g.setColor(Color.RED);
        g.fillRect(0, 0, this.width(), this.height());
        Font font = g.getFont();
        Font tempFont = font.deriveFont(0).deriveFont(36.0f);
        g.setFont(tempFont);
        g.setColor(Color.BLACK);
        g.drawString(I18n.tr((String)"Exception occurred"), 10, this.height() / 2);
        this.image.image = img;
        this.image.flushedResizedCachedInstance();
        this.image.failed = true;
        this.image.downloadingStarted = false;
        g.setFont(font);
    }

    protected void grabNotInCache() {
        BufferedImage img = new BufferedImage(this.width(), this.height(), 2);
        Graphics g = img.getGraphics();
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, this.width(), this.height());
        Font font = g.getFont();
        Font tempFont = font.deriveFont(0).deriveFont(36.0f);
        g.setFont(tempFont);
        g.setColor(Color.BLACK);
        g.drawString(I18n.tr((String)"Not in cache"), 10, this.height() / 2);
        this.image.image = img;
        this.image.flushedResizedCachedInstance();
        this.image.infotext = true;
        this.image.downloadingStarted = false;
        g.setFont(font);
    }

    protected void attempt() {
        int maxTries = 5;
        for (int i = 1; i <= maxTries; ++i) {
            try {
                this.fetch();
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(Grabber.random(1000, 2000));
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (i != maxTries) continue;
                this.grabError(e);
                continue;
            }
        }
    }

    public static int random(int min, int max) {
        return (int)(Math.random() * (double)(max + 1 - min)) + min;
    }

    public abstract boolean loadFromCache(boolean var1);
}

