/*
 * Decompiled with CFR 0.152.
 */
package ext_tools.preferences;

import ext_tools.ExtTool;
import ext_tools.ToolsInformation;
import ext_tools.preferences.EditToolDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class MyToolsPanel
extends JPanel {
    ToolsInformation tools;

    public MyToolsPanel(ToolsInformation tools) {
        super(new GridBagLayout());
        this.tools = tools;
    }

    public void refresh() {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        for (final ExtTool tool : this.tools.getToolsList()) {
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            final JCheckBox cbTool = new JCheckBox(tool.getName());
            cbTool.setSelected(tool.isEnabled());
            cbTool.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    tool.setEnabled(cbTool.isSelected());
                }
            });
            this.add((Component)cbTool, gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            gbc.anchor = 13;
            JButton bEdit = new JButton(I18n.tr((String)"Edit"));
            bEdit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    EditToolDialog dlg = new EditToolDialog(tool);
                    ((Dialog)((Object)dlg)).setVisible(true);
                    ((Window)((Object)dlg)).dispose();
                    MyToolsPanel.this.refresh();
                }
            });
            this.add((Component)bEdit, gbc);
            gbc.gridx = 2;
            JButton bDel = new JButton("X");
            bDel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"Delete tool \"{0}\"?", (Object[])new Object[]{tool.name}), I18n.tr((String)"Are you sure?"), 0, 3) == 0) {
                        MyToolsPanel.this.tools.removeTool(tool);
                        MyToolsPanel.this.refresh();
                    }
                }
            });
            this.add((Component)bDel, gbc);
            ++gbc.gridy;
        }
        gbc.gridx = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        JButton bNew = new JButton(I18n.tr((String)"New tool..."));
        bNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExtTool tool = new ExtTool();
                EditToolDialog dlg = new EditToolDialog(tool);
                ((Dialog)((Object)dlg)).setVisible(true);
                ((Window)((Object)dlg)).dispose();
                if (tool.name != null && !"".equals(tool.name)) {
                    MyToolsPanel.this.tools.addTool(tool);
                    tool.setEnabled(true);
                }
                MyToolsPanel.this.refresh();
            }
        });
        this.add((Component)bNew, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new JPanel(), gbc);
        this.revalidate();
        this.repaint();
    }
}

