/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class RelationChecker
extends Test {
    protected static int ROLE_UNKNOWN = 1701;
    protected static int ROLE_EMPTY = 1702;
    protected static int WRONG_TYPE = 1703;
    protected static int HIGH_COUNT = 1704;
    protected static int LOW_COUNT = 1705;
    protected static int ROLE_MISSING = 1706;
    protected static int RELATION_UNKNOWN = 1707;
    protected static int RELATION_EMPTY = 1708;
    static Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr((String)"Relation checker :"), I18n.tr((String)"This plugin checks for errors in relations."));
    }

    public void initialize(OSMValidatorPlugin plugin) throws Exception {
        this.initializePresets();
    }

    public void initializePresets() {
        Collection presets = TaggingPresetPreference.taggingPresets;
        if (presets != null) {
            block0: for (TaggingPreset p : presets) {
                for (TaggingPreset.Item i : p.data) {
                    if (!(i instanceof TaggingPreset.Roles)) continue;
                    relationpresets.add(p);
                    continue block0;
                }
            }
        }
    }

    public void visit(Relation n) {
        LinkedList allroles = new LinkedList();
        for (TaggingPreset p : relationpresets) {
            boolean matches = true;
            TaggingPreset.Roles r = null;
            for (TaggingPreset.Item i : p.data) {
                if (i instanceof TaggingPreset.Key) {
                    TaggingPreset.Key k = (TaggingPreset.Key)i;
                    if (k.value.equals(n.get(k.key))) continue;
                    matches = false;
                    break;
                }
                if (!(i instanceof TaggingPreset.Roles)) continue;
                r = (TaggingPreset.Roles)i;
            }
            if (!matches || r == null) continue;
            allroles.addAll(r.roles);
        }
        if (allroles.size() == 0) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Relation type is unknown"), RELATION_UNKNOWN, (OsmPrimitive)n));
        } else {
            HashMap<String, RoleInfo> map = new HashMap<String, RoleInfo>();
            for (RelationMember m : n.getMembers()) {
                RoleInfo ri;
                String s = "";
                if (m.hasRole()) {
                    s = m.getRole();
                }
                if ((ri = (RoleInfo)map.get(s)) == null) {
                    ri = new RoleInfo();
                }
                ++ri.total;
                if (m.isRelation()) {
                    ++ri.relations;
                } else if (m.isWay()) {
                    ++ri.ways;
                    if (m.getWay().isClosed()) {
                        ++ri.closedways;
                    } else {
                        ++ri.openways;
                    }
                } else if (m.isNode()) {
                    ++ri.nodes;
                }
                map.put(s, ri);
            }
            if (map.size() == 0) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Relation is empty"), RELATION_EMPTY, (OsmPrimitive)n));
            } else {
                LinkedList<String> done = new LinkedList<String>();
                for (TaggingPreset.Roles r : allroles) {
                    String s;
                    long vc;
                    RoleInfo ri;
                    long count;
                    done.add(r.key);
                    String keyname = r.key;
                    if (keyname == "") {
                        keyname = I18n.tr((String)"<empty>");
                    }
                    if ((count = (ri = (RoleInfo)map.get(r.key)) == null ? 0L : (long)ri.total) != (vc = r.getValidCount(count))) {
                        if (count == 0L) {
                            s = I18n.marktr((String)"Role {0} missing");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Role verification problem"), I18n.tr((String)s, (Object[])new Object[]{keyname}), MessageFormat.format(s, keyname), ROLE_MISSING, (OsmPrimitive)n));
                        } else if (vc > count) {
                            s = I18n.marktr((String)"Number of {0} roles too low ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Role verification problem"), I18n.tr((String)s, (Object[])new Object[]{keyname, count}), MessageFormat.format(s, keyname, count), LOW_COUNT, (OsmPrimitive)n));
                        } else {
                            s = I18n.marktr((String)"Number of {0} roles too high ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Role verification problem"), I18n.tr((String)s, (Object[])new Object[]{keyname, count}), MessageFormat.format(s, keyname, count), HIGH_COUNT, (OsmPrimitive)n));
                        }
                    }
                    if (ri == null) continue;
                    if (r.types.contains("way") || !(!r.types.contains("closedway") ? ri.ways > 0 : ri.openways > 0)) {
                        if ((r.types.contains("node") || ri.nodes <= 0) && (r.types.contains("relation") || ri.relations <= 0)) continue;
                    }
                    s = I18n.marktr((String)"Member for role {0} of wrong type");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Role verification problem"), I18n.tr((String)s, (Object[])new Object[]{keyname}), MessageFormat.format(s, keyname), WRONG_TYPE, (OsmPrimitive)n));
                }
                for (String key : map.keySet()) {
                    String s;
                    if (done.contains(key)) continue;
                    if (key.length() > 0) {
                        s = I18n.marktr((String)"Role {0} unknown");
                        this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Role verification problem"), I18n.tr((String)s, (Object[])new Object[]{key}), MessageFormat.format(s, key), ROLE_UNKNOWN, (OsmPrimitive)n));
                        continue;
                    }
                    s = I18n.marktr((String)"Empty role found");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Role verification problem"), I18n.tr((String)s), s, ROLE_EMPTY, (OsmPrimitive)n));
                }
            }
        }
    }

    public class RoleInfo {
        int total = 0;
        int nodes = 0;
        int ways = 0;
        int closedways = 0;
        int openways = 0;
        int relations = 0;
    }
}

