/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import terracer.HouseNumberInputHandler;
import terracer.TerracerRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TerracerAction
extends JosmAction {
    Collection<Command> commands;

    public TerracerAction() {
        super(I18n.tr((String)"Terrace a building"), "terrace", I18n.tr((String)"Creates individual buildings from a long building."), Shortcut.registerShortcut((String)"tools:Terracer", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Terrace a building")}), (int)84, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        class InvalidUserInputException
        extends Exception {
            InvalidUserInputException(String message) {
                super(message);
            }

            InvalidUserInputException() {
            }
        }
        Collection sel = Main.main.getCurrentDataSet().getSelected();
        Way outline = null;
        Way street = null;
        try {
            if (sel.size() == 2) {
                Iterator it = sel.iterator();
                OsmPrimitive prim1 = (OsmPrimitive)it.next();
                OsmPrimitive prim2 = (OsmPrimitive)it.next();
                if (!(prim1 instanceof Way) || !(prim2 instanceof Way)) {
                    throw new InvalidUserInputException();
                }
                Way way1 = (Way)prim1;
                Way way2 = (Way)prim2;
                if (way2.get("highway") != null) {
                    street = way2;
                    outline = way1;
                } else if (way1.get("highway") != null) {
                    street = way1;
                    outline = way2;
                } else {
                    throw new InvalidUserInputException();
                }
                if (street.get("name") == null) {
                    throw new InvalidUserInputException();
                }
            } else if (sel.size() == 1) {
                OsmPrimitive prim = (OsmPrimitive)sel.iterator().next();
                if (!(prim instanceof Way)) {
                    throw new InvalidUserInputException();
                }
                outline = (Way)prim;
            } else {
                throw new InvalidUserInputException();
            }
            if (outline.getNodesCount() < 5) {
                throw new InvalidUserInputException();
            }
            if (!outline.isClosed()) {
                throw new InvalidUserInputException();
            }
        }
        catch (InvalidUserInputException ex) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Select a single, closed way of at least four nodes."));
            return;
        }
        Relation associatedStreet = null;
        if (street != null) {
            block2: for (OsmPrimitive osm : Main.main.getCurrentDataSet().allNonDeletedPrimitives()) {
                Relation rel;
                if (!(osm instanceof Relation) || !"associatedStreet".equals((rel = (Relation)osm).get("type")) || !street.get("name").equals(rel.get("name"))) continue;
                List members = rel.getMembers();
                for (RelationMember m : members) {
                    if (!"street".equals(m.getRole()) || !m.isWay() || !m.getMember().equals((Object)street)) continue;
                    associatedStreet = rel;
                    break block2;
                }
            }
        }
        String title = I18n.trn((String)"Change {0} object", (String)"Change {0} objects", (long)sel.size(), (Object[])new Object[]{sel.size()});
        new HouseNumberInputHandler(this, outline, street, associatedStreet, title);
    }

    public Integer getNumber(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public void terraceBuilding(Way outline, Way street, Relation associatedStreet, Integer segments, String From, String To, int step, String streetName, boolean handleRelations, boolean deleteOutline) {
        int nb;
        Integer to = this.getNumber(To);
        Integer from = this.getNumber(From);
        if (to != null && from != null) {
            nb = 1 + (to - from) / step;
        } else if (segments != null) {
            nb = segments;
        } else {
            throw new TerracerRuntimeException("Could not determine segments from parameters, this is a bug. Parameters were: segments " + segments + " from " + from + " to " + to + " step " + step);
        }
        Node[][] new_nodes = new Node[2][nb + 1];
        this.commands = new LinkedList<Command>();
        LinkedList<Way> ways = new LinkedList<Way>();
        if (nb > 1) {
            int i;
            Pair<Way, Way> interp = this.findFrontAndBack(outline);
            double frontLength = this.wayLength((Way)interp.a);
            double backLength = this.wayLength((Way)interp.b);
            for (i = 0; i <= nb; ++i) {
                new_nodes[0][i] = this.interpolateAlong((Way)interp.a, frontLength * (double)i / (double)nb);
                new_nodes[1][i] = this.interpolateAlong((Way)interp.b, backLength * (double)i / (double)nb);
                this.commands.add((Command)new AddCommand((OsmPrimitive)new_nodes[0][i]));
                this.commands.add((Command)new AddCommand((OsmPrimitive)new_nodes[1][i]));
            }
            for (i = 0; i < nb; ++i) {
                Way terr = new Way();
                terr.addNode(new_nodes[0][i]);
                terr.addNode(new_nodes[0][i + 1]);
                terr.addNode(new_nodes[1][i + 1]);
                terr.addNode(new_nodes[1][i]);
                terr.addNode(new_nodes[0][i]);
                TagCollection.from((Tagged)outline).applyTo((Tagged)terr);
                String number = null;
                if (from != null) {
                    number = Integer.toString(from + i * step);
                }
                terr = this.addressBuilding(terr, street, streetName, number);
                ways.add(terr);
                this.commands.add((Command)new AddCommand((OsmPrimitive)terr));
            }
            if (deleteOutline) {
                this.commands.add(DeleteCommand.delete((OsmDataLayer)Main.main.getEditLayer(), Collections.singleton(outline), (boolean)true, (boolean)true));
            }
        } else {
            Way newOutline = this.addressBuilding(outline, street, streetName, From);
            ways.add(newOutline);
            this.commands.add((Command)new ChangeCommand((OsmPrimitive)outline, (OsmPrimitive)newOutline));
        }
        if (handleRelations) {
            if (associatedStreet == null) {
                associatedStreet = new Relation();
                associatedStreet.put("type", "associatedStreet");
                if (street != null) {
                    associatedStreet.put("name", street.get("name"));
                    associatedStreet.addMember(new RelationMember("street", (OsmPrimitive)street));
                } else {
                    associatedStreet.put("name", streetName);
                }
                for (Way w : ways) {
                    associatedStreet.addMember(new RelationMember("house", (OsmPrimitive)w));
                }
                this.commands.add((Command)new AddCommand((OsmPrimitive)associatedStreet));
            } else {
                Relation newAssociatedStreet = new Relation(associatedStreet);
                for (Way w : ways) {
                    newAssociatedStreet.addMember(new RelationMember("house", (OsmPrimitive)w));
                }
                this.commands.add((Command)new ChangeCommand((OsmPrimitive)associatedStreet, (OsmPrimitive)newAssociatedStreet));
            }
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Terrace"), this.commands));
        if (nb > 1) {
            Main.main.getCurrentDataSet().setSelected(ways);
        } else if (street != null) {
            Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{street});
        }
    }

    private Way addressBuilding(Way outline, Way street, String streetName, String number) {
        Way changedOutline = outline;
        if (number != null) {
            this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)changedOutline, "addr:housenumber", number));
        }
        changedOutline.put("building", "yes");
        if (street != null) {
            this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)changedOutline, "addr:street", street.get("name")));
        } else if (streetName != null) {
            this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)changedOutline, "addr:street", streetName));
        }
        return changedOutline;
    }

    private Node interpolateAlong(Way w, double l) {
        List pairs = w.getNodePairs(false);
        for (int i = 0; i < pairs.size(); ++i) {
            Pair p = (Pair)pairs.get(i);
            double seg_length = ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
            if (l <= seg_length || i == pairs.size() - 1) {
                return this.interpolateNode((Node)p.a, (Node)p.b, l / seg_length);
            }
            l -= seg_length;
        }
        throw new IllegalStateException();
    }

    private double wayLength(Way w) {
        double length = 0.0;
        for (Pair p : w.getNodePairs(false)) {
            length += ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
        }
        return length;
    }

    private Pair<Way, Way> findFrontAndBack(Way w) {
        int i;
        int side2;
        double[] sideness = this.calculateSideness(w);
        int[] indexes = this.sortedIndexes(sideness);
        int side1 = indexes[0];
        if (this.indexDistance(side1, side2 = indexes[1], indexes.length) < 2) {
            side2 = indexes[2];
        }
        if (this.indexDistance(side1, side2, indexes.length) < 2) {
            side2 = indexes[3];
        }
        if (this.sideLength(w, side1) > this.sideLength(w, side1 + 1) && Math.abs(sideness[side1] - sideness[side1 + 1]) < 0.001) {
            ++side1;
            side2 = (side2 + 1) % (w.getNodesCount() - 1);
        }
        if (side1 > side2) {
            int tmp = side2;
            side2 = side1;
            side1 = tmp;
        }
        Way front = new Way();
        Way back = new Way();
        for (i = side2 + 1; i < w.getNodesCount() - 1; ++i) {
            front.addNode(w.getNode(i));
        }
        for (i = 0; i <= side1; ++i) {
            front.addNode(w.getNode(i));
        }
        for (i = side2; i > side1; --i) {
            back.addNode(w.getNode(i));
        }
        return new Pair((Object)front, (Object)back);
    }

    private int indexDistance(int i1, int i2, int n) {
        return Math.min(this.positiveModulus(i1 - i2, n), this.positiveModulus(i2 - i1, n));
    }

    private int positiveModulus(int a, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int res = a % n;
        if (res < 0) {
            res += n;
        }
        return res;
    }

    private double sideLength(Way w, int i) {
        Node a = w.getNode(i);
        Node b = w.getNode((i + 1) % (w.getNodesCount() - 1));
        return a.getCoor().greatCircleDistance(b.getCoor());
    }

    private int[] sortedIndexes(double[] a) {
        int length = a.length;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SortWithIndex
        implements Comparable<SortWithIndex> {
            public double x;
            public int i;

            public SortWithIndex(double a, int b) {
                this.x = a;
                this.i = b;
            }

            @Override
            public int compareTo(SortWithIndex o) {
                return Double.compare(this.x, o.x);
            }
        }
        ArrayList<SortWithIndex> sortable = new ArrayList<SortWithIndex>(length);
        for (int i = 0; i < length; ++i) {
            sortable.add(new SortWithIndex(a[i], i));
        }
        Collections.sort(sortable);
        int[] indexes = new int[length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = ((SortWithIndex)sortable.get((int)i)).i;
        }
        return indexes;
    }

    private double[] calculateSideness(Way w) {
        int length = w.getNodesCount() - 1;
        double[] sideness = new double[length];
        sideness[0] = this.calculateSideness(w.getNode(length - 1), w.getNode(0), w.getNode(1), w.getNode(2));
        for (int i = 1; i < length - 1; ++i) {
            sideness[i] = this.calculateSideness(w.getNode(i - 1), w.getNode(i), w.getNode(i + 1), w.getNode(i + 2));
        }
        sideness[length - 1] = this.calculateSideness(w.getNode(length - 2), w.getNode(length - 1), w.getNode(length), w.getNode(1));
        return sideness;
    }

    private double calculateSideness(Node a, Node b, Node c, Node d) {
        double ndx = b.getCoor().getX() - a.getCoor().getX();
        double pdx = d.getCoor().getX() - c.getCoor().getX();
        double ndy = b.getCoor().getY() - a.getCoor().getY();
        double pdy = d.getCoor().getY() - c.getCoor().getY();
        return (ndx * pdx + ndy * pdy) / Math.sqrt((ndx * ndx + ndy * ndy) * (pdx * pdx + pdy * pdy));
    }

    private Node interpolateNode(Node a, Node b, double f) {
        Node n = new Node(a.getEastNorth().interpolate(b.getEastNorth(), f));
        return n;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null);
    }
}

