/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.EnumMap;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSegment;

public class AlignWaysAlgnSegment
extends AlignWaysSegment {
    private PivotLocations currPivot;
    Map<PivotLocations, EastNorth> pivotList = new EnumMap<PivotLocations, EastNorth>(PivotLocations.class);
    private final Color pivotColor;
    private final Color crossColor = this.pivotColor = Color.YELLOW;

    public AlignWaysAlgnSegment(MapView mapview, Point p) throws IllegalArgumentException {
        super(mapview, p);
        this.setSegment(this.getNearestWaySegment(p));
        this.segmentColor = Color.ORANGE;
    }

    public void setSegment(WaySegment segment) {
        super.setSegment(segment);
        this.setPivots();
    }

    public void updatePivotsEndpoints() {
        this.setPivots(this.currPivot);
        this.setSegmentEndpoints(this.segment);
    }

    private void setPivots(PivotLocations pivotRef) {
        if (this.segment != null) {
            for (PivotLocations pl : PivotLocations.values()) {
                this.pivotList.put(pl, this.getPivotCoord(pl));
            }
            this.setPivotReference(pivotRef);
        } else {
            this.setPivotReference(PivotLocations.NONE);
        }
    }

    private void setPivots() {
        this.setPivots(PivotLocations.CENTRE);
    }

    private void setPivotReference(PivotLocations pp) {
        this.currPivot = pp;
    }

    private EastNorth getPivotCoord(PivotLocations pp) {
        switch (pp) {
            case NONE: {
                return null;
            }
            case NODE1: {
                return this.segment.way.getNode(this.segment.lowerIndex).getEastNorth();
            }
            case NODE2: {
                return this.segment.way.getNode(this.segment.lowerIndex + 1).getEastNorth();
            }
            case CENTRE: {
                return this.getPivotCoord(PivotLocations.NODE1).getCenter(this.getPivotCoord(PivotLocations.NODE2));
            }
        }
        return null;
    }

    public EastNorth getCurrPivotCoord() {
        if (this.segment != null) {
            return this.getPivotCoord(this.currPivot);
        }
        return null;
    }

    public boolean updatePivot(Point clickedPoint) {
        PivotLocations tmpPivot = this.findNearbyPivot(clickedPoint);
        if (tmpPivot != PivotLocations.NONE) {
            this.setPivotReference(tmpPivot);
            return true;
        }
        return false;
    }

    private PivotLocations findNearbyPivot(Point clickedPoint) {
        PivotLocations nearest = PivotLocations.NONE;
        int snapDistance = NavigatableComponent.snapDistance;
        if (this.segment == null) {
            return PivotLocations.NONE;
        }
        for (PivotLocations pl : PivotLocations.values()) {
            if (pl.equals((Object)PivotLocations.NONE) || !(this.mapview.getPoint(this.pivotList.get((Object)pl)).distance(clickedPoint) <= (double)snapDistance)) continue;
            nearest = pl;
            break;
        }
        return nearest;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        super.paint(g, mv, bbox);
        for (PivotLocations pl : PivotLocations.values()) {
            if (pl == PivotLocations.NONE) continue;
            this.highlightCross(g, mv, this.pivotList.get((Object)pl));
        }
        this.highlightPivot(g, mv, this.getPivotCoord(this.currPivot));
    }

    private void highlightPivot(Graphics2D g, MapView mv, EastNorth pivot) {
        g.setColor(this.pivotColor);
        g.setStroke(new BasicStroke());
        Ellipse2D.Double pvCentrePoint = new Ellipse2D.Double(mv.getPoint(pivot).getX() - 5.0, mv.getPoint(pivot).getY() - 5.0, 10.0, 10.0);
        g.fill(pvCentrePoint);
        Ellipse2D.Double pvPoint = new Ellipse2D.Double(mv.getPoint(pivot).getX() - 8.0, mv.getPoint(pivot).getY() - 8.0, 16.0, 16.0);
        g.draw(pvCentrePoint);
        g.draw(pvPoint);
    }

    private void highlightCross(Graphics2D g, MapView mv, EastNorth en) {
        double crossX = mv.getPoint(en).getX();
        double crossY = mv.getPoint(en).getY();
        double crossSize = 10.0;
        Line2D.Double crossV = new Line2D.Double(crossX, crossY - crossSize, crossX, crossY + crossSize);
        Line2D.Double crossH = new Line2D.Double(crossX - crossSize, crossY, crossX + crossSize, crossY);
        g.setColor(this.crossColor);
        g.setStroke(new BasicStroke());
        g.draw(crossV);
        g.draw(crossH);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PivotLocations {
        NONE,
        NODE1,
        NODE2,
        CENTRE;

    }
}

