/*
 * Decompiled with CFR 0.152.
 */
package ext_tools.preferences;

import ext_tools.ExtTool;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class EditToolDialog
extends ExtendedDialog {
    private ExtTool tool;
    private JPanel panel = new JPanel(new GridBagLayout());
    private JTextField name = new JTextField();
    private JTextField cmdline = new JTextField();

    private void addLabelled(String str, Component c) {
        JLabel label = new JLabel(str);
        this.panel.add((Component)label, GBC.std());
        label.setLabelFor(c);
        this.panel.add(c, GBC.eol().fill(2));
    }

    private void load() {
        this.name.setText(this.tool.name);
        this.cmdline.setText(this.tool.cmdline);
    }

    private void save() {
        this.tool.name = this.name.getText();
        this.tool.cmdline = this.cmdline.getText();
    }

    public EditToolDialog(ExtTool tool) {
        super(Main.parent, I18n.tr((String)"Edit tool"), new String[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")}, true);
        this.contentConstraints = GBC.eol().fill().insets(15, 15, 15, 5);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.tool = tool;
        this.addLabelled(I18n.tr((String)"Name:"), this.name);
        this.addLabelled(I18n.tr((String)"CmdLine:"), this.cmdline);
        this.load();
        this.setContent(this.panel);
        this.setupDialog();
    }

    protected void buttonAction(ActionEvent evt) {
        if (evt.getActionCommand().equals(I18n.tr((String)"OK"))) {
            this.save();
        }
        super.buttonAction(evt);
    }
}

