/*
 * Decompiled with CFR 0.152.
 */
package ext_tools;

import ext_tools.ExtTool;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

class ExtToolAction
extends MapMode {
    protected MapMode oldMapMode;
    protected ExtTool tool;

    public ExtToolAction(ExtTool tool) {
        super(I18n.tr((String)tool.name), "empty", tool.description, null, ImageProvider.getCursor((String)"crosshair", null));
        this.tool = tool;
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        this.oldMapMode = Main.map.mapMode;
        super.actionPerformed(e);
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        this.tool.runTool(Main.map.mapView.getLatLon(e.getX(), e.getY()));
        Main.map.selectMapMode(this.oldMapMode);
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }
}

