/*
 * Decompiled with CFR 0.152.
 */
package sk.zdila.josm.plugin.simplify;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyAreaAction
extends JosmAction {
    private static final long serialVersionUID = 6854238214548011750L;

    public SimplifyAreaAction() {
        super(I18n.tr((String)"Simplify Area"), "simplify", I18n.tr((String)"Delete unnecessary nodes from an area."), Shortcut.registerShortcut((String)"tools:simplifyArea", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Simplify Area")}), (int)65, (int)3, (int)1), true);
    }

    private List<Bounds> getCurrentEditBounds() {
        LinkedList<Bounds> bounds = new LinkedList<Bounds>();
        OsmDataLayer dataLayer = Main.map.mapView.getEditLayer();
        for (DataSource ds : dataLayer.data.dataSources) {
            if (ds.bounds == null) continue;
            bounds.add(ds.bounds);
        }
        return bounds;
    }

    private boolean isInBounds(Node node, List<Bounds> bounds) {
        for (Bounds b : bounds) {
            if (!b.contains(node.getCoor())) continue;
            return true;
        }
        return false;
    }

    private boolean confirmWayWithNodesOutsideBoundingBox() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Yes, delete nodes"), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Delete nodes outside of downloaded data regions"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"No, abort"), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Cancel operation"), null)};
        int ret = HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)("<html>" + I18n.trn((String)"The selected way has nodes outside of the downloaded data region.", (String)"The selected ways have nodes outside of the downloaded data region.", (long)this.getCurrentDataSet().getSelectedWays().size()) + "<br>" + I18n.tr((String)"This can lead to nodes being deleted accidentally.") + "<br>" + I18n.tr((String)"Do you want to delete them anyway?") + "</html>"), (String)I18n.tr((String)"Delete nodes outside of data regions?"), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
        return ret == 0;
    }

    private void alertSelectAtLeastOneWay() {
        HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)I18n.tr((String)"Please select at least one way to simplify."), (String)I18n.tr((String)"Warning"), (int)2, null);
    }

    private boolean confirmSimplifyManyWays(int numWays) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Yes"), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Simplify all selected ways"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Cancel"), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Cancel operation"), null)};
        int ret = HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)I18n.tr((String)"The selection contains {0} ways. Are you sure you want to simplify them all?", (Object[])new Object[]{numWays}), (String)I18n.tr((String)"Simplify ways?"), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
        return ret == 0;
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = this.getCurrentDataSet().getSelected();
        List<Bounds> bounds = this.getCurrentEditBounds();
        block0: for (OsmPrimitive prim : selection) {
            if (!(prim instanceof Way) || bounds.size() <= 0) continue;
            Way way = (Way)prim;
            for (Node node : way.getNodes()) {
                if (this.isInBounds(node, bounds)) continue;
                if (this.confirmWayWithNodesOutsideBoundingBox()) continue block0;
                return;
            }
        }
        List ways = OsmPrimitive.getFilteredList((Collection)selection, Way.class);
        if (ways.isEmpty()) {
            this.alertSelectAtLeastOneWay();
            return;
        }
        if (ways.size() > 10 && !this.confirmSimplifyManyWays(ways.size())) {
            return;
        }
        LinkedList<SequenceCommand> allCommands = new LinkedList<SequenceCommand>();
        for (Way way : ways) {
            SequenceCommand simplifyCommand = this.simplifyWay(way);
            if (simplifyCommand == null) continue;
            allCommands.add(simplifyCommand);
        }
        if (!allCommands.isEmpty()) {
            SequenceCommand rootCommand = new SequenceCommand(I18n.trn((String)"Simplify {0} way", (String)"Simplify {0} ways", (long)allCommands.size(), (Object[])new Object[]{allCommands.size()}), allCommands);
            Main.main.undoRedo.add((Command)rootCommand);
            Main.map.repaint();
        }
    }

    private boolean isRequiredNode(Way way, Node node) {
        LinkedList parents = new LinkedList(node.getReferrers());
        parents.remove(way);
        return !parents.isEmpty() || node.isTagged();
    }

    private SequenceCommand simplifyWay(Way w) {
        double angleThreshold = Double.parseDouble(Main.pref.get("simplify-area.angle", "10.0"));
        double distanceTreshold = Double.parseDouble(Main.pref.get("simplify-area.distance", "0.2"));
        double areaTreshold = Double.parseDouble(Main.pref.get("simplify-area.area", "5.0"));
        List nodes = w.getNodes();
        int size = nodes.size();
        if (size == 0) {
            return null;
        }
        ArrayList<MoveCommand> moveCommandList = new ArrayList<MoveCommand>();
        boolean closed = ((Node)nodes.get(0)).equals(nodes.get(size - 1));
        ArrayList<Node> newNodes = new ArrayList<Node>(size);
        if (closed) {
            nodes.remove(size - 1);
        }
        for (int i = 0; i < size; ++i) {
            Node n1;
            boolean closing = closed && i == size - 1;
            Node node = n1 = closing ? (Node)nodes.get(0) : (Node)nodes.get(i);
            if (newNodes.isEmpty()) {
                newNodes.add(n1);
                continue;
            }
            Node n2 = (Node)newNodes.get(newNodes.size() - 1);
            LatLon coord1 = n1.getCoor();
            LatLon coord2 = n2.getCoor();
            if (this.isRequiredNode(w, n1) || this.isRequiredNode(w, n2) || this.computeDistance(coord1, coord2) > distanceTreshold) {
                if (closing) continue;
                newNodes.add(n1);
                continue;
            }
            moveCommandList.add(new MoveCommand(n2, new LatLon((coord1.lat() + coord2.lat()) / 2.0, (coord1.lon() + coord2.lon()) / 2.0)));
            if (!closing) continue;
            newNodes.remove(0);
        }
        int size2 = newNodes.size();
        ArrayList<Object> newNodes2 = new ArrayList<Object>(size2);
        Node prevNode = null;
        LatLon coord1 = null;
        LatLon coord2 = null;
        int len = size2 + 1 + (closed ? 1 : 0);
        for (int i = 0; i < len; ++i) {
            Node n = (Node)newNodes.get(i % size2);
            LatLon coord3 = n.getCoor();
            if (coord1 != null) {
                if (this.isRequiredNode(w, prevNode) || Math.abs(this.computeBearing(coord2, coord3) - this.computeBearing(coord1, coord2)) > angleThreshold || this.computeArea(coord1, coord2, coord3) > areaTreshold) {
                    newNodes2.add(prevNode);
                } else {
                    coord2 = coord1;
                }
            } else if (!closed && prevNode != null) {
                newNodes2.add(prevNode);
            }
            coord1 = coord2;
            coord2 = coord3;
            prevNode = n;
        }
        if (closed) {
            newNodes2.add(newNodes2.get(0));
        }
        HashSet delNodes = new HashSet();
        delNodes.addAll(nodes);
        delNodes.removeAll(newNodes2);
        if (delNodes.isEmpty()) {
            return null;
        }
        LinkedList<Object> cmds = new LinkedList<Object>();
        Way newWay = new Way(w);
        newWay.setNodes(newNodes2);
        cmds.addAll(moveCommandList);
        cmds.add(new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)newWay));
        cmds.add(new DeleteCommand(delNodes));
        return new SequenceCommand(I18n.trn((String)"Simplify Way (remove {0} node)", (String)"Simplify Way (remove {0} nodes)", (long)delNodes.size(), (Object[])new Object[]{delNodes.size()}), cmds);
    }

    private double computeBearing(LatLon coord1, LatLon coord2) {
        double lon1 = Math.toRadians(coord1.getX());
        double lat1 = Math.toRadians(coord1.getY());
        double lon2 = Math.toRadians(coord2.getX());
        double lat2 = Math.toRadians(coord2.getY());
        double dLon = lon2 - lon1;
        double y = Math.sin(dLon) * Math.cos(lat2);
        double x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(dLon);
        return Math.toDegrees(Math.atan2(y, x));
    }

    private double computeDistance(LatLon coord1, LatLon coord2) {
        double lon1 = Math.toRadians(coord1.getX());
        double lon2 = Math.toRadians(coord2.getX());
        double lat1 = Math.toRadians(coord1.getY());
        double lat2 = Math.toRadians(coord2.getY());
        double R = 6378137.0;
        double dLon = lon2 - lon1;
        double dLat = lat2 - lat1;
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6378137.0 * c;
    }

    private double computeArea(LatLon coord1, LatLon coord2, LatLon coord3) {
        double a = this.computeDistance(coord1, coord2);
        double b = this.computeDistance(coord2, coord3);
        double c = this.computeDistance(coord3, coord1);
        double p = (a + b + c) / 2.0;
        return Math.sqrt(p * (p - a) * (p - b) * (p - c));
    }

    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

