/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.BuildingsToolsPlugin;
import buildings_tools.ToolSettings;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.I18n;

class Building {
    private static final double eqlen = 4.0075004E7;
    private final EastNorth[] en = new EastNorth[4];
    double meter = 0.0;
    private double len = 0.0;
    private double width;
    private double heading;
    private boolean angConstrained;
    private double angConstraint = 0.0;

    Building() {
    }

    public void disableAngConstraint() {
        this.angConstrained = false;
    }

    public void setAngConstraint(double angle) {
        this.angConstrained = true;
        this.angConstraint = angle;
    }

    public double getLength() {
        return this.len;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isRectDrawing() {
        return this.angConstrained && ToolSettings.getWidth() == 0.0 && ToolSettings.getLenStep() == 0.0;
    }

    public void reset() {
        this.len = 0.0;
        for (int i = 0; i < 4; ++i) {
            this.en[i] = null;
        }
    }

    public EastNorth getPoint(int num) {
        return this.en[num];
    }

    private void updMetrics() {
        this.meter = Math.PI * 2 / (Math.cos(Math.toRadians(BuildingsToolsPlugin.eastNorth2latlon(this.en[0]).lat())) * 4.0075004E7);
        this.reset();
    }

    public void setBase(EastNorth base) {
        this.en[0] = base;
        this.updMetrics();
    }

    public void setBase(Node base) {
        this.en[0] = BuildingsToolsPlugin.latlon2eastNorth(base.getCoor());
        this.updMetrics();
    }

    private double projection1(EastNorth p) {
        EastNorth vec = this.en[0].sub(p);
        return (Math.sin(this.heading) * vec.east() + Math.cos(this.heading) * vec.north()) / this.meter;
    }

    private double projection2(EastNorth p) {
        EastNorth vec = this.en[0].sub(p);
        return (Math.cos(this.heading) * vec.east() - Math.sin(this.heading) * vec.north()) / this.meter;
    }

    private void updatePos() {
        if (this.len == 0.0) {
            return;
        }
        EastNorth p1 = this.en[0];
        this.en[1] = new EastNorth(p1.east() + Math.sin(this.heading) * this.len * this.meter, p1.north() + Math.cos(this.heading) * this.len * this.meter);
        this.en[2] = new EastNorth(p1.east() + Math.sin(this.heading) * this.len * this.meter + Math.cos(this.heading) * this.width * this.meter, p1.north() + Math.cos(this.heading) * this.len * this.meter - Math.sin(this.heading) * this.width * this.meter);
        this.en[3] = new EastNorth(p1.east() + Math.cos(this.heading) * this.width * this.meter, p1.north() - Math.sin(this.heading) * this.width * this.meter);
    }

    public void setLengthWidth(double length, double width) {
        this.len = length;
        this.width = width;
        this.updatePos();
    }

    public void setWidth(EastNorth p3) {
        this.width = this.projection2(p3);
        this.updatePos();
    }

    public void setPlace(EastNorth p2, double width, double lenstep, boolean ignoreConstraints) {
        if (this.en[0] == null) {
            this.en[0] = p2;
        }
        this.heading = this.en[0].heading(p2);
        double hdang = 0.0;
        if (this.angConstrained && !ignoreConstraints) {
            hdang = Math.round((this.heading - this.angConstraint) / Math.PI * 4.0);
            if ((hdang %= 8.0) < 0.0) {
                hdang += 8.0;
            }
            this.heading = (hdang * Math.PI / 4.0 + this.angConstraint) % (Math.PI * 2);
        }
        this.width = width;
        this.len = this.projection1(p2);
        if (lenstep > 0.0 && !ignoreConstraints) {
            this.len = (double)Math.round(this.len / lenstep) * lenstep;
        }
        this.updatePos();
        Main.map.statusLine.setHeading(Math.toDegrees(this.heading));
        if (this.angConstrained && !ignoreConstraints) {
            Main.map.statusLine.setAngle(hdang * 45.0);
        }
    }

    public void setPlaceRect(EastNorth p2) {
        if (!this.isRectDrawing()) {
            throw new IllegalStateException("Invalid drawing mode");
        }
        this.heading = this.angConstraint;
        this.setLengthWidth(this.projection1(p2), this.projection2(p2));
        Main.map.statusLine.setHeading(Math.toDegrees(this.heading));
    }

    public void angFix(EastNorth point) {
        EastNorth en3 = this.en[2];
        this.heading = this.en[0].heading(point);
        this.setLengthWidth(this.projection1(en3), this.projection2(en3));
        this.en[2] = en3;
    }

    public void paint(Graphics2D g, MapView mv) {
        if (this.len == 0.0) {
            return;
        }
        GeneralPath b = new GeneralPath();
        Point pp1 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[0]));
        Point pp2 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[1]));
        Point pp3 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[2]));
        Point pp4 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[3]));
        b.moveTo(pp1.x, pp1.y);
        b.lineTo(pp2.x, pp2.y);
        b.lineTo(pp3.x, pp3.y);
        b.lineTo(pp4.x, pp4.y);
        b.lineTo(pp1.x, pp1.y);
        g.draw(b);
    }

    private Node findNode(EastNorth en) {
        DataSet ds = Main.main.getCurrentDataSet();
        LatLon l = BuildingsToolsPlugin.eastNorth2latlon(en);
        List nodes = ds.searchNodes(new BBox(l.lon() - 1.0E-5, l.lat() - 1.0E-5, l.lon() + 1.0E-5, l.lat() + 1.0E-5));
        for (Node n : nodes) {
            if (!OsmPrimitive.isUsablePredicate.evaluate((Object)n)) continue;
            return n;
        }
        return null;
    }

    public Way create() {
        if (this.len == 0.0) {
            return null;
        }
        boolean[] created = new boolean[4];
        Node[] nodes = new Node[4];
        for (int i = 0; i < 4; ++i) {
            Node n = this.findNode(this.en[i]);
            if (n == null) {
                nodes[i] = new Node(BuildingsToolsPlugin.eastNorth2latlon(this.en[i]));
                created[i] = true;
            } else {
                nodes[i] = n;
                created[i] = false;
            }
            if (!nodes[i].getCoor().isOutSideWorld()) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot place building outside of the world."));
            return null;
        }
        Way w = new Way();
        w.addNode(nodes[0]);
        if (this.projection1(BuildingsToolsPlugin.latlon2eastNorth(nodes[2].getCoor())) > 0.0) {
            w.addNode(nodes[1]);
            w.addNode(nodes[2]);
            w.addNode(nodes[3]);
        } else {
            w.addNode(nodes[3]);
            w.addNode(nodes[2]);
            w.addNode(nodes[1]);
        }
        w.addNode(nodes[0]);
        w.put("building", ToolSettings.getTag());
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        for (int i = 0; i < 4; ++i) {
            if (!created[i]) continue;
            cmds.add(new AddCommand((OsmPrimitive)nodes[i]));
        }
        cmds.add(new AddCommand((OsmPrimitive)w));
        SequenceCommand c = new SequenceCommand(I18n.tr((String)"Create building"), cmds);
        Main.main.undoRedo.add((Command)c);
        return w;
    }
}

