/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import reverter.PrimitiveIdVersion;

public class UndeletedObjectsStorage
implements MapView.LayerChangeListener,
PropertyChangeListener {
    private final HashMap<DataSet, HashSet<PrimitiveIdVersion>> undeletedPrimitives = new HashMap();

    public boolean haveUndeletedObjects(DataSet dataSet) {
        return this.undeletedPrimitives.containsKey(dataSet);
    }

    public void addPrimitive(DataSet dataSet, PrimitiveIdVersion id) {
        HashSet<PrimitiveIdVersion> set = this.undeletedPrimitives.get(dataSet);
        if (set == null) {
            set = new HashSet();
            this.undeletedPrimitives.put(dataSet, set);
        }
        set.add(id);
    }

    private boolean checkPrimitive(DataSet dataSet, PrimitiveIdVersion id) {
        OsmPrimitive p = dataSet.getPrimitiveById(id.getPrimitiveId());
        if (p == null) {
            return false;
        }
        return p.getVersion() == (long)id.getVersion();
    }

    private void pruneEmptyLayers() {
        Iterator<HashSet<PrimitiveIdVersion>> it = this.undeletedPrimitives.values().iterator();
        while (it.hasNext()) {
            if (!it.next().isEmpty()) continue;
            it.remove();
        }
    }

    private void pruneLayer(DataSet dataSet) {
        HashSet<PrimitiveIdVersion> idSet = this.undeletedPrimitives.get(dataSet);
        Iterator<PrimitiveIdVersion> it = idSet.iterator();
        while (it.hasNext()) {
            if (this.checkPrimitive(dataSet, it.next())) continue;
            it.remove();
        }
    }

    public void pruneObsolete() {
        for (DataSet ds : this.undeletedPrimitives.keySet()) {
            this.pruneLayer(ds);
        }
        this.pruneEmptyLayers();
    }

    public Set<OsmPrimitive> getUndeletedObjects(DataSet dataSet) {
        this.pruneObsolete();
        HashSet<PrimitiveIdVersion> idSet = this.undeletedPrimitives.get(dataSet);
        HashSet<OsmPrimitive> undeleted = new HashSet<OsmPrimitive>();
        if (idSet == null) {
            return undeleted;
        }
        for (PrimitiveIdVersion id : idSet) {
            undeleted.add(dataSet.getPrimitiveById(id.getPrimitiveId()));
        }
        return undeleted;
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (!(newLayer instanceof OsmDataLayer)) {
            return;
        }
        newLayer.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void layerRemoved(Layer oldLayer) {
        if (!(oldLayer instanceof OsmDataLayer)) {
            return;
        }
        oldLayer.addPropertyChangeListener((PropertyChangeListener)this);
        OsmDataLayer dataLayer = (OsmDataLayer)oldLayer;
        if (this.undeletedPrimitives.containsKey(dataLayer.data)) {
            this.undeletedPrimitives.remove(dataLayer.data);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        if (evt.getPropertyName() == OsmDataLayer.REQUIRES_UPLOAD_TO_SERVER_PROP && evt.getOldValue().equals(true) && evt.getNewValue().equals(false)) {
            this.pruneObsolete();
        }
    }
}

