/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.DrawBuildingAction;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BuildingSizeDialog
extends ExtendedDialog {
    private JFormattedTextField twidth = new JFormattedTextField(NumberFormat.getInstance());
    private JFormattedTextField tlenstep = new JFormattedTextField(NumberFormat.getInstance());
    private JPanel panel = new JPanel(new GridBagLayout());
    private JCheckBox caddr = new JCheckBox(I18n.tr((String)"Use Address dialog"));

    private void addLabelled(String str, Component c) {
        JLabel label = new JLabel(str);
        this.panel.add((Component)label, GBC.std());
        label.setLabelFor(c);
        this.panel.add(c, GBC.eol().fill(2));
    }

    public BuildingSizeDialog() {
        super(Main.parent, I18n.tr((String)"Set buildings size"), new String[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")}, true);
        this.contentConstraints = GBC.eol().fill().insets(15, 15, 15, 5);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.addLabelled(I18n.tr((String)"Buildings width:"), this.twidth);
        this.addLabelled(I18n.tr((String)"Length step:"), this.tlenstep);
        this.twidth.setValue(DrawBuildingAction.getWidth());
        this.tlenstep.setValue(DrawBuildingAction.getLenStep());
        this.panel.add((Component)this.caddr, GBC.eol().fill(2));
        this.setContent(this.panel);
        this.setupDialog();
        this.setVisible(true);
    }

    public double width() {
        try {
            return NumberFormat.getInstance().parse(this.twidth.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public double lenstep() {
        try {
            return NumberFormat.getInstance().parse(this.tlenstep.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public boolean useAddr() {
        return this.caddr.isSelected();
    }
}

