/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.Collections;
import java.util.Comparator;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import reverter.UndeletedObjectsStorage;

public class ReverterUploadHook
implements UploadHook {
    private UndeletedObjectsStorage undeletedStorage;

    public ReverterUploadHook(UndeletedObjectsStorage undeletedStorage) {
        this.undeletedStorage = undeletedStorage;
    }

    public boolean checkUpload(APIDataSet apiDataSet) {
        DataSet ds = null;
        if (!apiDataSet.getPrimitivesToAdd().isEmpty()) {
            ds = ((OsmPrimitive)apiDataSet.getPrimitivesToAdd().get(0)).getDataSet();
        } else if (!apiDataSet.getPrimitivesToUpdate().isEmpty()) {
            ds = ((OsmPrimitive)apiDataSet.getPrimitivesToUpdate().get(0)).getDataSet();
        } else if (!apiDataSet.getPrimitivesToDelete().isEmpty()) {
            ds = ((OsmPrimitive)apiDataSet.getPrimitivesToDelete().get(0)).getDataSet();
        }
        if (ds == null) {
            return true;
        }
        Collections.sort(apiDataSet.getPrimitivesToUpdate(), new Comparator<OsmPrimitive>(){

            @Override
            public int compare(OsmPrimitive o1, OsmPrimitive o2) {
                if (o1 instanceof Node && o2 instanceof Node) {
                    return 0;
                }
                if (o1 instanceof Node) {
                    return -1;
                }
                if (o2 instanceof Node) {
                    return 1;
                }
                if (o1 instanceof Way && o2 instanceof Way) {
                    return 0;
                }
                if (o1 instanceof Way && o2 instanceof Relation) {
                    return -1;
                }
                if (o2 instanceof Way && o1 instanceof Relation) {
                    return 1;
                }
                return 0;
            }
        });
        apiDataSet.getPrimitivesToDelete().removeAll(this.undeletedStorage.getUndeletedObjects(ds));
        if (apiDataSet.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No changes to upload."), I18n.tr((String)"Warning"), 1);
            return false;
        }
        return true;
    }
}

