/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import reverter.ChangesetIdQuery;
import reverter.ChangesetReverter;

public class RevertChangesetAction
extends JosmAction {
    public RevertChangesetAction() {
        super(I18n.tr((String)"Revert changeset"), null, I18n.tr((String)"Revert changeset"), Shortcut.registerShortcut((String)"tool:revert", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Revert changeset")}), (int)84, (int)3, (int)1), true);
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (this.getCurrentDataSet() == null) {
            return;
        }
        ChangesetIdQuery dlg = new ChangesetIdQuery();
        dlg.setVisible(true);
        if (dlg.getValue() != 1) {
            return;
        }
        final int changesetId = dlg.ChangesetId();
        if (changesetId == 0) {
            return;
        }
        Main.worker.submit((Runnable)new PleaseWaitRunnable(I18n.tr((String)"Reverting...")){
            private ChangesetReverter rev;
            private boolean downloadConfirmed;
            {
                super($anonymous0);
                this.downloadConfirmed = false;
            }

            private boolean checkMissing() throws OsmTransferException {
                if (!this.rev.haveMissingObjects()) {
                    return true;
                }
                if (!this.downloadConfirmed) {
                    boolean bl = this.downloadConfirmed = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"This changeset have objects that doesn't present in current dataset.\nIt is needed to download them before reverting. Do you want to continue?"), I18n.tr((String)"Confirm"), 0) == 0;
                    if (!this.downloadConfirmed) {
                        return false;
                    }
                }
                PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr((String)"Fetching missing primitives"));
                try {
                    this.rev.downloadMissingPrimitives((ProgressMonitor)monitor);
                }
                finally {
                    monitor.close();
                }
                return true;
            }

            protected void realRun() throws OsmTransferException {
                this.progressMonitor.indeterminateSubTask("Downloading changeset");
                this.rev = new ChangesetReverter(changesetId, NullProgressMonitor.INSTANCE);
                if (this.progressMonitor.isCancelled()) {
                    return;
                }
                if (!this.checkMissing()) {
                    return;
                }
                this.rev.downloadObjectsHistory(this.progressMonitor.createSubTaskMonitor(-1, false));
                if (this.progressMonitor.isCancelled()) {
                    return;
                }
                if (!this.checkMissing()) {
                    return;
                }
                List<Command> cmds = this.rev.getCommands();
                SequenceCommand cmd = new SequenceCommand(I18n.tr((String)"Revert changeset #{0}", (Object[])new Object[]{changesetId}), cmds);
                Main.main.undoRedo.add((Command)cmd);
            }

            protected void cancel() {
            }

            protected void finish() {
            }
        });
    }
}

