/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.ConflictAddCommand;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.history.RelationMember;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import reverter.DataSetToCmd;
import reverter.OsmServerMultiObjectReader;

public class ChangesetReverter {
    public final int changesetId;
    public final Changeset changeset;
    private final OsmDataLayer layer;
    private final DataSet ds;
    private final ChangesetDataSet cds;
    private DataSet nds;
    private final HashSet<PrimitiveId> missing = new HashSet();
    private final HashSet<HistoryOsmPrimitive> created = new HashSet();
    private final HashSet<HistoryOsmPrimitive> updated = new HashSet();
    private final HashSet<HistoryOsmPrimitive> deleted = new HashSet();

    private void addIfMissing(PrimitiveId id) {
        OsmPrimitive p = this.ds.getPrimitiveById(id);
        if (p == null || p.isIncomplete()) {
            this.missing.add(id);
        }
    }

    private void addMissingHistoryIds(Iterable<HistoryOsmPrimitive> primitives) {
        for (HistoryOsmPrimitive p : primitives) {
            this.addIfMissing(p.getPrimitiveId());
            if (p.getType() == OsmPrimitiveType.WAY) {
                Iterator iterator = ((HistoryWay)p).getNodes().iterator();
                while (iterator.hasNext()) {
                    long nd = (Long)iterator.next();
                    this.addIfMissing((PrimitiveId)new SimplePrimitiveId(nd, OsmPrimitiveType.NODE));
                }
            }
            if (p.getType() != OsmPrimitiveType.RELATION) continue;
            for (RelationMember member : ((HistoryRelation)p).getMembers()) {
                this.addIfMissing((PrimitiveId)new SimplePrimitiveId(member.getPrimitiveId(), member.getPrimitiveType()));
            }
        }
    }

    private void addMissingIds(Iterable<OsmPrimitive> primitives) {
        for (OsmPrimitive p : primitives) {
            this.addIfMissing((PrimitiveId)p);
            if (p.getType() == OsmPrimitiveType.WAY) {
                for (Node nd : ((Way)p).getNodes()) {
                    this.addIfMissing((PrimitiveId)nd);
                }
            }
            if (p.getType() != OsmPrimitiveType.RELATION) continue;
            for (org.openstreetmap.josm.data.osm.RelationMember member : ((Relation)p).getMembers()) {
                this.addIfMissing((PrimitiveId)member.getMember());
            }
        }
    }

    public ChangesetReverter(int changesetId, ProgressMonitor monitor) throws OsmTransferException {
        this.changesetId = changesetId;
        this.layer = Main.main.getEditLayer();
        this.ds = this.layer.data;
        OsmServerChangesetReader csr = new OsmServerChangesetReader();
        monitor.beginTask("", 2);
        try {
            this.changeset = csr.readChangeset((long)changesetId, monitor.createSubTaskMonitor(1, false));
            this.cds = csr.downloadChangeset(changesetId, monitor.createSubTaskMonitor(1, false));
        }
        finally {
            monitor.finishTask();
        }
        for (ChangesetDataSet.ChangesetDataSetEntry entry : this.cds) {
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.CREATED) {
                this.created.add(entry.getPrimitive());
                continue;
            }
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.UPDATED) {
                this.updated.add(entry.getPrimitive());
                continue;
            }
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.DELETED) {
                this.deleted.add(entry.getPrimitive());
                continue;
            }
            throw new AssertionError();
        }
        this.missing.clear();
        this.addMissingHistoryIds(this.created);
        this.addMissingHistoryIds(this.updated);
    }

    public void downloadObjectsHistory(ProgressMonitor progressMonitor) throws OsmTransferException {
        OsmServerMultiObjectReader rdr = new OsmServerMultiObjectReader();
        progressMonitor.beginTask("Downloading objects history", this.updated.size() + this.deleted.size() + 1);
        try {
            for (HistoryOsmPrimitive entry : this.updated) {
                rdr.ReadObject(entry.getPrimitiveId(), (int)entry.getVersion() - 1, progressMonitor.createSubTaskMonitor(1, true));
                if (!progressMonitor.isCancelled()) continue;
                return;
            }
            for (HistoryOsmPrimitive entry : this.deleted) {
                rdr.ReadObject(entry.getPrimitiveId(), (int)entry.getVersion() - 1, progressMonitor.createSubTaskMonitor(1, true));
                if (!progressMonitor.isCancelled()) continue;
                return;
            }
            this.nds = rdr.parseOsm(progressMonitor.createSubTaskMonitor(1, true));
            this.addMissingIds(this.nds.allPrimitives());
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void downloadMissingPrimitives(ProgressMonitor monitor) throws OsmTransferException {
        MultiFetchServerObjectReader rdr = new MultiFetchServerObjectReader();
        for (PrimitiveId id : this.missing) {
            switch (id.getType()) {
                case NODE: {
                    rdr.append(new Node(id.getUniqueId()));
                    break;
                }
                case WAY: {
                    rdr.append(new Way(id.getUniqueId()));
                    break;
                }
                case RELATION: {
                    rdr.append(new Relation(id.getUniqueId()));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.layer.mergeFrom(rdr.parseOsm(monitor));
        this.missing.clear();
    }

    public List<Command> getCommands() {
        if (this.nds == null) {
            return null;
        }
        LinkedList<OsmPrimitive> toDelete = new LinkedList<OsmPrimitive>();
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (OsmPrimitive p : this.nds.allPrimitives()) {
            Conflict c;
            if (p.isIncomplete()) continue;
            OsmPrimitive dp = this.ds.getPrimitiveById((PrimitiveId)p);
            if (dp == null) {
                throw new IllegalStateException(I18n.tr((String)"Missing merge target for {0} with id {1}", (Object[])new Object[]{p.getType(), p.getUniqueId()}));
            }
            if (!p.isVisible()) {
                toDelete.add(dp);
            }
            if (p.getVersion() == dp.getVersion() || !p.isVisible() && !dp.isVisible()) continue;
            switch (dp.getType()) {
                case NODE: {
                    c = new Conflict((OsmPrimitive)((Node)p), (OsmPrimitive)new Node((Node)dp), !p.isVisible());
                    break;
                }
                case WAY: {
                    c = new Conflict((OsmPrimitive)((Way)p), (OsmPrimitive)new Way((Way)dp), !p.isVisible());
                    break;
                }
                case RELATION: {
                    c = new Conflict((OsmPrimitive)((Relation)p), (OsmPrimitive)new Relation((Relation)dp), !p.isVisible());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            cmds.add((Command)new ConflictAddCommand(this.layer, c));
        }
        cmds.addAll(new DataSetToCmd(this.nds, this.ds).getCommandList());
        for (HistoryOsmPrimitive id : this.created) {
            OsmPrimitive p = this.ds.getPrimitiveById(id.getPrimitiveId());
            if (p == null) continue;
            toDelete.add(p);
        }
        List list = OsmPrimitive.getFilteredList(toDelete, Relation.class);
        if (!list.isEmpty()) {
            cmds.add((Command)new DeleteCommand((Collection)list));
        }
        if (!(list = OsmPrimitive.getFilteredList(toDelete, Way.class)).isEmpty()) {
            cmds.add((Command)new DeleteCommand((Collection)list));
        }
        if (!(list = OsmPrimitive.getFilteredList(toDelete, Node.class)).isEmpty()) {
            cmds.add((Command)new DeleteCommand((Collection)list));
        }
        return cmds;
    }

    public boolean haveMissingObjects() {
        return !this.missing.isEmpty();
    }
}

