/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.ArrayList;
import java.util.LinkedList;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

final class DataSetToCmd {
    private final DataSet sourceDataSet;
    private final DataSet targetDataSet;
    private final LinkedList<Command> cmds = new LinkedList();

    public DataSetToCmd(DataSet sourceDataSet, DataSet targetDataSet) {
        this.sourceDataSet = sourceDataSet;
        this.targetDataSet = targetDataSet;
        this.merge();
    }

    private void mergePrimitive(OsmPrimitive source) {
        Node newTarget;
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        OsmPrimitive target = this.getMergeTarget(source);
        if (target.getVersion() == 0L) {
            throw new IllegalStateException(I18n.tr((String)"Target of type {0} with id {1} have invalid version", (Object[])new Object[]{target.getType(), target.getUniqueId()}));
        }
        switch (target.getType()) {
            case NODE: {
                newTarget = new Node((Node)target);
                break;
            }
            case WAY: {
                newTarget = new Way((Way)target);
                break;
            }
            case RELATION: {
                newTarget = new Relation((Relation)target);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        newTarget.mergeFrom(source);
        newTarget.setOsmId(target.getId(), (int)target.getVersion());
        newTarget.setDeleted(false);
        this.cmds.add((Command)new ChangeCommand(target, (OsmPrimitive)newTarget));
    }

    private OsmPrimitive getMergeTarget(OsmPrimitive mergeSource) {
        OsmPrimitive p = this.targetDataSet.getPrimitiveById(mergeSource.getId(), mergeSource.getType());
        if (p == null) {
            throw new IllegalStateException(I18n.tr((String)"Missing merge target of type {0} with id {1}", (Object[])new Object[]{mergeSource.getType(), mergeSource.getUniqueId()}));
        }
        return p;
    }

    public void fixReferences() {
        for (Way w : this.sourceDataSet.getWays()) {
            this.mergeNodeList(w);
        }
        for (Relation r : this.sourceDataSet.getRelations()) {
            this.mergeRelationMembers(r);
        }
    }

    private void mergeNodeList(Way source) throws IllegalStateException {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Way target = (Way)this.getMergeTarget((OsmPrimitive)source);
        ArrayList<Node> newNodes = new ArrayList<Node>(source.getNodesCount());
        for (Node sourceNode : source.getNodes()) {
            Node targetNode = (Node)this.getMergeTarget((OsmPrimitive)sourceNode);
            newNodes.add(targetNode);
        }
        this.cmds.add((Command)new ChangeNodesCommand(target, newNodes));
    }

    private void mergeRelationMembers(Relation source) throws IllegalStateException {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Relation target = (Relation)this.getMergeTarget((OsmPrimitive)source);
        LinkedList<RelationMember> newMembers = new LinkedList<RelationMember>();
        for (RelationMember sourceMember : source.getMembers()) {
            OsmPrimitive targetMember = this.getMergeTarget(sourceMember.getMember());
            newMembers.add(new RelationMember(sourceMember.getRole(), targetMember));
        }
        Relation newRelation = new Relation(target);
        newRelation.setMembers(newMembers);
        this.cmds.add((Command)new ChangeCommand((OsmPrimitive)target, (OsmPrimitive)newRelation));
    }

    private void merge() {
        for (Node node : this.sourceDataSet.getNodes()) {
            this.mergePrimitive((OsmPrimitive)node);
        }
        for (Way way : this.sourceDataSet.getWays()) {
            this.mergePrimitive((OsmPrimitive)way);
        }
        for (Relation relation : this.sourceDataSet.getRelations()) {
            this.mergePrimitive((OsmPrimitive)relation);
        }
        this.fixReferences();
    }

    public LinkedList<Command> getCommandList() {
        return this.cmds;
    }
}

