/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class UnclosedWays
extends Test {
    Bag<Way, Way> _errorWays;
    private String type;
    private String etype;
    private int mode;

    public UnclosedWays() {
        super(I18n.tr((String)"Unclosed Ways."), I18n.tr((String)"This tests if ways which should be circular are closed."));
    }

    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this._errorWays = new Bag();
    }

    public void endTest() {
        this._errorWays = null;
        super.endTest();
    }

    public void set(int m, String text, String desc) {
        this.etype = MessageFormat.format(text, desc);
        this.type = I18n.tr((String)text, (Object[])new Object[]{I18n.tr((String)desc)});
        this.mode = m;
    }

    public void set(int m, String text) {
        this.etype = text;
        this.type = I18n.tr((String)text);
        this.mode = m;
    }

    public void visit(Way w) {
        Boolean btest;
        this.etype = null;
        this.type = null;
        this.mode = 0;
        if (!w.isUsable()) {
            return;
        }
        String test = w.get("natural");
        if (test != null && !"coastline".equals(test) && !"cliff".equals(test)) {
            this.set(1101, I18n.marktr((String)"natural type {0}"), test);
        }
        if ((test = w.get("landuse")) != null) {
            this.set(1102, I18n.marktr((String)"landuse type {0}"), test);
        }
        if ((test = w.get("amenities")) != null) {
            this.set(1103, I18n.marktr((String)"amenities type {0}"), test);
        }
        if ((test = w.get("sport")) != null && !test.equals("water_slide")) {
            this.set(1104, I18n.marktr((String)"sport type {0}"), test);
        }
        if ((test = w.get("tourism")) != null) {
            this.set(1105, I18n.marktr((String)"tourism type {0}"), test);
        }
        if ((test = w.get("shop")) != null) {
            this.set(1106, I18n.marktr((String)"shop type {0}"), test);
        }
        if ((test = w.get("leisure")) != null) {
            this.set(1107, I18n.marktr((String)"leisure type {0}"), test);
        }
        if ((test = w.get("waterway")) != null && test.equals("riverbank")) {
            this.set(1108, I18n.marktr((String)"waterway type {0}"), test);
        }
        if ((btest = OsmUtils.getOsmBoolean((String)w.get("building"))) != null && btest.booleanValue()) {
            this.set(1120, I18n.marktr((String)"building"));
        }
        if ((btest = OsmUtils.getOsmBoolean((String)w.get("area"))) != null && btest.booleanValue()) {
            this.set(1130, I18n.marktr((String)"area"));
        }
        if (this.type != null && !w.isClosed()) {
            for (OsmPrimitive parent : w.getReferrers()) {
                if (!(parent instanceof Relation) || !"multipolygon".equals(parent.get("type"))) continue;
                return;
            }
            Node f = w.firstNode();
            Node l = w.lastNode();
            ArrayList<Way> primitives = new ArrayList<Way>();
            ArrayList<Node> highlight = new ArrayList<Node>();
            primitives.add(w);
            highlight.add(f);
            highlight.add(l);
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Unclosed way"), this.type, this.etype, this.mode, primitives, highlight));
            this._errorWays.add(w, w);
        }
    }
}

