/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.plugins.alignways.AlignWaysRotateCommand;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AlignWaysAction
extends JosmAction {
    private static final long serialVersionUID = -1540319652562985458L;

    public AlignWaysAction() {
        super(I18n.tr((String)"Align Way Segments"), "alignways", I18n.tr((String)"Makes a pair of selected way segments parallel by rotating one of them around a chosen pivot."), Shortcut.registerShortcut((String)"tools:alignways", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Align Ways")}), (int)65, (int)3, (int)1), true);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        Command c;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getCurrentDataSet() == null) {
            return;
        }
        Collection selection = this.getCurrentDataSet().getSelected();
        Collection affectedNodes = AllNodesVisitor.getAllNodes((Collection)selection);
        Command command = c = !Main.main.undoRedo.commands.isEmpty() ? (Command)Main.main.undoRedo.commands.getLast() : null;
        if (!(c instanceof AlignWaysRotateCommand) || !((Object)affectedNodes).equals(((AlignWaysRotateCommand)c).getRotatedNodes())) {
            c = new AlignWaysRotateCommand();
            Main.main.undoRedo.add(c);
        }
        if (((AlignWaysRotateCommand)c).areSegsConnected()) {
            ((AlignWaysRotateCommand)c).undoCommand();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"You cannot align connected segments.\nPlease select two segments that don''t share any nodes."), I18n.tr((String)"AlignWayS message"), 2);
            return;
        }
        for (Node n : affectedNodes) {
            if (!n.getCoor().isOutSideWorld()) continue;
            ((AlignWaysRotateCommand)c).undoCommand();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Aligning would result nodes outside the world.Your action is being reverted."), I18n.tr((String)"AlignWayS message"), 2);
            return;
        }
        Main.map.mapView.repaint();
    }
}

