/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.visualisation;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.graph.GraphEdge;
import org.openstreetmap.josm.plugins.graphview.core.graph.GraphNode;
import org.openstreetmap.josm.plugins.graphview.core.property.GraphEdgeSegments;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadPropertyType;
import org.openstreetmap.josm.plugins.graphview.core.transition.Segment;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.ColorScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatPropertyColorScheme
implements ColorScheme {
    private final Class<? extends RoadPropertyType<Float>> propertyClass;
    private final Map<Float, Color> colorMap;
    private final Color defaultColor;

    public FloatPropertyColorScheme(Class<? extends RoadPropertyType<Float>> propertyClass, Map<Float, Color> colorMap, Color defaultColor) {
        assert (propertyClass != null && colorMap != null && defaultColor != null);
        this.propertyClass = propertyClass;
        this.colorMap = new HashMap<Float, Color>(colorMap);
        this.defaultColor = defaultColor;
    }

    @Override
    public Color getSegmentColor(Segment segment) {
        assert (segment != null);
        Float propertyValue = null;
        Collection<RoadPropertyType<?>> availableProperties = segment.getAvailableProperties();
        for (RoadPropertyType<?> property : availableProperties) {
            if (!this.propertyClass.isInstance(property)) continue;
            RoadPropertyType<?> floatProperty = property;
            propertyValue = (Float)segment.getPropertyValue(floatProperty);
            break;
        }
        if (propertyValue != null) {
            return this.getColorForValue(propertyValue);
        }
        return this.defaultColor;
    }

    @Override
    public Color getNodeColor(GraphNode node) {
        List<Segment> edgeSegments;
        ArrayList<Color> segmentColors = new ArrayList<Color>();
        for (GraphEdge edge : node.getInboundEdges()) {
            edgeSegments = edge.getPropertyValue(GraphEdgeSegments.PROPERTY);
            if (edgeSegments.size() <= 0) continue;
            Segment firstSegment = edgeSegments.get(0);
            segmentColors.add(this.getSegmentColor(firstSegment));
        }
        for (GraphEdge edge : node.getOutboundEdges()) {
            edgeSegments = edge.getPropertyValue(GraphEdgeSegments.PROPERTY);
            if (edgeSegments.size() <= 0) continue;
            Segment lastSegment = edgeSegments.get(edgeSegments.size() - 1);
            segmentColors.add(this.getSegmentColor(lastSegment));
        }
        if (segmentColors.size() > 0) {
            return FloatPropertyColorScheme.averageColor(segmentColors);
        }
        return Color.WHITE;
    }

    protected Color getColorForValue(Float value) {
        assert (value != null);
        if (this.colorMap.containsKey(value)) {
            return this.colorMap.get(value);
        }
        LinkedList<Float> valuesWithDefinedColor = new LinkedList<Float>(this.colorMap.keySet());
        Collections.sort(valuesWithDefinedColor);
        if (value.floatValue() <= valuesWithDefinedColor.getFirst().floatValue()) {
            return this.colorMap.get(valuesWithDefinedColor.getFirst());
        }
        if (value.floatValue() >= valuesWithDefinedColor.getLast().floatValue()) {
            return this.colorMap.get(valuesWithDefinedColor.getLast());
        }
        Float lowerValue = valuesWithDefinedColor.getFirst();
        Float higherValue = null;
        for (Float v : valuesWithDefinedColor) {
            if (v.floatValue() >= value.floatValue()) {
                higherValue = v;
                break;
            }
            lowerValue = v;
        }
        assert (lowerValue != null && higherValue != null);
        Color lowerColor = this.colorMap.get(lowerValue);
        Color higherColor = this.colorMap.get(higherValue);
        float weightHigherColor = (value.floatValue() - lowerValue.floatValue()) / (higherValue.floatValue() - lowerValue.floatValue());
        return FloatPropertyColorScheme.weightedAverageColor(lowerColor, higherColor, weightHigherColor);
    }

    private static Color averageColor(List<Color> colors) {
        assert (colors != null && colors.size() > 0);
        float weightPerColor = 1.0f / (float)colors.size();
        Color average = new Color(0, 0, 0);
        for (Color color : colors) {
            average = new Color(Math.min(Math.round((float)average.getRed() + weightPerColor * (float)color.getRed()), 255), Math.min(Math.round((float)average.getGreen() + weightPerColor * (float)color.getGreen()), 255), Math.min(Math.round((float)average.getBlue() + weightPerColor * (float)color.getBlue()), 255));
        }
        return average;
    }

    private static Color weightedAverageColor(Color color1, Color color2, float weightColor2) {
        assert (color1 != null && color2 != null);
        assert (0.0f <= weightColor2 && weightColor2 <= 1.0f);
        return new Color(Math.round((1.0f - weightColor2) * (float)color1.getRed() + weightColor2 * (float)color2.getRed()), Math.round((1.0f - weightColor2) * (float)color1.getGreen() + weightColor2 * (float)color2.getGreen()), Math.round((1.0f - weightColor2) * (float)color1.getBlue() + weightColor2 * (float)color2.getBlue()));
    }
}

