/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_logo_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_marquee_option_t;
import uk.co.caprica.vlcj.binding.internal.media_duration_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_length_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_position_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_time_changed;
import uk.co.caprica.vlcj.player.FullScreenStrategy;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.VideoMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MediaPlayer {
    private static final Logger LOG = Logger.getLogger(MediaPlayer.class);
    private static final int VOUT_WAIT_PERIOD = 1000;
    protected final LibVlc libvlc = LibVlc.LOGGING_INSTANCE;
    private final List<MediaPlayerEventListener> eventListenerList = new ArrayList<MediaPlayerEventListener>();
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final ExecutorService metaService = Executors.newSingleThreadExecutor();
    private final FullScreenStrategy fullScreenStrategy;
    private libvlc_instance_t instance;
    private libvlc_media_player_t mediaPlayerInstance;
    private libvlc_event_manager_t mediaPlayerEventManager;
    private libvlc_callback_t callback;
    private String[] standardMediaOptions;
    private Canvas videoSurface;
    private volatile boolean released;

    public MediaPlayer(libvlc_instance_t instance) {
        this(null, instance);
    }

    public MediaPlayer(FullScreenStrategy fullScreenStrategy, libvlc_instance_t instance) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MediaPlayer(fullScreenStrategy=" + fullScreenStrategy + ",instance=" + (Object)((Object)instance) + ")"));
        }
        this.fullScreenStrategy = fullScreenStrategy;
        this.instance = instance;
        this.createInstance();
    }

    public void addMediaPlayerEventListener(MediaPlayerEventListener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMediaPlayerEventListener(listener=" + listener + ")"));
        }
        this.eventListenerList.add(listener);
    }

    public void removeMediaPlayerEventListener(MediaPlayerEventListener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removeMediaPlayerEventListener(listener=" + listener + ")"));
        }
        this.eventListenerList.remove(listener);
    }

    public void setStandardMediaOptions(String ... options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setStandardMediaOptions(options=" + Arrays.toString(options) + ")"));
        }
        this.standardMediaOptions = options;
    }

    public void setVideoSurface(Canvas videoSurface) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setVideoSurface(videoSurface=" + videoSurface + ")"));
        }
        this.videoSurface = videoSurface;
    }

    public void playMedia(String media) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("playMedia(media=" + media + ")"));
        }
        this.playMedia(media, new String[]{null});
    }

    public void playMedia(String media, String ... mediaOptions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("playMedia(media=" + media + ",mediaOptions=" + Arrays.toString(mediaOptions) + ")"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("videoSurface=" + this.videoSurface));
        }
        if (this.videoSurface == null) {
            throw new IllegalStateException("Must set a video surface");
        }
        this.nativeSetVideoSurface(this.mediaPlayerInstance, this.videoSurface);
        this.setMedia(media, mediaOptions);
        this.play();
    }

    public boolean isPlayable() {
        LOG.trace((Object)"isPlayable()");
        return this.libvlc.libvlc_media_player_will_play(this.mediaPlayerInstance) == 1;
    }

    public boolean isPlaying() {
        LOG.trace((Object)"isPlaying()");
        return this.libvlc.libvlc_media_player_is_playing(this.mediaPlayerInstance) == 1;
    }

    public boolean isSeekable() {
        LOG.trace((Object)"isSeekable()");
        return this.libvlc.libvlc_media_player_is_seekable(this.mediaPlayerInstance) == 1;
    }

    public boolean canPause() {
        LOG.trace((Object)"canPause()");
        return this.libvlc.libvlc_media_player_can_pause(this.mediaPlayerInstance) == 1;
    }

    public long getLength() {
        LOG.trace((Object)"getLength()");
        return this.libvlc.libvlc_media_player_get_length(this.mediaPlayerInstance);
    }

    public long getTime() {
        LOG.trace((Object)"getTime()");
        return this.libvlc.libvlc_media_player_get_time(this.mediaPlayerInstance);
    }

    public float getPosition() {
        LOG.trace((Object)"getPosition()");
        return this.libvlc.libvlc_media_player_get_position(this.mediaPlayerInstance);
    }

    public float getFps() {
        LOG.trace((Object)"getFps()");
        return this.libvlc.libvlc_media_player_get_fps(this.mediaPlayerInstance);
    }

    public float getRate() {
        LOG.trace((Object)"getRate()");
        return this.libvlc.libvlc_media_player_get_rate(this.mediaPlayerInstance);
    }

    public int getVideoOutputs() {
        LOG.trace((Object)"getVideoOutputs()");
        return this.libvlc.libvlc_media_player_has_vout(this.mediaPlayerInstance);
    }

    public int getTitleCount() {
        LOG.debug((Object)"getTitleCount()");
        return this.libvlc.libvlc_media_player_get_title_count(this.mediaPlayerInstance);
    }

    public int getTitle() {
        LOG.debug((Object)"getTitle()");
        return this.libvlc.libvlc_media_player_get_title(this.mediaPlayerInstance);
    }

    public void setTitle(int title) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setTitle(title=" + title + ")"));
        }
        this.libvlc.libvlc_media_player_set_title(this.mediaPlayerInstance, title);
    }

    public int getVideoTrackCount() {
        LOG.debug((Object)"getVideoTrackCount()");
        return this.libvlc.libvlc_video_get_track_count(this.mediaPlayerInstance);
    }

    public int getVideoTrack() {
        LOG.debug((Object)"getVideoTrack()");
        return this.libvlc.libvlc_video_get_track(this.mediaPlayerInstance);
    }

    public void setVideoTrack(int track) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setVideoTrack(track=" + track + ")"));
        }
        this.libvlc.libvlc_video_set_track(this.mediaPlayerInstance, track);
    }

    public int getAudioTrackCount() {
        LOG.debug((Object)"getVideoTrackCount()");
        return this.libvlc.libvlc_audio_get_track_count(this.mediaPlayerInstance);
    }

    public int getAudioTrack() {
        LOG.debug((Object)"getAudioTrack()");
        return this.libvlc.libvlc_audio_get_track(this.mediaPlayerInstance);
    }

    public void setAudioTrack(int track) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setAudioTrack(track=" + track + ")"));
        }
        this.libvlc.libvlc_audio_set_track(this.mediaPlayerInstance, track);
    }

    public void play() {
        LOG.debug((Object)"play()");
        this.libvlc.libvlc_media_player_play(this.mediaPlayerInstance);
    }

    public void stop() {
        LOG.debug((Object)"stop()");
        this.libvlc.libvlc_media_player_stop(this.mediaPlayerInstance);
    }

    public void pause() {
        LOG.debug((Object)"pause()");
        this.libvlc.libvlc_media_player_pause(this.mediaPlayerInstance);
    }

    public void nextFrame() {
        LOG.debug((Object)"nextFrame()");
        this.libvlc.libvlc_media_player_next_frame(this.mediaPlayerInstance);
    }

    public void skip(long delta) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("skip(delta=" + delta + ")"));
        }
        long current = this.getTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("current=" + current));
        }
        if (current != -1L) {
            this.setTime(current + delta);
        }
    }

    public void skip(float delta) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("skip(delta=" + delta + ")"));
        }
        float current = this.getPosition();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("current=" + current));
        }
        if (current != -1.0f) {
            this.setPosition(current + delta);
        }
    }

    public void setTime(long time) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setTime(time=" + time + ")"));
        }
        this.libvlc.libvlc_media_player_set_time(this.mediaPlayerInstance, time);
    }

    public void setPosition(float position) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setPosition(position=" + position + ")"));
        }
        this.libvlc.libvlc_media_player_set_position(this.mediaPlayerInstance, position);
    }

    public int setRate(float rate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setRate(rate=" + rate + ")"));
        }
        return this.libvlc.libvlc_media_player_set_rate(this.mediaPlayerInstance, rate);
    }

    public void mute() {
        LOG.debug((Object)"mute()");
        this.libvlc.libvlc_audio_toggle_mute(this.mediaPlayerInstance);
    }

    public void mute(boolean mute) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mute(mute=" + mute + ")"));
        }
        this.libvlc.libvlc_audio_set_mute(this.mediaPlayerInstance, mute ? 1 : 0);
    }

    public boolean isMute() {
        LOG.debug((Object)"isMute()");
        return this.libvlc.libvlc_audio_get_mute(this.mediaPlayerInstance) != 0;
    }

    public int getVolume() {
        LOG.debug((Object)"getVolume()");
        return this.libvlc.libvlc_audio_get_volume(this.mediaPlayerInstance);
    }

    public void setVolume(int volume) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setVolume(volume=" + volume + ")"));
        }
        this.libvlc.libvlc_audio_set_volume(this.mediaPlayerInstance, volume);
    }

    public int getChapterCount() {
        LOG.debug((Object)"getChapterCount()");
        return this.libvlc.libvlc_media_player_get_chapter_count(this.mediaPlayerInstance);
    }

    public int getChapter() {
        LOG.debug((Object)"getChapter()");
        return this.libvlc.libvlc_media_player_get_chapter(this.mediaPlayerInstance);
    }

    public void setChapter(int chapterNumber) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setChapter(chapterNumber=" + chapterNumber + ")"));
        }
        this.libvlc.libvlc_media_player_set_chapter(this.mediaPlayerInstance, chapterNumber);
    }

    public void nextChapter() {
        LOG.debug((Object)"nextChapter()");
        this.libvlc.libvlc_media_player_next_chapter(this.mediaPlayerInstance);
    }

    public void previousChapter() {
        LOG.debug((Object)"previousChapter()");
        this.libvlc.libvlc_media_player_previous_chapter(this.mediaPlayerInstance);
    }

    public int getSpuCount() {
        LOG.debug((Object)"getSpuCount()");
        return this.libvlc.libvlc_video_get_spu_count(this.mediaPlayerInstance);
    }

    public int getSpu() {
        LOG.debug((Object)"getSpu()");
        return this.libvlc.libvlc_video_get_spu(this.mediaPlayerInstance);
    }

    public void setSpu(int spu) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setSpu(spu=" + spu + ")"));
        }
        this.libvlc.libvlc_video_set_spu(this.mediaPlayerInstance, spu);
    }

    public List<String> getTitleDescriptions() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getTitleDescriptions()");
        }
        ArrayList<String> trackDescriptions = new ArrayList<String>();
        libvlc_track_description_t trackDescription = this.libvlc.libvlc_video_get_title_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptions.add(trackDescription.psz_name);
            trackDescription = trackDescription.p_next;
        }
        return trackDescriptions;
    }

    public List<String> getVideoDescriptions() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getVideoDescriptions()");
        }
        ArrayList<String> trackDescriptions = new ArrayList<String>();
        libvlc_track_description_t trackDescription = this.libvlc.libvlc_video_get_track_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptions.add(trackDescription.psz_name);
            trackDescription = trackDescription.p_next;
        }
        return trackDescriptions;
    }

    public List<String> getAudioDescriptions() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getAudioDescriptions()");
        }
        ArrayList<String> trackDescriptions = new ArrayList<String>();
        libvlc_track_description_t trackDescription = this.libvlc.libvlc_audio_get_track_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptions.add(trackDescription.psz_name);
            trackDescription = trackDescription.p_next;
        }
        return trackDescriptions;
    }

    public List<String> getSpuDescriptions() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getSpuDescriptions()");
        }
        ArrayList<String> trackDescriptions = new ArrayList<String>();
        libvlc_track_description_t trackDescription = this.libvlc.libvlc_video_get_spu_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptions.add(trackDescription.psz_name);
            trackDescription = trackDescription.p_next;
        }
        return trackDescriptions;
    }

    public List<String> getChapterDescriptions(int title) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getChapterDescriptions(title=" + title + ")"));
        }
        ArrayList<String> trackDescriptions = new ArrayList<String>();
        libvlc_track_description_t trackDescription = this.libvlc.libvlc_video_get_chapter_description(this.mediaPlayerInstance, title);
        while (trackDescription != null) {
            trackDescriptions.add(trackDescription.psz_name);
            trackDescription = trackDescription.p_next;
        }
        return trackDescriptions;
    }

    public void saveSnapshot() {
        LOG.debug((Object)"saveSnapshot()");
        File snapshotDirectory = new File(System.getProperty("user.home"));
        File snapshotFile = new File(snapshotDirectory, "vlcj-snapshot-" + System.currentTimeMillis() + ".png");
        this.saveSnapshot(snapshotFile);
    }

    public void saveSnapshot(File file) {
        File snapshotDirectory;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveSnapshot(file=" + file + ")"));
        }
        if (!(snapshotDirectory = file.getParentFile()).exists()) {
            snapshotDirectory.mkdirs();
        }
        if (!snapshotDirectory.exists()) {
            throw new RuntimeException("Directory does not exist and could not be created for '" + file.getAbsolutePath() + "'");
        }
        this.libvlc.libvlc_video_take_snapshot(this.mediaPlayerInstance, 0, file.getAbsolutePath(), 0, 0);
    }

    public BufferedImage getSnapshot() {
        LOG.debug((Object)"getSnapshot()");
        try {
            File file = File.createTempFile("vlcj-snapshot-", ".png");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("file=" + file.getAbsolutePath()));
            }
            this.saveSnapshot(file);
            BufferedImage snapshotImage = ImageIO.read(file);
            boolean deleted = file.delete();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("deleted=" + deleted));
            }
            return snapshotImage;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get snapshot image", e);
        }
    }

    public BufferedImage getVideoSurfaceContents() {
        LOG.debug((Object)"getVideoSurfaceContents()");
        try {
            Rectangle bounds = this.videoSurface.getBounds();
            bounds.setLocation(this.videoSurface.getLocationOnScreen());
            return new Robot().createScreenCapture(bounds);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get video surface contents", e);
        }
    }

    public void enableLogo(boolean enable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("enableLogo(enable=" + enable + ")"));
        }
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_enable.intValue(), enable ? 1 : 0);
    }

    public void setLogoOpacity(int opacity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setLogoOpacity(opacity=" + opacity + ")"));
        }
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacity);
    }

    public void setLogoLocation(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setLogoLocation(x=" + x + ",y=" + y + ")"));
        }
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_x.intValue(), x);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_y.intValue(), y);
    }

    public void setLogoFile(String logoFile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setLogoFile(logoFile=" + logoFile + ")"));
        }
        this.libvlc.libvlc_video_set_logo_string(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_file.intValue(), logoFile);
    }

    public void enableMarquee(boolean enable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("enableMarquee(enable=" + enable + ")"));
        }
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Enable.intValue(), enable ? 1 : 0);
    }

    public void setMarqueeText(String text) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setMarqueeText(text=" + text + ")"));
        }
        this.libvlc.libvlc_video_set_marquee_string(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Text.intValue(), text);
    }

    public void setMarqueeColour(Color colour) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setMarqueeColour(colour=" + colour + ")"));
        }
        this.setMarqueeColour(colour.getRGB() & 0xFFFFFF);
    }

    public void setMarqueeColour(int colour) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setMarqueeColour(colour=" + colour + ")"));
        }
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Color.intValue(), colour);
    }

    public void setMarqueeOpacity(int opacity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setMarqueeOpacity(opacity=" + opacity + ")"));
        }
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), opacity);
    }

    public void setMarqueeSize(int size) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setMarqueeSize(size=" + size + ")"));
        }
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Size.intValue(), size);
    }

    public void setMarqueeTimeout(int timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setMarqueeTimeout(timeout=" + timeout + ")"));
        }
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Timeout.intValue(), timeout);
    }

    public void setMarqueeLocation(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setMarqueeLocation(x=" + x + ",y=" + y + ")"));
        }
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_X.intValue(), x);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Y.intValue(), y);
    }

    public void setDeinterlace(String deinterlaceMode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setDeinterlace(deinterlaceMode=" + deinterlaceMode + ")"));
        }
        this.libvlc.libvlc_video_set_deinterlace(this.mediaPlayerInstance, deinterlaceMode);
    }

    public void toggleFullScreen() {
        LOG.debug((Object)"toggleFullScreen()");
        if (this.fullScreenStrategy != null) {
            this.setFullScreen(!this.fullScreenStrategy.isFullScreenMode());
        }
    }

    public void setFullScreen(boolean fullScreen) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setFullScreen(fullScreen=" + fullScreen + ")"));
        }
        if (this.fullScreenStrategy != null) {
            if (fullScreen) {
                this.fullScreenStrategy.enterFullScreenMode();
            } else {
                this.fullScreenStrategy.exitFullScreenMode();
            }
        }
    }

    public boolean isFullScreen() {
        LOG.debug((Object)"isFullScreen()");
        if (this.fullScreenStrategy != null) {
            return this.fullScreenStrategy.isFullScreenMode();
        }
        return false;
    }

    public void setEnableMouseInputHandling(boolean enable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setEnableMouseInputHandling(enable=" + enable + ")"));
        }
        this.libvlc.libvlc_video_set_mouse_input(this.mediaPlayerInstance, enable ? 1 : 0);
    }

    public void setEnableKeyInputHandling(boolean enable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setEnableKeyInputHandling(enable=" + enable + ")"));
        }
        this.libvlc.libvlc_video_set_key_input(this.mediaPlayerInstance, enable ? 1 : 0);
    }

    private void createInstance() {
        LOG.debug((Object)"createInstance()");
        this.mediaPlayerInstance = this.libvlc.libvlc_media_player_new(this.instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mediaPlayerInstance=" + (Object)((Object)this.mediaPlayerInstance)));
        }
        this.mediaPlayerEventManager = this.libvlc.libvlc_media_player_event_manager(this.mediaPlayerInstance);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mediaPlayerEventManager=" + (Object)((Object)this.mediaPlayerEventManager)));
        }
        this.registerEventListener();
        this.eventListenerList.add(new MetaDataEventHandler());
    }

    private void destroyInstance() {
        LOG.debug((Object)"destroyInstance()");
        LOG.debug((Object)"Detach events...");
        this.deregisterEventListener();
        LOG.debug((Object)"Events detached.");
        this.eventListenerList.clear();
        if (this.mediaPlayerEventManager != null) {
            this.mediaPlayerEventManager = null;
        }
        if (this.mediaPlayerInstance != null) {
            LOG.debug((Object)"Release media player...");
            this.libvlc.libvlc_media_player_release(this.mediaPlayerInstance);
            LOG.debug((Object)"Media player released");
            this.mediaPlayerInstance = null;
        }
        LOG.debug((Object)"Shut down listeners...");
        this.listenersService.shutdown();
        LOG.debug((Object)"Listeners shut down");
        this.metaService.shutdown();
    }

    private void registerEventListener() {
        LOG.debug((Object)"registerEventListener()");
        this.callback = new VlcVideoPlayerCallback();
        for (libvlc_event_e event : libvlc_event_e.values()) {
            if (event.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || event.intValue() >= libvlc_event_e.libvlc_MediaListItemAdded.intValue()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("event=" + (Object)((Object)event)));
            }
            int result = this.libvlc.libvlc_event_attach(this.mediaPlayerEventManager, event.intValue(), this.callback, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("result=" + result));
            }
            if (result != 0) continue;
        }
    }

    private void deregisterEventListener() {
        LOG.debug((Object)"deregisterEventListener()");
        if (this.callback != null) {
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || event.intValue() >= libvlc_event_e.libvlc_MediaListItemAdded.intValue()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("event=" + (Object)((Object)event)));
                }
                this.libvlc.libvlc_event_detach(this.mediaPlayerEventManager, event.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private void setMedia(String media, String ... mediaOptions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setMedia(media=" + media + ",mediaOptions=" + Arrays.toString(mediaOptions) + ")"));
        }
        libvlc_media_t mediaDescriptor = this.libvlc.libvlc_media_new_path(this.instance, media);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mediaDescriptor=" + (Object)((Object)mediaDescriptor)));
        }
        if (this.standardMediaOptions != null) {
            for (String standardMediaOption : this.standardMediaOptions) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("standardMediaOption=" + standardMediaOption));
                }
                this.libvlc.libvlc_media_add_option(mediaDescriptor, standardMediaOption);
            }
        }
        if (mediaOptions != null) {
            for (String mediaOption : mediaOptions) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("mediaOption=" + mediaOption));
                }
                this.libvlc.libvlc_media_add_option(mediaDescriptor, mediaOption);
            }
        }
        this.libvlc.libvlc_media_player_set_media(this.mediaPlayerInstance, mediaDescriptor);
        this.libvlc.libvlc_media_release(mediaDescriptor);
    }

    private Dimension getVideoDimension() {
        LOG.debug((Object)"getVideoDimension()");
        IntByReference px = new IntByReference();
        IntByReference py = new IntByReference();
        int result = this.libvlc.libvlc_video_get_size(this.mediaPlayerInstance, 0, px, py);
        if (result == 0) {
            return new Dimension(px.getValue(), py.getValue());
        }
        return null;
    }

    public void release() {
        LOG.debug((Object)"release()");
        if (!this.released) {
            this.destroyInstance();
            this.released = true;
        }
    }

    protected synchronized void finalize() throws Throwable {
        LOG.debug((Object)"finalize()");
        this.release();
    }

    private void notifyListeners(libvlc_event_t event) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("notifyListeners(event=" + (Object)((Object)event) + ")"));
        }
        if (!this.eventListenerList.isEmpty()) {
            block10: for (int i = this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaPlayerEventListener listener = this.eventListenerList.get(i);
                int eventType = event.type;
                switch (libvlc_event_e.event(eventType)) {
                    case libvlc_MediaDurationChanged: {
                        long newDuration = ((media_duration_changed)((Object)event.u.getTypedValue(media_duration_changed.class))).new_duration;
                        continue block10;
                    }
                    case libvlc_MediaPlayerPlaying: {
                        listener.playing(this);
                        continue block10;
                    }
                    case libvlc_MediaPlayerPaused: {
                        listener.paused(this);
                        continue block10;
                    }
                    case libvlc_MediaPlayerStopped: {
                        listener.stopped(this);
                        continue block10;
                    }
                    case libvlc_MediaPlayerEndReached: {
                        listener.finished(this);
                        continue block10;
                    }
                    case libvlc_MediaPlayerTimeChanged: {
                        long newTime = ((media_player_time_changed)((Object)event.u.getTypedValue(media_player_time_changed.class))).new_time;
                        listener.timeChanged(this, newTime);
                        continue block10;
                    }
                    case libvlc_MediaPlayerPositionChanged: {
                        float newPosition = ((media_player_position_changed)((Object)event.u.getTypedValue(media_player_position_changed.class))).new_position;
                        listener.positionChanged(this, newPosition);
                        continue block10;
                    }
                    case libvlc_MediaPlayerLengthChanged: {
                        long newLength = ((media_player_length_changed)((Object)event.u.getTypedValue(media_player_length_changed.class))).new_length;
                        listener.lengthChanged(this, newLength);
                    }
                }
            }
        }
    }

    private void notifyListeners(VideoMetaData videoMetaData) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("notifyListeners(videoMetaData=" + videoMetaData + ")"));
        }
        if (!this.eventListenerList.isEmpty()) {
            for (int i = this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaPlayerEventListener listener = this.eventListenerList.get(i);
                listener.metaDataAvailable(this, videoMetaData);
            }
        }
    }

    protected abstract void nativeSetVideoSurface(libvlc_media_player_t var1, Canvas var2);

    protected final libvlc_media_player_t mediaPlayerInstance() {
        return this.mediaPlayerInstance;
    }

    private final class MetaDataEventHandler
    extends MediaPlayerEventAdapter {
        private MetaDataEventHandler() {
        }

        public void playing(MediaPlayer mediaPlayer) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("playing(" + mediaPlayer + ")"));
            }
            MediaPlayer.this.metaService.submit(new NotifyMetaRunnable());
        }
    }

    private final class NotifyMetaRunnable
    implements Runnable {
        private NotifyMetaRunnable() {
        }

        public void run() {
            LOG.trace((Object)"run()");
            while (true) {
                try {
                    do {
                        Thread.sleep(1000L);
                    } while (MediaPlayer.this.getVideoOutputs() <= 0);
                    VideoMetaData videoMetaData = new VideoMetaData();
                    videoMetaData.setVideoDimension(MediaPlayer.this.getVideoDimension());
                    videoMetaData.setTitleCount(MediaPlayer.this.getTitleCount());
                    videoMetaData.setVideoTrackCount(MediaPlayer.this.getVideoTrackCount());
                    videoMetaData.setAudioTrackCount(MediaPlayer.this.getAudioTrackCount());
                    videoMetaData.setSpuCount(MediaPlayer.this.getSpuCount());
                    videoMetaData.setTitleDescriptions(MediaPlayer.this.getTitleDescriptions());
                    videoMetaData.setVideoDescriptions(MediaPlayer.this.getVideoDescriptions());
                    videoMetaData.setAudioDescriptions(MediaPlayer.this.getAudioDescriptions());
                    videoMetaData.setSpuDescriptions(MediaPlayer.this.getSpuDescriptions());
                    TreeMap<Integer, List<String>> allChapterDescriptions = new TreeMap<Integer, List<String>>();
                    for (int i = 0; i < MediaPlayer.this.getTitleCount(); ++i) {
                        allChapterDescriptions.put(i, MediaPlayer.this.getChapterDescriptions(i));
                    }
                    videoMetaData.setChapterDescriptions(allChapterDescriptions);
                    MediaPlayer.this.notifyListeners(videoMetaData);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            LOG.trace((Object)"runnable exits");
        }
    }

    private final class NotifyListenersRunnable
    implements Runnable {
        private final libvlc_event_t event;

        private NotifyListenersRunnable(libvlc_event_t event) {
            this.event = event;
        }

        public void run() {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"run()");
            }
            MediaPlayer.this.notifyListeners(this.event);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"runnable exits");
            }
        }
    }

    private final class VlcVideoPlayerCallback
    implements libvlc_callback_t {
        private VlcVideoPlayerCallback() {
        }

        public void callback(libvlc_event_t event, Pointer userData) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("callback(event=" + (Object)((Object)event) + ",userData=" + userData + ")"));
            }
            if (!MediaPlayer.this.eventListenerList.isEmpty()) {
                MediaPlayer.this.listenersService.submit(new NotifyListenersRunnable(event));
            }
        }
    }
}

