/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.log;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class LoggingProxy
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(LoggingProxy.class);
    private final Object target;

    public LoggingProxy(Object target) {
        this.target = target;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            this.before(method, args);
            result = method.invoke(this.target, args);
            this.after(method, result);
        }
        catch (InvocationTargetException e) {
            this.exception(method, e.getCause());
            throw e;
        }
        return result;
    }

    private void before(Method method, Object[] args) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("call " + method.getName() + ": " + Arrays.toString(args)));
        }
    }

    private void after(Method method, Object result) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("return " + method.getName() + ": " + result));
        }
    }

    private void exception(Method method, Throwable t) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("exception " + method.getName() + ": " + t));
        }
    }
}

