/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.editgpx.EditGpxPlugin;
import org.openstreetmap.josm.plugins.editgpx.GPXLayerImportAction;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxData;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrack;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrackSegment;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxWayPoint;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class EditGpxLayer
extends Layer {
    private static Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(EditGpxPlugin.class.getResource("/images/editgpx_layer.png")));
    private final EditGpxData data;
    private GPXLayerImportAction layerImport;

    public EditGpxLayer(String str, EditGpxData gpxData) {
        super(str);
        this.data = gpxData;
        this.layerImport = new GPXLayerImportAction(this.data);
    }

    public void initializeImport() {
        try {
            if (this.data.isEmpty()) {
                this.layerImport.activateImport();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)LayerListDialog.getInstance().createShowHideLayerAction((Layer)this)), new JMenuItem((Action)LayerListDialog.getInstance().createDeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem(this.layerImport), new JMenuItem(new ConvertToGpxLayerAction()), new JMenuItem(new ConvertToAnonTimeGpxLayerAction()), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return I18n.tr((String)"Layer for editing GPX tracks");
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        g.setColor(Color.yellow);
        Object object = this.layerImport.importing;
        synchronized (object) {
            for (EditGpxTrack track : this.data.getTracks()) {
                for (EditGpxTrackSegment segment : track.getSegments()) {
                    for (EditGpxWayPoint wayPoint : segment.getWayPoints()) {
                        if (wayPoint.isDeleted()) continue;
                        Point pnt = Main.map.mapView.getPoint(wayPoint.getCoor().getEastNorth());
                        g.drawOval(pnt.x - 2, pnt.y - 2, 4, 4);
                    }
                }
            }
        }
    }

    public void reset() {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private GpxData toGpxData(boolean anonTime) {
        return this.data.createGpxData();
    }

    public class ConvertToAnonTimeGpxLayerAction
    extends AbstractAction {
        public ConvertToAnonTimeGpxLayerAction() {
            super(I18n.tr((String)"Convert to GPX layer with anonymised time"), ImageProvider.get((String)"converttogpx"));
        }

        public void actionPerformed(ActionEvent e) {
            Main.main.addLayer((Layer)new GpxLayer(EditGpxLayer.this.toGpxData(true), I18n.tr((String)"Converted from: {0}", (Object[])new Object[]{EditGpxLayer.this.getName()})));
            Main.main.removeLayer((Layer)EditGpxLayer.this);
        }
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr((String)"Convert to GPX layer"), ImageProvider.get((String)"converttogpx"));
        }

        public void actionPerformed(ActionEvent e) {
            Main.main.addLayer((Layer)new GpxLayer(EditGpxLayer.this.toGpxData(false), I18n.tr((String)"Converted from: {0}", (Object[])new Object[]{EditGpxLayer.this.getName()})));
            Main.main.removeLayer((Layer)EditGpxLayer.this);
        }
    }
}

