/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import terracer.HouseNumberInputHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HouseNumberInputDialog
extends ExtendedDialog {
    static final String HANDLE_RELATION = "plugins.terracer.handle_relation";
    static final String DELETE_OUTLINE = "plugins.terracer.delete_outline";
    static final String INTERPOLATION = "plugins.terracer.interpolation";
    private final Way street;
    private final boolean relationExists;
    protected static final String DEFAULT_MESSAGE = I18n.tr((String)"Enter housenumbers or amount of segments");
    private static final long serialVersionUID = 1L;
    private Container jContentPane;
    private JPanel inputPanel;
    private JLabel loLabel;
    JTextField lo;
    private JLabel hiLabel;
    JTextField hi;
    private JLabel streetLabel;
    AutoCompletingComboBox streetComboBox;
    private JLabel segmentsLabel;
    JTextField segments;
    JTextArea messageLabel;
    private JLabel interpolationLabel;
    Choice interpolation;
    JCheckBox handleRelationCheckBox;
    JCheckBox deleteOutlineCheckBox;
    HouseNumberInputHandler inputHandler;

    public HouseNumberInputDialog(HouseNumberInputHandler handler, Way street, boolean relationExists) {
        super(Main.parent, I18n.tr((String)"Terrace a house"), new String[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")}, true);
        this.inputHandler = handler;
        this.street = street;
        this.relationExists = relationExists;
        handler.dialog = this;
        JPanel content = this.getInputPanel();
        this.setContent(content);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.getJContentPane();
        this.initialize();
        this.setupDialog();
        this.setVisible(true);
        this.lo.requestFocus();
    }

    private void initialize() {
        this.lo.addFocusListener(this.inputHandler);
        this.hi.addFocusListener(this.inputHandler);
        this.segments.addFocusListener(this.inputHandler);
        this.interpolation.addItemListener(this.inputHandler);
    }

    private Container getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = this.getContentPane();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            this.jContentPane.add((Component)this.getInputPanel(), (Object)this.jContentPane);
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            GridBagConstraints c = new GridBagConstraints();
            this.messageLabel = new JTextArea();
            this.messageLabel.setText(DEFAULT_MESSAGE);
            this.messageLabel.setAutoscrolls(true);
            this.messageLabel.setLineWrap(true);
            this.messageLabel.setRows(2);
            this.messageLabel.setBackground(new Color(238, 238, 238));
            this.messageLabel.setEditable(false);
            this.messageLabel.setFocusable(false);
            this.interpolationLabel = new JLabel();
            this.interpolationLabel.setText(I18n.tr((String)"Interpolation"));
            this.segmentsLabel = new JLabel();
            this.segmentsLabel.setText(I18n.tr((String)"Segments"));
            this.streetLabel = new JLabel();
            this.streetLabel.setText(I18n.tr((String)"Street"));
            this.loLabel = new JLabel();
            this.loLabel.setText(I18n.tr((String)"Lowest Number"));
            this.loLabel.setPreferredSize(new Dimension(111, 16));
            this.loLabel.setToolTipText(I18n.tr((String)"Lowest housenumber of the terraced house"));
            this.hiLabel = new JLabel();
            this.hiLabel.setText(I18n.tr((String)"Highest Number"));
            String txt = this.relationExists ? I18n.tr((String)"add to existing associatedStreet relation") : I18n.tr((String)"create an associatedStreet relation");
            this.handleRelationCheckBox = new JCheckBox(txt, Main.pref.getBoolean(HANDLE_RELATION, true));
            this.deleteOutlineCheckBox = new JCheckBox(I18n.tr((String)"delete outline way"), Main.pref.getBoolean(DELETE_OUTLINE, true));
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            c.fill = 2;
            c.gridwidth = 0;
            this.inputPanel.add((Component)this.messageLabel, c);
            this.inputPanel.add((Component)this.loLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getLo(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            this.inputPanel.add((Component)this.hiLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getHi(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            this.inputPanel.add((Component)this.interpolationLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getInterpolation(), GBC.eol().insets(5, 3, 0, 0));
            this.inputPanel.add((Component)this.segmentsLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getSegments(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            if (this.street == null) {
                this.inputPanel.add((Component)this.streetLabel, GBC.std().insets(3, 3, 0, 0));
                this.inputPanel.add((Component)this.getStreet(), GBC.eol().insets(5, 3, 0, 0));
            } else {
                this.inputPanel.add((Component)new JLabel(I18n.tr((String)"Street name: ") + "\"" + this.street.get("name") + "\""), GBC.eol().insets(3, 3, 0, 0));
            }
            this.inputPanel.add((Component)this.handleRelationCheckBox, GBC.eol().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.deleteOutlineCheckBox, GBC.eol().insets(3, 3, 0, 0));
        }
        return this.inputPanel;
    }

    protected void buttonAction(ActionEvent evt) {
        String a = evt.getActionCommand();
        this.inputHandler.actionPerformed(evt);
    }

    private JTextField getLo() {
        if (this.lo == null) {
            this.lo = new JTextField();
            this.lo.setText("");
        }
        return this.lo;
    }

    private JTextField getHi() {
        if (this.hi == null) {
            this.hi = new JTextField();
            this.hi.setText("");
        }
        return this.hi;
    }

    private AutoCompletingComboBox getStreet() {
        if (this.streetComboBox == null) {
            TreeSet<String> names = this.createAutoCompletionInfo();
            this.streetComboBox = new AutoCompletingComboBox();
            this.streetComboBox.setPossibleItems(names);
            this.streetComboBox.setEditable(true);
            this.streetComboBox.setSelectedItem(null);
        }
        return this.streetComboBox;
    }

    private JTextField getSegments() {
        if (this.segments == null) {
            this.segments = new JTextField();
            this.segments.setText("1");
        }
        return this.segments;
    }

    private Choice getInterpolation() {
        if (this.interpolation == null) {
            this.interpolation = new Choice();
            this.interpolation.add(I18n.tr((String)"All"));
            this.interpolation.add(I18n.tr((String)"Even/Odd"));
            if (Main.pref.getInteger(INTERPOLATION, 2) == 1) {
                this.interpolation.select(I18n.tr((String)"All"));
            } else {
                this.interpolation.select(I18n.tr((String)"Even/Odd"));
            }
        }
        return this.interpolation;
    }

    TreeSet<String> createAutoCompletionInfo() {
        TreeSet<String> names = new TreeSet<String>();
        for (OsmPrimitive osm : Main.main.getCurrentDataSet().allNonDeletedPrimitives()) {
            if (osm.getKeys() == null || !osm.keySet().contains("highway") || !osm.keySet().contains("name")) continue;
            names.add(osm.get("name"));
        }
        return names;
    }
}

