/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.W32API;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIOptions;
import java.awt.Rectangle;
import java.util.Map;

public interface GDI32
extends W32API {
    public static final GDI32 INSTANCE = (GDI32)Native.loadLibrary((String)"gdi32", GDI32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    public static final int RDH_RECTANGLES = 1;
    public static final int RGN_AND = 1;
    public static final int RGN_OR = 2;
    public static final int RGN_XOR = 3;
    public static final int RGN_DIFF = 4;
    public static final int RGN_COPY = 5;
    public static final int ERROR = 0;
    public static final int NULLREGION = 1;
    public static final int SIMPLEREGION = 2;
    public static final int COMPLEXREGION = 3;
    public static final int ALTERNATE = 1;
    public static final int WINDING = 2;
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;
    public static final int BI_JPEG = 4;
    public static final int BI_PNG = 5;
    public static final int DIB_RGB_COLORS = 0;
    public static final int DIB_PAL_COLORS = 1;

    public W32API.HRGN ExtCreateRegion(Pointer var1, int var2, RGNDATA var3);

    public int CombineRgn(W32API.HRGN var1, W32API.HRGN var2, W32API.HRGN var3, int var4);

    public W32API.HRGN CreateRectRgn(int var1, int var2, int var3, int var4);

    public W32API.HRGN CreateRoundRectRgn(int var1, int var2, int var3, int var4, int var5, int var6);

    public W32API.HRGN CreatePolyPolygonRgn(User32.POINT[] var1, int[] var2, int var3, int var4);

    public boolean SetRectRgn(W32API.HRGN var1, int var2, int var3, int var4, int var5);

    public int SetPixel(W32API.HDC var1, int var2, int var3, int var4);

    public W32API.HDC CreateCompatibleDC(W32API.HDC var1);

    public boolean DeleteDC(W32API.HDC var1);

    public W32API.HBITMAP CreateDIBitmap(W32API.HDC var1, BITMAPINFOHEADER var2, int var3, Pointer var4, BITMAPINFO var5, int var6);

    public W32API.HBITMAP CreateDIBSection(W32API.HDC var1, BITMAPINFO var2, int var3, PointerByReference var4, Pointer var5, int var6);

    public W32API.HBITMAP CreateCompatibleBitmap(W32API.HDC var1, int var2, int var3);

    public W32API.HANDLE SelectObject(W32API.HDC var1, W32API.HANDLE var2);

    public boolean DeleteObject(W32API.HANDLE var1);

    public static class BITMAPINFO
    extends Structure {
        public BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        int[] bmiColors = new int[1];

        public BITMAPINFO() {
            this(1);
        }

        public BITMAPINFO(int size) {
            this.bmiColors = new int[size];
            this.allocateMemory();
        }
    }

    public static class RGBQUAD
    extends Structure {
        public byte rgbBlue;
        public byte rgbGreen;
        public byte rgbRed;
        public byte rgbReserved = 0;
    }

    public static class BITMAPINFOHEADER
    extends Structure {
        public int biSize = this.size();
        public int biWidth;
        public int biHeight;
        public short biPlanes;
        public short biBitCount;
        public int biCompression;
        public int biSizeImage;
        public int biXPelsPerMeter;
        public int biYPelsPerMeter;
        public int biClrUsed;
        public int biClrImportant;
    }

    public static class RGNDATA
    extends Structure {
        public RGNDATAHEADER rdh;
        public byte[] Buffer;

        public RGNDATA(int bufferSize) {
            this.Buffer = new byte[bufferSize];
            this.allocateMemory();
        }
    }

    public static class RGNDATAHEADER
    extends Structure {
        public int dwSize = this.size();
        public int iType = 1;
        public int nCount;
        public int nRgnSize;
        public RECT rcBound;
    }

    public static class RECT
    extends Structure {
        public int left;
        public int top;
        public int right;
        public int bottom;

        public Rectangle toRectangle() {
            return new Rectangle(this.left, this.top, this.right - this.left, this.bottom - this.top);
        }

        public String toString() {
            return "[(" + this.left + "," + this.top + ")(" + this.right + "," + this.bottom + ")]";
        }
    }
}

