/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.player.FullScreenStrategy;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.linux.LinuxMediaPlayer;
import uk.co.caprica.vlcj.player.mac.MacMediaPlayer;
import uk.co.caprica.vlcj.player.windows.WindowsMediaPlayer;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class MediaPlayerFactory {
    private final LibVlc libvlc = LibVlc.SYNC_INSTANCE;
    private libvlc_instance_t instance;
    private boolean released;

    public MediaPlayerFactory(String[] libvlcArgs) {
        this.instance = this.libvlc.libvlc_new(libvlcArgs.length, libvlcArgs);
        if (this.instance == null) {
            throw new IllegalStateException("Unable to initialise libvlc, check your libvlc options and/or check the console for error messages");
        }
    }

    public void release() {
        if (!this.released) {
            if (this.instance != null) {
                this.libvlc.libvlc_release(this.instance);
                this.instance = null;
            }
            this.released = true;
        }
    }

    public MediaPlayer newMediaPlayer(FullScreenStrategy fullScreenStrategy) {
        MediaPlayer mediaPlayer;
        if (RuntimeUtil.isNix()) {
            mediaPlayer = new LinuxMediaPlayer(fullScreenStrategy, this.instance);
        } else if (RuntimeUtil.isWindows()) {
            mediaPlayer = new WindowsMediaPlayer(fullScreenStrategy, this.instance);
        } else if (RuntimeUtil.isMac()) {
            mediaPlayer = new MacMediaPlayer(fullScreenStrategy, this.instance);
        } else {
            throw new RuntimeException("Unable to create a media player - failed to detect a supported operating system");
        }
        return mediaPlayer;
    }

    protected synchronized void finalize() throws Throwable {
        this.release();
    }
}

