/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_logo_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_marquee_option_t;
import uk.co.caprica.vlcj.binding.internal.media_duration_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_length_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_position_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_time_changed;
import uk.co.caprica.vlcj.player.FullScreenStrategy;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.VideoMetaData;

public abstract class MediaPlayer {
    private static final int VOUT_WAIT_PERIOD = 1000;
    protected final LibVlc libvlc = LibVlc.SYNC_INSTANCE;
    private final List<MediaPlayerEventListener> eventListenerList = new ArrayList<MediaPlayerEventListener>();
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final ExecutorService metaService = Executors.newSingleThreadExecutor();
    private final FullScreenStrategy fullScreenStrategy;
    private libvlc_instance_t instance;
    private libvlc_media_player_t mediaPlayerInstance;
    private libvlc_event_manager_t mediaPlayerEventManager;
    private libvlc_callback_t callback;
    private String[] standardMediaOptions;
    private Canvas videoSurface;
    private volatile boolean released;

    public MediaPlayer(FullScreenStrategy fullScreenStrategy, libvlc_instance_t instance) {
        this.fullScreenStrategy = fullScreenStrategy;
        this.instance = instance;
        this.createInstance();
    }

    public void addMediaPlayerEventListener(MediaPlayerEventListener listener) {
        this.eventListenerList.add(listener);
    }

    public void removeMediaPlayerEventListener(MediaPlayerEventListener listener) {
        this.eventListenerList.remove(listener);
    }

    public void setStandardMediaOptions(String ... options) {
        this.standardMediaOptions = options;
    }

    public void setVideoSurface(Canvas videoSurface) {
        this.videoSurface = videoSurface;
    }

    public void playMedia(String media) {
        this.playMedia(media, new String[]{null});
    }

    public void playMedia(String media, String ... mediaOptions) {
        if (this.videoSurface == null) {
            throw new IllegalStateException("Must set a video surface");
        }
        this.nativeSetVideoSurface(this.mediaPlayerInstance, this.videoSurface);
        this.setMedia(media, mediaOptions);
        this.play();
    }

    public boolean isPlayable() {
        return this.libvlc.libvlc_media_player_will_play(this.mediaPlayerInstance) == 1;
    }

    public boolean isPlaying() {
        return this.libvlc.libvlc_media_player_is_playing(this.mediaPlayerInstance) == 1;
    }

    public boolean isSeekable() {
        return this.libvlc.libvlc_media_player_is_seekable(this.mediaPlayerInstance) == 1;
    }

    public boolean canPause() {
        return this.libvlc.libvlc_media_player_can_pause(this.mediaPlayerInstance) == 1;
    }

    public long getLength() {
        return this.libvlc.libvlc_media_player_get_length(this.mediaPlayerInstance);
    }

    public long getTime() {
        return this.libvlc.libvlc_media_player_get_time(this.mediaPlayerInstance);
    }

    public float getPosition() {
        return this.libvlc.libvlc_media_player_get_position(this.mediaPlayerInstance);
    }

    public float getFps() {
        return this.libvlc.libvlc_media_player_get_fps(this.mediaPlayerInstance);
    }

    public float getRate() {
        return this.libvlc.libvlc_media_player_get_rate(this.mediaPlayerInstance);
    }

    public void play() {
        this.libvlc.libvlc_media_player_play(this.mediaPlayerInstance);
    }

    public void stop() {
        this.libvlc.libvlc_media_player_stop(this.mediaPlayerInstance);
    }

    public void pause() {
        this.libvlc.libvlc_media_player_pause(this.mediaPlayerInstance);
    }

    public void skip(long delta) {
        long current = this.libvlc.libvlc_media_player_get_time(this.mediaPlayerInstance);
        if (current != -1L) {
            this.libvlc.libvlc_media_player_set_time(this.mediaPlayerInstance, current + delta);
        }
    }

    public void skip(float delta) {
        float current = this.libvlc.libvlc_media_player_get_position(this.mediaPlayerInstance);
        if (current != -1.0f) {
            this.libvlc.libvlc_media_player_set_position(this.mediaPlayerInstance, current + delta);
        }
    }

    public void setTime(long time) {
        this.libvlc.libvlc_media_player_set_time(this.mediaPlayerInstance, time);
    }

    public void setPosition(float position) {
        this.libvlc.libvlc_media_player_set_position(this.mediaPlayerInstance, position);
    }

    public void mute() {
        this.libvlc.libvlc_audio_toggle_mute(this.mediaPlayerInstance);
    }

    public void mute(boolean mute) {
        this.libvlc.libvlc_audio_set_mute(this.mediaPlayerInstance, mute ? 1 : 0);
    }

    public boolean isMute() {
        return this.libvlc.libvlc_audio_get_mute(this.mediaPlayerInstance) != 0;
    }

    public int getVolume() {
        return this.libvlc.libvlc_audio_get_volume(this.mediaPlayerInstance);
    }

    public void setVolume(int volume) {
        this.libvlc.libvlc_audio_set_volume(this.mediaPlayerInstance, volume);
    }

    public int getChapterCount() {
        return this.libvlc.libvlc_media_player_get_chapter_count(this.mediaPlayerInstance);
    }

    public int getChapter() {
        return this.libvlc.libvlc_media_player_get_chapter(this.mediaPlayerInstance);
    }

    public void setChapter(int chapterNumber) {
        this.libvlc.libvlc_media_player_set_chapter(this.mediaPlayerInstance, chapterNumber);
    }

    public void nextChapter() {
        this.libvlc.libvlc_media_player_next_chapter(this.mediaPlayerInstance);
    }

    public void previousChapter() {
        this.libvlc.libvlc_media_player_previous_chapter(this.mediaPlayerInstance);
    }

    public int getSpuCount() {
        return this.libvlc.libvlc_video_get_spu_count(this.mediaPlayerInstance);
    }

    public int getSpu() {
        return this.libvlc.libvlc_video_get_spu(this.mediaPlayerInstance);
    }

    public void setSpu(int spu) {
        this.libvlc.libvlc_video_set_spu(this.mediaPlayerInstance, spu);
    }

    public void saveSnapshot() {
        File snapshotDirectory = new File(System.getProperty("user.home"));
        File snapshotFile = new File(snapshotDirectory, "vlcj-snapshot-" + System.currentTimeMillis() + ".png");
        this.saveSnapshot(snapshotFile);
    }

    public void saveSnapshot(File file) {
        File snapshotDirectory = file.getParentFile();
        if (!snapshotDirectory.exists()) {
            snapshotDirectory.mkdirs();
        }
        if (!snapshotDirectory.exists()) {
            throw new RuntimeException("Directory does not exist and could not be created for '" + file.getAbsolutePath() + "'");
        }
        this.libvlc.libvlc_video_take_snapshot(this.mediaPlayerInstance, 0, file.getAbsolutePath(), 0, 0);
    }

    public void enableLogo(boolean enable) {
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_enable.intValue(), enable ? 1 : 0);
    }

    public void setLogoOpacity(int opacity) {
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacity);
    }

    public void setLogoLocation(int x, int y) {
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_x.intValue(), x);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_y.intValue(), y);
    }

    public void setLogoFile(String logoFile) {
        this.libvlc.libvlc_video_set_logo_string(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_file.intValue(), logoFile);
    }

    public void enableMarquee(boolean enable) {
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Enable.intValue(), enable ? 1 : 0);
    }

    public void setMarqueeText(String text) {
        this.libvlc.libvlc_video_set_marquee_string(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Text.intValue(), text);
    }

    public void setMarqueeColour(Color colour) {
        this.setMarqueeColour(colour.getRGB() & 0xFFFFFF);
    }

    public void setMarqueeColour(int colour) {
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Color.intValue(), colour);
    }

    public void setMarqueeOpacity(int opacity) {
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), opacity);
    }

    public void setMarqueeSize(int size) {
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Size.intValue(), size);
    }

    public void setMarqueeTimeout(int timeout) {
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Timeout.intValue(), timeout);
    }

    public void setMarqueeLocation(int x, int y) {
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_X.intValue(), x);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Y.intValue(), y);
    }

    public void toggleFullScreen() {
        if (this.fullScreenStrategy != null) {
            this.setFullScreen(!this.fullScreenStrategy.isFullScreenMode());
        }
    }

    public void setFullScreen(boolean fullScreen) {
        if (this.fullScreenStrategy != null) {
            if (fullScreen) {
                this.fullScreenStrategy.enterFullScreenMode();
            } else {
                this.fullScreenStrategy.exitFullScreenMode();
            }
        }
    }

    public boolean isFullScreen() {
        if (this.fullScreenStrategy != null) {
            return this.fullScreenStrategy.isFullScreenMode();
        }
        return false;
    }

    private void createInstance() {
        this.mediaPlayerInstance = this.libvlc.libvlc_media_player_new(this.instance);
        this.mediaPlayerEventManager = this.libvlc.libvlc_media_player_event_manager(this.mediaPlayerInstance);
        this.registerEventListener();
        this.eventListenerList.add(new MetaDataEventHandler());
    }

    private void destroyInstance() {
        this.deregisterEventListener();
        this.eventListenerList.clear();
        if (this.mediaPlayerEventManager != null) {
            this.mediaPlayerEventManager = null;
        }
        if (this.mediaPlayerInstance != null) {
            this.libvlc.libvlc_media_player_release(this.mediaPlayerInstance);
            this.mediaPlayerInstance = null;
        }
        this.listenersService.shutdown();
        this.metaService.shutdown();
    }

    private void registerEventListener() {
        this.callback = new VlcVideoPlayerCallback();
        for (libvlc_event_e event : libvlc_event_e.values()) {
            int result;
            if (event.intValue() >= libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() && event.intValue() < libvlc_event_e.libvlc_MediaListItemAdded.intValue() && (result = this.libvlc.libvlc_event_attach(this.mediaPlayerEventManager, event.intValue(), this.callback, null)) != 0) continue;
        }
    }

    private void deregisterEventListener() {
        if (this.callback != null) {
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || event.intValue() >= libvlc_event_e.libvlc_MediaListItemAdded.intValue()) continue;
                this.libvlc.libvlc_event_detach(this.mediaPlayerEventManager, event.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private void setMedia(String media, String ... mediaOptions) {
        libvlc_media_t mediaDescriptor = this.libvlc.libvlc_media_new_path(this.instance, media);
        if (this.standardMediaOptions != null) {
            for (String standardMediaOption : this.standardMediaOptions) {
                this.libvlc.libvlc_media_add_option(mediaDescriptor, standardMediaOption);
            }
        }
        if (mediaOptions != null) {
            for (String mediaOption : mediaOptions) {
                this.libvlc.libvlc_media_add_option(mediaDescriptor, mediaOption);
            }
        }
        this.libvlc.libvlc_media_player_set_media(this.mediaPlayerInstance, mediaDescriptor);
        this.libvlc.libvlc_media_release(mediaDescriptor);
    }

    private Dimension getVideoDimension() {
        IntByReference px = new IntByReference();
        IntByReference py = new IntByReference();
        int result = this.libvlc.libvlc_video_get_size(this.mediaPlayerInstance, 0, px, py);
        return new Dimension(py.getValue(), px.getValue());
    }

    private boolean hasVideoOut() {
        int hasVideoOut = this.libvlc.libvlc_media_player_has_vout(this.mediaPlayerInstance);
        return hasVideoOut != 0;
    }

    public void release() {
        if (!this.released) {
            this.destroyInstance();
            this.released = true;
        }
    }

    protected synchronized void finalize() throws Throwable {
        this.release();
    }

    private void notifyListeners(libvlc_event_t event) {
        if (!this.eventListenerList.isEmpty()) {
            block10: for (int i = this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaPlayerEventListener listener = this.eventListenerList.get(i);
                int eventType = event.type;
                switch (libvlc_event_e.event(eventType)) {
                    case libvlc_MediaDurationChanged: {
                        long newDuration = ((media_duration_changed)((Object)event.u.getTypedValue(media_duration_changed.class))).new_duration;
                        continue block10;
                    }
                    case libvlc_MediaPlayerPlaying: {
                        listener.playing(this);
                        continue block10;
                    }
                    case libvlc_MediaPlayerPaused: {
                        listener.paused(this);
                        continue block10;
                    }
                    case libvlc_MediaPlayerStopped: {
                        listener.stopped(this);
                        continue block10;
                    }
                    case libvlc_MediaPlayerEndReached: {
                        listener.finished(this);
                        continue block10;
                    }
                    case libvlc_MediaPlayerTimeChanged: {
                        long newTime = ((media_player_time_changed)((Object)event.u.getTypedValue(media_player_time_changed.class))).new_time;
                        listener.timeChanged(this, newTime);
                        continue block10;
                    }
                    case libvlc_MediaPlayerPositionChanged: {
                        float newPosition = ((media_player_position_changed)((Object)event.u.getTypedValue(media_player_position_changed.class))).new_position;
                        listener.positionChanged(this, newPosition);
                        continue block10;
                    }
                    case libvlc_MediaPlayerLengthChanged: {
                        long newLength = ((media_player_length_changed)((Object)event.u.getTypedValue(media_player_length_changed.class))).new_length;
                        listener.lengthChanged(this, newLength);
                    }
                }
            }
        }
    }

    private void notifyListeners(VideoMetaData videoMetaData) {
        if (!this.eventListenerList.isEmpty()) {
            for (int i = this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaPlayerEventListener listener = this.eventListenerList.get(i);
                listener.metaDataAvailable(this, videoMetaData);
            }
        }
    }

    protected abstract void nativeSetVideoSurface(libvlc_media_player_t var1, Canvas var2);

    private final class MetaDataEventHandler
    extends MediaPlayerEventAdapter {
        private MetaDataEventHandler() {
        }

        public void playing(MediaPlayer mediaPlayer) {
            MediaPlayer.this.metaService.submit(new NotifyMetaRunnable());
        }
    }

    private final class NotifyMetaRunnable
    implements Runnable {
        private NotifyMetaRunnable() {
        }

        public void run() {
            while (true) {
                try {
                    do {
                        Thread.sleep(1000L);
                    } while (!MediaPlayer.this.hasVideoOut());
                    VideoMetaData videoMetaData = new VideoMetaData();
                    videoMetaData.setVideoDimension(MediaPlayer.this.getVideoDimension());
                    videoMetaData.setSpuCount(MediaPlayer.this.getSpuCount());
                    MediaPlayer.this.notifyListeners(videoMetaData);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private final class NotifyListenersRunnable
    implements Runnable {
        private final libvlc_event_t event;

        private NotifyListenersRunnable(libvlc_event_t event) {
            this.event = event;
        }

        public void run() {
            MediaPlayer.this.notifyListeners(this.event);
        }
    }

    private final class VlcVideoPlayerCallback
    implements libvlc_callback_t {
        private VlcVideoPlayerCallback() {
        }

        public void callback(libvlc_event_t event, Pointer userData) {
            if (!MediaPlayer.this.eventListenerList.isEmpty()) {
                MediaPlayer.this.listenersService.submit(new NotifyListenersRunnable(event));
            }
        }
    }
}

