/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.check.windows;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.check.EnvironmentChecker;
import uk.co.caprica.vlcj.runtime.windows.WindowsRuntimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsEnvironmentChecker
extends EnvironmentChecker {
    private static final String LIBRARY_NAME = "libvlc.dll";
    private static final List<String> LIBRARY_PATHS = new ArrayList<String>();

    @Override
    protected String getSharedLibraryName() {
        return LIBRARY_NAME;
    }

    @Override
    protected List<String> getSharedLibraryPaths() {
        return LIBRARY_PATHS;
    }

    @Override
    protected void checkNativeEnvironment() {
        System.out.println("Registry...");
        String vlcInstallDir = WindowsRuntimeUtil.getVlcInstallDir();
        if (vlcInstallDir != null) {
            File dir = new File(vlcInstallDir);
            System.out.println(" vlcInstallDir=" + vlcInstallDir + " -> " + (dir.exists() ? "FOUND" : "NOT FOUND"));
            File pluginsDir = new File(vlcInstallDir, "plugins");
            System.out.println("    pluginsDir=" + pluginsDir + " -> " + (pluginsDir.exists() ? "FOUND" : "NOT FOUND"));
        } else {
            System.out.println(" vlcInstallDir=<not-available>");
        }
    }

    static {
        for (String path : System.getenv("PATH").split(";")) {
            LIBRARY_PATHS.add(path);
        }
    }
}

