/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime.windows;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.W32API;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.EventListenerList;
import uk.co.caprica.vlcj.runtime.windows.internal.LowLevelMouseProc;
import uk.co.caprica.vlcj.runtime.windows.internal.MOUSEHOOKSTRUCT;

public class WindowsMouseHook
implements LowLevelMouseProc {
    private static User32 USER32_INSTANCE = User32.INSTANCE;
    private final EventListenerList listenerList = new EventListenerList();
    private final Component relativeTo;
    private Thread hookThread;
    private volatile User32.HHOOK hHook;

    public WindowsMouseHook(Component relativeTo) {
        if (!Platform.isWindows()) {
            throw new IllegalStateException("Windows only");
        }
        this.relativeTo = relativeTo;
    }

    public void addMouseListener(MouseListener listener) {
        this.listenerList.add(MouseListener.class, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.listenerList.remove(MouseListener.class, listener);
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.listenerList.add(MouseMotionListener.class, listener);
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.listenerList.remove(MouseMotionListener.class, listener);
    }

    public void start() {
        if (this.hookThread != null) {
            throw new IllegalStateException("Mouse hook already installed");
        }
        this.hookThread = new MouseHookThread();
        this.hookThread.start();
    }

    public synchronized void release() {
        User32.HHOOK hook = this.getHook();
        if (hook != null) {
            USER32_INSTANCE.UnhookWindowsHookEx(this.hHook);
            hook = null;
            this.hookThread.interrupt();
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    private synchronized User32.HHOOK getHook() {
        return this.hHook;
    }

    public W32API.LRESULT callback(int nCode, W32API.WPARAM wParam, MOUSEHOOKSTRUCT lParam) {
        if (nCode >= 0 && this.relativeTo.isVisible() && this.relativeTo.isValid()) {
            int absX = lParam.pt.x;
            int absY = lParam.pt.y;
            Point componentPoint = this.relativeTo.getLocationOnScreen();
            int relX = componentPoint.x;
            int relY = componentPoint.y;
            int relW = relX + this.relativeTo.getWidth();
            int relH = relY + this.relativeTo.getHeight();
            if (absX >= relX && absY >= relY && absX < relW && absY < relH) {
                switch (wParam.intValue()) {
                    case 512: {
                        this.fireMouseMotionEvent(503, 0, lParam);
                        break;
                    }
                    case 513: {
                        this.fireMouseEvent(501, 1, lParam);
                        break;
                    }
                    case 514: {
                        this.fireMouseEvent(502, 1, lParam);
                        break;
                    }
                    case 516: {
                        this.fireMouseEvent(501, 2, lParam);
                        break;
                    }
                    case 517: {
                        this.fireMouseEvent(502, 2, lParam);
                        break;
                    }
                    case 519: {
                        this.fireMouseEvent(501, 3, lParam);
                        break;
                    }
                    case 520: {
                        this.fireMouseEvent(502, 3, lParam);
                        break;
                    }
                }
            }
        }
        return USER32_INSTANCE.CallNextHookEx(this.hHook, nCode, wParam, lParam.getPointer());
    }

    private void fireMouseMotionEvent(int eventType, int button, MOUSEHOOKSTRUCT lParam) {
        MouseMotionListener[] listeners = (MouseMotionListener[])this.listenerList.getListeners(MouseMotionListener.class);
        if (listeners.length > 0) {
            MouseEvent evt = this.createEvent(eventType, button, lParam);
            for (int i = listeners.length - 1; i >= 0; --i) {
                switch (eventType) {
                    case 503: {
                        listeners[i].mouseMoved(evt);
                    }
                }
            }
        }
    }

    private void fireMouseEvent(int eventType, int button, MOUSEHOOKSTRUCT lParam) {
        MouseListener[] listeners = (MouseListener[])this.listenerList.getListeners(MouseListener.class);
        if (listeners.length > 0) {
            MouseEvent evt = this.createEvent(eventType, button, lParam);
            block4: for (int i = listeners.length - 1; i >= 0; --i) {
                switch (eventType) {
                    case 501: {
                        listeners[i].mousePressed(evt);
                        continue block4;
                    }
                    case 502: {
                        listeners[i].mouseReleased(evt);
                    }
                }
            }
        }
    }

    private MouseEvent createEvent(int eventType, int button, MOUSEHOOKSTRUCT lParam) {
        User32.POINT pt = lParam.pt;
        Point rl = this.relativeTo.getLocationOnScreen();
        int x = pt.x - rl.x;
        int y = pt.y - rl.y;
        return new MouseEvent(this.relativeTo, eventType, System.currentTimeMillis(), 0, x, y, pt.x, pt.y, 0, false, button);
    }

    private class MouseHookThread
    extends Thread {
        private MouseHookThread() {
        }

        public void run() {
            try {
                WindowsMouseHook.this.hHook = USER32_INSTANCE.SetWindowsHookEx(14, (User32.HOOKPROC)WindowsMouseHook.this, (W32API.HINSTANCE)Kernel32.INSTANCE.GetModuleHandle(null), 0);
                User32.MSG msg = new User32.MSG();
                while (USER32_INSTANCE.GetMessage(msg, null, 0, 0) != 0) {
                    USER32_INSTANCE.TranslateMessage(msg);
                    USER32_INSTANCE.DispatchMessage(msg);
                    if (WindowsMouseHook.this.getHook() != null) continue;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

