/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.check;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnvironmentChecker {
    public void checkEnvironment() {
        System.out.println("============================================================");
        System.out.println("=== CHECK ENVIRONMENT ======================================");
        System.out.println("============================================================");
        System.out.println();
        File jnaLibraryPathResult = this.checkJnaLibraryPath();
        File currentDirectoryResult = this.checkCurrentDirectory();
        List<File> searchPathResults = this.checkSearchPaths();
        ArrayList<File> allResults = new ArrayList<File>();
        if (jnaLibraryPathResult != null) {
            allResults.add(jnaLibraryPathResult);
        }
        allResults.add(currentDirectoryResult);
        allResults.addAll(searchPathResults);
        int longest = 0;
        for (File file : allResults) {
            longest = Math.max(longest, file.getAbsolutePath().length());
        }
        String jnaLibraryPath = System.getProperty("jna.library.path");
        System.out.println("-Djna.library.path=" + (jnaLibraryPath != null ? jnaLibraryPath : "<not-specified>"));
        if (jnaLibraryPathResult != null) {
            this.checkExists(jnaLibraryPathResult, longest);
        }
        System.out.println();
        System.out.println("Current Directory...");
        this.checkExists(currentDirectoryResult, longest);
        System.out.println();
        System.out.println("Search Paths...");
        for (File searchPathResult : searchPathResults) {
            this.checkExists(searchPathResult, longest);
        }
        System.out.println();
        this.checkNativeEnvironment();
        System.out.println();
        System.out.println("============================================================");
        System.out.println();
    }

    private File checkJnaLibraryPath() {
        File result = null;
        String jnaLibraryPath = System.getProperty("jna.library.path");
        if (jnaLibraryPath != null) {
            result = new File(new File(jnaLibraryPath), this.getSharedLibraryName());
        }
        return result;
    }

    private File checkCurrentDirectory() {
        return new File(this.getSharedLibraryName());
    }

    private List<File> checkSearchPaths() {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : this.getSharedLibraryPaths()) {
            result.add(new File(new File(path), this.getSharedLibraryName()));
        }
        return result;
    }

    private void checkExists(File file, int size) {
        System.out.printf(" %" + size + "s -> %s", file.getAbsolutePath(), file.exists() ? "FOUND" : "NOT FOUND");
        System.out.println();
    }

    protected abstract String getSharedLibraryName();

    protected abstract List<String> getSharedLibraryPaths();

    protected abstract void checkNativeEnvironment();
}

