/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmTransferException;
import reverter.DataSetToCmd;
import reverter.OsmServerMultiObjectReader;

public class ChangesetReverter {
    private int changesetId;
    private Changeset changeset;
    private ChangesetDataSet osmchange;
    LinkedList<Command> cmds;

    public ChangesetReverter(int changesetId) {
        this.changesetId = changesetId;
        try {
            OsmServerChangesetReader csr = new OsmServerChangesetReader();
            this.changeset = csr.readChangeset((long)changesetId, NullProgressMonitor.INSTANCE);
            this.osmchange = csr.downloadChangeset(changesetId, NullProgressMonitor.INSTANCE);
        }
        catch (OsmTransferException e) {
            e.printStackTrace();
        }
    }

    public void RevertChangeset(ProgressMonitor progressMonitor) throws OsmTransferException {
        OsmDataLayer layer = Main.main.getEditLayer();
        DataSet ds = layer.data;
        MyCsDataset cds = new MyCsDataset(this.osmchange);
        OsmServerMultiObjectReader rdr = new OsmServerMultiObjectReader();
        progressMonitor.beginTask("", cds.updated.size() + cds.deleted.size() + 2);
        progressMonitor.worked(1);
        try {
            for (Map.Entry<PrimitiveId, Integer> entry : cds.updated.entrySet()) {
                rdr.ReadObject(entry.getKey().getUniqueId(), entry.getValue() - 1, entry.getKey().getType(), progressMonitor.createSubTaskMonitor(1, true));
            }
            for (Map.Entry<PrimitiveId, Integer> entry : cds.deleted.entrySet()) {
                rdr.ReadObject(entry.getKey().getUniqueId(), entry.getValue() - 1, entry.getKey().getType(), progressMonitor.createSubTaskMonitor(1, true));
            }
            DataSet nds = rdr.parseOsm(progressMonitor.createSubTaskMonitor(1, true));
            LinkedList<OsmPrimitive> toDelete = new LinkedList<OsmPrimitive>();
            for (OsmPrimitive p : nds.allPrimitives()) {
                OsmPrimitive dp;
                if (p.isVisible() || (dp = ds.getPrimitiveById((PrimitiveId)p)) == null) continue;
                toDelete.add(dp);
            }
            this.cmds = new DataSetToCmd(nds, ds).getCommandList();
            for (PrimitiveId id : cds.created.keySet()) {
                OsmPrimitive p = ds.getPrimitiveById(id);
                if (p == null) continue;
                toDelete.add(p);
            }
            List list = OsmPrimitive.getFilteredList(toDelete, Relation.class);
            if (!list.isEmpty()) {
                this.cmds.add((Command)new DeleteCommand((Collection)list));
            }
            if (!(list = OsmPrimitive.getFilteredList(toDelete, Way.class)).isEmpty()) {
                this.cmds.add((Command)new DeleteCommand((Collection)list));
            }
            if (!(list = OsmPrimitive.getFilteredList(toDelete, Node.class)).isEmpty()) {
                this.cmds.add((Command)new DeleteCommand((Collection)list));
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public List<Command> getCommands() {
        return this.cmds;
    }

    static class MyCsDataset {
        public HashMap<PrimitiveId, Integer> created = new HashMap();
        public HashMap<PrimitiveId, Integer> updated = new HashMap();
        public HashMap<PrimitiveId, Integer> deleted = new HashMap();

        private static void put(HashMap<PrimitiveId, Integer> map, PrimitiveId id, int version) {
            if (map.containsKey(id)) {
                if (version < map.get(id)) {
                    map.put(id, version);
                }
            } else {
                map.put(id, version);
            }
        }

        private void addEntry(ChangesetDataSet.ChangesetDataSetEntry entry) {
            HistoryOsmPrimitive t = entry.getPrimitive();
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.CREATED) {
                MyCsDataset.put(this.created, (PrimitiveId)new SimplePrimitiveId(t.getId(), t.getType()), (int)t.getVersion());
            } else if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.UPDATED) {
                MyCsDataset.put(this.updated, (PrimitiveId)new SimplePrimitiveId(t.getId(), t.getType()), (int)t.getVersion());
            } else if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.DELETED) {
                MyCsDataset.put(this.deleted, (PrimitiveId)new SimplePrimitiveId(t.getId(), t.getType()), (int)t.getVersion());
            } else {
                throw new AssertionError();
            }
        }

        public MyCsDataset(ChangesetDataSet ds) {
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                this.addEntry((ChangesetDataSet.ChangesetDataSetEntry)iterator.next());
            }
        }
    }
}

