/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import reverter.ChangesetIdQuery;
import reverter.ChangesetReverter;

public class RevertChangesetAction
extends JosmAction {
    public RevertChangesetAction() {
        super(I18n.tr((String)"Revert changeset"), null, I18n.tr((String)"Revert changeset"), Shortcut.registerShortcut((String)"tool:revert", (String)"Tool: Revert changeset", (int)84, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent arg0) {
        ChangesetIdQuery dlg = new ChangesetIdQuery();
        dlg.setVisible(true);
        System.out.println(I18n.tr((String)"reverter: {0}", (Object[])new Object[]{dlg.getValue()}));
        if (dlg.getValue() != 1) {
            return;
        }
        final int changesetId = dlg.ChangesetId();
        if (changesetId == 0) {
            return;
        }
        Main.worker.submit((Runnable)new PleaseWaitRunnable("Reverting..."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void realRun() {
                try {
                    ChangesetReverter rev = new ChangesetReverter(changesetId);
                    rev.RevertChangeset(this.progressMonitor.createSubTaskMonitor(-1, true));
                    List<Command> cmds = rev.getCommands();
                    SequenceCommand cmd = new SequenceCommand(I18n.tr((String)"Revert changeset #{0}", (Object[])new Object[]{changesetId}), cmds);
                    Main.main.undoRedo.add((Command)cmd);
                }
                catch (OsmTransferException e) {
                    e.printStackTrace();
                }
            }

            protected void cancel() {
            }

            protected void finish() {
            }
        });
    }
}

