/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataSetToCmd {
    private final DataSet sourceDataSet;
    private final DataSet targetDataSet;
    private final Map<OsmPrimitive, OsmPrimitive> mergedMap = new HashMap<OsmPrimitive, OsmPrimitive>();
    private final LinkedList<Command> cmds = new LinkedList();

    public DataSetToCmd(DataSet sourceDataSet, DataSet targetDataSet) {
        this.sourceDataSet = sourceDataSet;
        this.targetDataSet = targetDataSet;
        this.merge();
    }

    private void mergePrimitive(OsmPrimitive source) {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        OsmPrimitive target = this.targetDataSet.getPrimitiveById(source.getId(), source.getType());
        if (target == null) {
            switch (source.getType()) {
                case NODE: {
                    target = new Node(source.getId());
                    break;
                }
                case WAY: {
                    target = new Way(source.getId());
                    break;
                }
                case RELATION: {
                    target = new Relation(source.getId());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            target.mergeFrom(source);
            target.setOsmId(target.getId(), (int)source.getVersion() + 1);
            target.setModified(true);
            this.cmds.add((Command)new AddCommand(target));
        } else {
            Node newTarget = null;
            switch (target.getType()) {
                case NODE: {
                    newTarget = new Node((Node)target);
                    break;
                }
                case WAY: {
                    newTarget = new Way((Way)target);
                    break;
                }
                case RELATION: {
                    newTarget = new Relation((Relation)target);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            newTarget.mergeFrom(source);
            newTarget.setDeleted(false);
            this.cmds.add((Command)new ChangeCommand(target, (OsmPrimitive)newTarget));
        }
        this.mergedMap.put(source, target);
    }

    private OsmPrimitive getMergeTarget(OsmPrimitive mergeSource) {
        OsmPrimitive p = this.mergedMap.get(mergeSource);
        if (p == null) {
            p = this.targetDataSet.getPrimitiveById(mergeSource.getId(), mergeSource.getType());
        }
        return p;
    }

    public void fixReferences() {
        for (Way w : this.sourceDataSet.getWays()) {
            this.mergeNodeList(w);
        }
        for (Relation r : this.sourceDataSet.getRelations()) {
            this.mergeRelationMembers(r);
        }
    }

    private void mergeNodeList(Way source) throws IllegalStateException {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Way target = (Way)this.getMergeTarget((OsmPrimitive)source);
        if (target == null) {
            throw new IllegalStateException(I18n.tr((String)"Missing merge target for way with id {0}", (Object[])new Object[]{source.getUniqueId()}));
        }
        ArrayList<Node> newNodes = new ArrayList<Node>(source.getNodesCount());
        for (Node sourceNode : source.getNodes()) {
            Node targetNode = (Node)this.getMergeTarget((OsmPrimitive)sourceNode);
            if (targetNode == null) {
                throw new IllegalStateException(I18n.tr((String)"Missing merge target for node with id {0}", (Object[])new Object[]{sourceNode.getUniqueId()}));
            }
            newNodes.add(targetNode);
        }
        this.cmds.add((Command)new ChangeNodesCommand(target, newNodes));
    }

    private void mergeRelationMembers(Relation source) throws IllegalStateException {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Relation target = (Relation)this.getMergeTarget((OsmPrimitive)source);
        if (target == null) {
            throw new IllegalStateException(I18n.tr((String)"Missing merge target for relation with id {0}", (Object[])new Object[]{source.getUniqueId()}));
        }
        LinkedList<RelationMember> newMembers = new LinkedList<RelationMember>();
        for (RelationMember sourceMember : source.getMembers()) {
            OsmPrimitive targetMember = this.getMergeTarget(sourceMember.getMember());
            if (targetMember == null) {
                throw new IllegalStateException(I18n.tr((String)"Missing merge target of type {0} with id {1}", (Object[])new Object[]{sourceMember.getType(), sourceMember.getUniqueId()}));
            }
            newMembers.add(new RelationMember(sourceMember.getRole(), targetMember));
        }
        Relation newRelation = new Relation(target);
        newRelation.setMembers(newMembers);
        this.cmds.add((Command)new ChangeCommand((OsmPrimitive)target, (OsmPrimitive)newRelation));
    }

    private void merge() {
        for (Node node : this.sourceDataSet.getNodes()) {
            this.mergePrimitive((OsmPrimitive)node);
        }
        for (Way way : this.sourceDataSet.getWays()) {
            this.mergePrimitive((OsmPrimitive)way);
        }
        for (Relation relation : this.sourceDataSet.getRelations()) {
            this.mergePrimitive((OsmPrimitive)relation);
        }
        this.fixReferences();
    }

    public LinkedList<Command> getCommandList() {
        return this.cmds;
    }
}

