/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessRuleset;
import org.openstreetmap.josm.plugins.graphview.core.access.Implication;
import org.openstreetmap.josm.plugins.graphview.core.access.ImplicationXMLReader;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class AccessRulesetReader {
    private AccessRulesetReader() {
    }

    public static AccessRuleset readAccessRuleset(InputStream inputStream) throws AccessRulesetSyntaxException, IOException {
        RulesetHandler rulesetHandler = new RulesetHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            InputSource input = new InputSource(inputStream);
            reader.setContentHandler(rulesetHandler);
            reader.setErrorHandler(null);
            reader.parse(input);
        }
        catch (SAXException e) {
            throw new AccessRulesetSyntaxException(e);
        }
        return rulesetHandler.getAccessRuleset();
    }

    private static class RulesetHandler
    extends DefaultHandler {
        private final Collection<AccessClass> accessClasses = new LinkedList<AccessClass>();
        private final Collection<Tag> baseTags = new LinkedList<Tag>();
        private Section currentSection = Section.NONE;
        private AccessClass currentAccessClass = null;
        private ImplicationXMLReader implicationReader = null;
        private final List<Implication> implications = new LinkedList<Implication>();

        private RulesetHandler() {
        }

        AccessRuleset getAccessRuleset() {
            return new AccessRuleset(){

                @Override
                public List<String> getAccessHierarchyAncestors(String transportMode) {
                    for (AccessClass accessClass : RulesetHandler.this.accessClasses) {
                        if (!accessClass.name.equals(transportMode)) continue;
                        return accessClass.getAncestorHierarchy();
                    }
                    return new LinkedList<String>();
                }

                @Override
                public Collection<Tag> getBaseTags() {
                    return RulesetHandler.this.baseTags;
                }

                @Override
                public List<Implication> getImplications() {
                    return RulesetHandler.this.implications;
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.implicationReader != null) {
                this.implicationReader.startElement(uri, localName, name, attributes);
                return;
            }
            if ("classes".equals(name)) {
                if (this.currentSection != Section.NONE) {
                    throw new SAXException("classes element below root child level");
                }
                this.currentSection = Section.CLASSES;
                return;
            } else if ("class".equals(name)) {
                String className = attributes.getValue("name");
                if (this.currentSection != Section.CLASSES) {
                    throw new SAXException("class element (" + className + ") outside classes element");
                }
                if (className == null) {
                    throw new SAXException("class element without name");
                }
                AccessClass newAccessClass = new AccessClass(className, this.currentAccessClass);
                this.accessClasses.add(newAccessClass);
                this.currentAccessClass = newAccessClass;
                return;
            } else if ("basetags".equals(name)) {
                if (this.currentSection != Section.NONE) {
                    throw new SAXException("classes element below root child level");
                }
                this.currentSection = Section.BASETAGS;
                return;
            } else if ("tag".equals(name)) {
                if (this.currentSection != Section.BASETAGS) throw new SAXException("tag element outside basetag and implication elements");
                this.baseTags.add(RulesetHandler.readTag(attributes));
                return;
            } else {
                if (!"implications".equals(name)) return;
                if (this.currentSection != Section.NONE) {
                    throw new SAXException("implications element below root child level");
                }
                this.implicationReader = new ImplicationXMLReader();
                this.currentSection = Section.IMPLICATIONS;
            }
        }

        private static Tag readTag(Attributes attributes) throws SAXException {
            String key = attributes.getValue("k");
            String value = attributes.getValue("v");
            if (key == null) {
                throw new SAXException("tag without key");
            }
            if (value == null) {
                throw new SAXException("tag without value (key is " + key + ")");
            }
            return new Tag(key, value);
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.implicationReader != null && !"implications".equals(name)) {
                this.implicationReader.endElement(uri, localName, name);
            }
            if ("classes".equals(name)) {
                if (this.currentSection != Section.CLASSES) {
                    throw new SAXException("closed classes while it wasn't open");
                }
                if (this.currentAccessClass != null) {
                    throw new SAXException("closed classes element before all class elements were closed");
                }
                this.currentSection = Section.NONE;
            } else if ("class".equals(name)) {
                if (this.currentAccessClass == null) {
                    throw new SAXException("closed class element while none was open");
                }
                this.currentAccessClass = this.currentAccessClass.parent;
            } else if ("basetags".equals(name)) {
                if (this.currentSection != Section.BASETAGS) {
                    throw new SAXException("closed basetags while it wasn't open");
                }
                this.currentSection = Section.NONE;
            } else if ("implications".equals(name)) {
                if (this.currentSection != Section.IMPLICATIONS) {
                    throw new SAXException("closed implications while it wasn't open");
                }
                this.implications.addAll(this.implicationReader.getImplications());
                this.implicationReader = null;
                this.currentSection = Section.NONE;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Section {
            NONE,
            CLASSES,
            BASETAGS,
            IMPLICATIONS;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class AccessClass {
            final String name;
            final AccessClass parent;

            public AccessClass(String name, AccessClass parent) {
                this.name = name;
                this.parent = parent;
            }

            List<String> getAncestorHierarchy() {
                List<Object> names = this.parent == null ? new LinkedList() : this.parent.getAncestorHierarchy();
                names.add(0, this.name);
                return names;
            }
        }
    }

    public static class AccessRulesetSyntaxException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public AccessRulesetSyntaxException(String message) {
            super(message);
        }

        public AccessRulesetSyntaxException(Throwable t) {
            super(t.toString());
        }
    }
}

