/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.property;

import java.util.Collection;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyType;

public final class VehiclePropertyTypes {
    public static final VehiclePropertyType<Float> LENGTH = new NonnegativeFloatProperty();
    public static final VehiclePropertyType<Float> WIDTH = new NonnegativeFloatProperty();
    public static final VehiclePropertyType<Float> HEIGHT = new NonnegativeFloatProperty();
    public static final VehiclePropertyType<Float> WEIGHT = new NonnegativeFloatProperty();
    public static final VehiclePropertyType<Float> AXLELOAD = new NonnegativeFloatProperty();
    public static final VehiclePropertyType<Float> SPEED = new NonnegativeFloatProperty();
    public static final VehiclePropertyType<Float> MAX_INCLINE_UP = new NonnegativeFloatProperty();
    public static final VehiclePropertyType<Float> MAX_INCLINE_DOWN = new NonnegativeFloatProperty();
    public static final VehiclePropertyType<Collection<String>> SURFACE_BLACKLIST = new VehiclePropertyType<Collection<String>>(){

        @Override
        public boolean isValidValue(Object value) {
            if (!(value instanceof Collection)) {
                return false;
            }
            for (Object contentObject : (Collection)value) {
                if (contentObject instanceof String) continue;
                return false;
            }
            return true;
        }
    };
    public static final VehiclePropertyType<Integer> MAX_TRACKTYPE = new VehiclePropertyType<Integer>(){

        @Override
        public boolean isValidValue(Object value) {
            return value instanceof Integer && (Integer)value >= 0 && (Integer)value <= 5;
        }
    };

    private VehiclePropertyTypes() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NonnegativeFloatProperty
    implements VehiclePropertyType<Float> {
        private NonnegativeFloatProperty() {
        }

        @Override
        public boolean isValidValue(Object value) {
            return value instanceof Float && ((Float)value).floatValue() >= 0.0f;
        }
    }
}

