/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import public_transport.ItineraryTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutePatternAction
extends JosmAction {
    private static JDialog jDialog = null;
    private static JTabbedPane tabbedPane = null;
    private static DefaultListModel relsListModel = null;
    private static TagTableModel requiredTagsData = null;
    private static CustomCellEditorTable requiredTagsTable = null;
    private static TagTableModel commonTagsData = null;
    private static CustomCellEditorTable commonTagsTable = null;
    private static TagTableModel otherTagsData = null;
    private static TreeSet<String> tagBlacklist = null;
    private static CustomCellEditorTable otherTagsTable = null;
    private static ItineraryTableModel itineraryData = null;
    private static JTable itineraryTable = null;
    private static StoplistTableModel stoplistData = null;
    private static JTable stoplistTable = null;
    private static JList relsList = null;
    private static JCheckBox cbRight = null;
    private static JCheckBox cbLeft = null;
    private static JTextField tfSuggestStopsLimit = null;
    private static Relation currentRoute = null;
    private static Vector<RelationMember> markedWays = new Vector();
    private static Vector<RelationMember> markedNodes = new Vector();
    private static Relation copy = null;

    public RoutePatternAction() {
        super(I18n.tr((String)"Route patterns ..."), null, I18n.tr((String)"Edit Route patterns for public transport"), null, true);
    }

    public void actionPerformed(ActionEvent event) {
        SegmentMetric sm;
        Way way;
        Vector<SegmentMetric> segmentMetrics;
        String role;
        Vector<RelationMember> itemsToReflect;
        RelationMember curMember;
        Iterator<RelationMember> relIter;
        OsmPrimitive[] osmp;
        BoundingXYVisitor box;
        Frame frame = JOptionPane.getFrameForComponent(Main.parent);
        DataSet mainDataSet = Main.main.getCurrentDataSet();
        if (jDialog == null) {
            jDialog = new JDialog(frame, "Route Patterns", false);
            tabbedPane = new JTabbedPane();
            JPanel tabOverview = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Overview"), tabOverview);
            JPanel tabTags = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Tags"), tabTags);
            JPanel tabItinerary = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Itinerary"), tabItinerary);
            JPanel tabStoplist = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Stops"), tabStoplist);
            JPanel tabMeta = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Meta"), tabMeta);
            tabbedPane.setEnabledAt(0, true);
            tabbedPane.setEnabledAt(1, false);
            tabbedPane.setEnabledAt(2, false);
            tabbedPane.setEnabledAt(3, false);
            tabbedPane.setEnabledAt(4, false);
            jDialog.add(tabbedPane);
            JPanel contentPane = tabOverview;
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints layoutCons = new GridBagConstraints();
            contentPane.setLayout(gridbag);
            JLabel headline = new JLabel("Existing route patterns:");
            layoutCons.gridx = 0;
            layoutCons.gridy = 0;
            layoutCons.gridwidth = 3;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(headline, layoutCons);
            contentPane.add(headline);
            relsListModel = new DefaultListModel();
            relsList = new JList(relsListModel);
            JScrollPane rpListSP = new JScrollPane(relsList);
            Object[] data = new String[]{"1", "2", "3", "4", "5", "6"};
            relsListModel.copyInto(data);
            relsList.setSelectionMode(0);
            relsList.addListSelectionListener(new RoutesLSL(this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 3;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 1.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(rpListSP, layoutCons);
            contentPane.add(rpListSP);
            JButton bRefresh = new JButton("Refresh");
            bRefresh.setActionCommand("routePattern.refresh");
            bRefresh.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.gridheight = 2;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bRefresh, layoutCons);
            contentPane.add(bRefresh);
            JButton bNew = new JButton("New");
            bNew.setActionCommand("routePattern.overviewNew");
            bNew.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 1;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.gridheight = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bNew, layoutCons);
            contentPane.add(bNew);
            JButton bDelete = new JButton("Delete");
            bDelete.setActionCommand("routePattern.overviewDelete");
            bDelete.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 1;
            layoutCons.gridy = 3;
            layoutCons.gridwidth = 1;
            layoutCons.gridheight = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bDelete, layoutCons);
            contentPane.add(bDelete);
            JButton bDuplicate = new JButton("Duplicate");
            bDuplicate.setActionCommand("routePattern.overviewDuplicate");
            bDuplicate.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.gridheight = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bDuplicate, layoutCons);
            contentPane.add(bDuplicate);
            JButton bReflect = new JButton("Reflect");
            bReflect.setActionCommand("routePattern.overviewReflect");
            bReflect.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 3;
            layoutCons.gridwidth = 1;
            layoutCons.gridheight = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bReflect, layoutCons);
            contentPane.add(bReflect);
            contentPane = tabTags;
            gridbag = new GridBagLayout();
            layoutCons = new GridBagConstraints();
            contentPane.setLayout(gridbag);
            headline = new JLabel("Required tags:");
            layoutCons.gridx = 0;
            layoutCons.gridy = 0;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(headline, layoutCons);
            contentPane.add(headline);
            requiredTagsTable = new CustomCellEditorTable();
            requiredTagsData = new TagTableModel(true);
            requiredTagsData.addColumn("Key");
            requiredTagsData.addColumn("Value");
            tagBlacklist = new TreeSet();
            Vector<String> rowContent = new Vector<String>();
            rowContent.add("type");
            tagBlacklist.add("type");
            rowContent.add("route");
            requiredTagsData.addRow(rowContent);
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("route");
            requiredTagsTable.setCellEditor(0, 1, new DefaultCellEditor(comboBox));
            rowContent = new Vector();
            rowContent.add(0, "route");
            tagBlacklist.add("route");
            rowContent.add(1, "bus");
            requiredTagsData.addRow(rowContent);
            comboBox = new JComboBox();
            comboBox.addItem("bus");
            comboBox.addItem("tram");
            comboBox.addItem("light_rail");
            comboBox.addItem("subway");
            comboBox.addItem("rail");
            requiredTagsTable.setCellEditor(1, 1, new DefaultCellEditor(comboBox));
            rowContent = new Vector();
            rowContent.add(0, "ref");
            tagBlacklist.add("ref");
            rowContent.add(1, "");
            requiredTagsData.addRow(rowContent);
            rowContent = new Vector();
            rowContent.add(0, "to");
            tagBlacklist.add("to");
            rowContent.add(1, "");
            requiredTagsData.addRow(rowContent);
            rowContent = new Vector();
            rowContent.add(0, "network");
            tagBlacklist.add("network");
            rowContent.add(1, "");
            requiredTagsData.addRow(rowContent);
            requiredTagsTable.setModel(requiredTagsData);
            JScrollPane tableSP = new JScrollPane(requiredTagsTable);
            requiredTagsData.addTableModelListener(requiredTagsData);
            layoutCons.gridx = 0;
            layoutCons.gridy = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.25;
            layoutCons.fill = 1;
            gridbag.setConstraints(tableSP, layoutCons);
            Dimension preferredSize = tableSP.getPreferredSize();
            preferredSize.setSize(tableSP.getPreferredSize().getWidth(), tableSP.getPreferredSize().getHeight() / 4.0);
            tableSP.setPreferredSize(preferredSize);
            contentPane.add(tableSP);
            headline = new JLabel("Common tags:");
            layoutCons.gridx = 0;
            layoutCons.gridy = 2;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(headline, layoutCons);
            contentPane.add(headline);
            commonTagsTable = new CustomCellEditorTable();
            commonTagsData = new TagTableModel(true);
            commonTagsData.addColumn("Key");
            commonTagsData.addColumn("Value");
            rowContent = new Vector();
            rowContent.add(0, "direction");
            tagBlacklist.add("direction");
            rowContent.add(1, "");
            commonTagsData.addRow(rowContent);
            rowContent = new Vector();
            rowContent.add(0, "from");
            tagBlacklist.add("from");
            rowContent.add(1, "");
            commonTagsData.addRow(rowContent);
            rowContent = new Vector();
            rowContent.add(0, "operator");
            tagBlacklist.add("operator");
            rowContent.add(1, "");
            commonTagsData.addRow(rowContent);
            rowContent = new Vector();
            rowContent.add(0, "color");
            tagBlacklist.add("color");
            rowContent.add(1, "");
            commonTagsData.addRow(rowContent);
            rowContent = new Vector();
            rowContent.add(0, "name");
            tagBlacklist.add("name");
            rowContent.add(1, "");
            commonTagsData.addRow(rowContent);
            commonTagsTable.setModel(commonTagsData);
            tableSP = new JScrollPane(commonTagsTable);
            commonTagsData.addTableModelListener(commonTagsData);
            layoutCons.gridx = 0;
            layoutCons.gridy = 3;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.25;
            layoutCons.fill = 1;
            gridbag.setConstraints(tableSP, layoutCons);
            preferredSize = tableSP.getPreferredSize();
            preferredSize.setSize(tableSP.getPreferredSize().getWidth(), tableSP.getPreferredSize().getHeight() / 4.0);
            tableSP.setPreferredSize(preferredSize);
            contentPane.add(tableSP);
            headline = new JLabel("Additional tags:");
            layoutCons.gridx = 0;
            layoutCons.gridy = 4;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(headline, layoutCons);
            contentPane.add(headline);
            otherTagsTable = new CustomCellEditorTable();
            otherTagsData = new TagTableModel(false);
            otherTagsData.addColumn("Key");
            otherTagsData.addColumn("Value");
            otherTagsTable.setModel(otherTagsData);
            tableSP = new JScrollPane(otherTagsTable);
            otherTagsData.addTableModelListener(otherTagsData);
            layoutCons.gridx = 0;
            layoutCons.gridy = 5;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 1.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(tableSP, layoutCons);
            preferredSize = tableSP.getPreferredSize();
            preferredSize.setSize(tableSP.getPreferredSize().getWidth(), tableSP.getPreferredSize().getHeight() / 2.0);
            tableSP.setPreferredSize(preferredSize);
            contentPane.add(tableSP);
            JButton bAddTag = new JButton("Add a new Tag");
            bAddTag.setActionCommand("routePattern.tagAddTag");
            bAddTag.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 6;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bAddTag, layoutCons);
            contentPane.add(bAddTag);
            contentPane = tabItinerary;
            gridbag = new GridBagLayout();
            layoutCons = new GridBagConstraints();
            contentPane.setLayout(gridbag);
            itineraryTable = new JTable();
            itineraryData = new ItineraryTableModel();
            itineraryData.addColumn("Name/Id");
            itineraryData.addColumn("Role");
            itineraryTable.setModel(itineraryData);
            tableSP = new JScrollPane(itineraryTable);
            comboBox = new JComboBox();
            comboBox.addItem("");
            comboBox.addItem("forward");
            comboBox.addItem("backward");
            itineraryTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(comboBox));
            itineraryData.addTableModelListener(itineraryData);
            layoutCons.gridx = 0;
            layoutCons.gridy = 0;
            layoutCons.gridwidth = 4;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 1.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(tableSP, layoutCons);
            contentPane.add(tableSP);
            JButton bFind = new JButton("Find");
            bFind.setActionCommand("routePattern.itineraryFind");
            bFind.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bFind, layoutCons);
            contentPane.add(bFind);
            JButton bShow = new JButton("Show");
            bShow.setActionCommand("routePattern.itineraryShow");
            bShow.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bShow, layoutCons);
            contentPane.add(bShow);
            JButton bMark = new JButton("Mark");
            bMark.setActionCommand("routePattern.itineraryMark");
            bMark.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 1;
            layoutCons.gridy = 1;
            layoutCons.gridheight = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bMark, layoutCons);
            contentPane.add(bMark);
            JButton bAdd = new JButton("Add");
            bAdd.setActionCommand("routePattern.itineraryAdd");
            bAdd.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 1;
            layoutCons.gridheight = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bAdd, layoutCons);
            contentPane.add(bAdd);
            bDelete = new JButton("Delete");
            bDelete.setActionCommand("routePattern.itineraryDelete");
            bDelete.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bDelete, layoutCons);
            contentPane.add(bDelete);
            JButton bSort = new JButton("Sort");
            bSort.setActionCommand("routePattern.itinerarySort");
            bSort.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 3;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bSort, layoutCons);
            contentPane.add(bSort);
            bReflect = new JButton("Reflect");
            bReflect.setActionCommand("routePattern.itineraryReflect");
            bReflect.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 3;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bReflect, layoutCons);
            contentPane.add(bReflect);
            contentPane = tabStoplist;
            gridbag = new GridBagLayout();
            layoutCons = new GridBagConstraints();
            contentPane.setLayout(gridbag);
            stoplistTable = new JTable();
            stoplistData = new StoplistTableModel();
            stoplistData.addColumn("Name/Id");
            stoplistData.addColumn("Role");
            stoplistTable.setModel(stoplistData);
            tableSP = new JScrollPane(stoplistTable);
            comboBox = new JComboBox();
            comboBox.addItem("");
            comboBox.addItem("forward_stop");
            comboBox.addItem("backward_stop");
            stoplistTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(comboBox));
            stoplistData.addTableModelListener(new StoplistTableModelListener());
            layoutCons.gridx = 0;
            layoutCons.gridy = 0;
            layoutCons.gridwidth = 4;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 1.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(tableSP, layoutCons);
            contentPane.add(tableSP);
            bFind = new JButton("Find");
            bFind.setActionCommand("routePattern.stoplistFind");
            bFind.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bFind, layoutCons);
            contentPane.add(bFind);
            bShow = new JButton("Show");
            bShow.setActionCommand("routePattern.stoplistShow");
            bShow.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bShow, layoutCons);
            contentPane.add(bShow);
            bMark = new JButton("Mark");
            bMark.setActionCommand("routePattern.stoplistMark");
            bMark.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 1;
            layoutCons.gridy = 1;
            layoutCons.gridheight = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bMark, layoutCons);
            contentPane.add(bMark);
            bAdd = new JButton("Add");
            bAdd.setActionCommand("routePattern.stoplistAdd");
            bAdd.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 1;
            layoutCons.gridheight = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bAdd, layoutCons);
            contentPane.add(bAdd);
            bDelete = new JButton("Delete");
            bDelete.setActionCommand("routePattern.stoplistDelete");
            bDelete.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bDelete, layoutCons);
            contentPane.add(bDelete);
            bSort = new JButton("Sort");
            bSort.setActionCommand("routePattern.stoplistSort");
            bSort.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 3;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bSort, layoutCons);
            contentPane.add(bSort);
            bReflect = new JButton("Reflect");
            bReflect.setActionCommand("routePattern.stoplistReflect");
            bReflect.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 3;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bReflect, layoutCons);
            contentPane.add(bReflect);
            contentPane = tabMeta;
            gridbag = new GridBagLayout();
            layoutCons = new GridBagConstraints();
            contentPane.setLayout(gridbag);
            JLabel rightleft = new JLabel("Stops are possible on the");
            layoutCons.gridx = 0;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 2;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(rightleft, layoutCons);
            contentPane.add(rightleft);
            cbRight = new JCheckBox("right hand side", true);
            layoutCons.gridx = 0;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 2;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(cbRight, layoutCons);
            contentPane.add(cbRight);
            cbLeft = new JCheckBox("left hand side", false);
            layoutCons.gridx = 0;
            layoutCons.gridy = 3;
            layoutCons.gridwidth = 2;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(cbLeft, layoutCons);
            contentPane.add(cbLeft);
            JLabel maxdist = new JLabel("Maximum distance from route");
            layoutCons.gridx = 0;
            layoutCons.gridy = 4;
            layoutCons.gridwidth = 2;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(maxdist, layoutCons);
            contentPane.add(maxdist);
            tfSuggestStopsLimit = new JTextField("20", 4);
            layoutCons.gridx = 0;
            layoutCons.gridy = 5;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(tfSuggestStopsLimit, layoutCons);
            contentPane.add(tfSuggestStopsLimit);
            JLabel meters = new JLabel("meters");
            layoutCons.gridx = 1;
            layoutCons.gridy = 5;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(meters, layoutCons);
            contentPane.add(meters);
            JButton bSuggestStops = new JButton("Suggest Stops");
            bSuggestStops.setActionCommand("routePattern.metaSuggestStops");
            bSuggestStops.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 6;
            layoutCons.gridwidth = 3;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bSuggestStops, layoutCons);
            contentPane.add(bSuggestStops);
            jDialog.pack();
        }
        if ("routePattern.refresh".equals(event.getActionCommand())) {
            this.refreshData();
        } else if ("routePattern.overviewNew".equals(event.getActionCommand())) {
            currentRoute = new Relation();
            currentRoute.put("type", "route");
            currentRoute.put("route", "bus");
            mainDataSet.addPrimitive((OsmPrimitive)currentRoute);
            this.refreshData();
            for (int i = 0; i < relsListModel.size(); ++i) {
                if (currentRoute != ((RouteReference)RoutePatternAction.relsListModel.elementAt((int)i)).route) continue;
                relsList.setSelectedIndex(i);
            }
        } else if ("routePattern.overviewDuplicate".equals(event.getActionCommand())) {
            currentRoute = new Relation(currentRoute, true);
            currentRoute.put("type", "route");
            currentRoute.put("route", "bus");
            mainDataSet.addPrimitive((OsmPrimitive)currentRoute);
            this.refreshData();
            for (int i = 0; i < relsListModel.size(); ++i) {
                if (currentRoute != ((RouteReference)RoutePatternAction.relsListModel.elementAt((int)i)).route) continue;
                relsList.setSelectedIndex(i);
            }
        } else if ("routePattern.overviewReflect".equals(event.getActionCommand())) {
            int i;
            currentRoute.setModified(true);
            String tag_from = currentRoute.get("from");
            String tag_to = currentRoute.get("to");
            currentRoute.put("from", tag_to);
            currentRoute.put("to", tag_from);
            Vector<RelationMember> itemsToReflect2 = new Vector<RelationMember>();
            Vector<RelationMember> otherItems = new Vector<RelationMember>();
            int insPos = itineraryTable.getSelectedRow();
            for (i = 0; i < currentRoute.getMembersCount(); ++i) {
                RelationMember item = currentRoute.getMember(i);
                if (item.isWay()) {
                    String role2 = item.getRole();
                    role2 = "backward".equals(role2) ? "forward" : ("forward".equals(role2) ? "backward" : "backward");
                    itemsToReflect2.add(new RelationMember(role2, (OsmPrimitive)item.getWay()));
                    continue;
                }
                if (item.isNode()) {
                    itemsToReflect2.add(item);
                    continue;
                }
                otherItems.add(item);
            }
            currentRoute.setMembers(null);
            for (i = itemsToReflect2.size() - 1; i >= 0; --i) {
                currentRoute.addMember((RelationMember)itemsToReflect2.elementAt(i));
            }
            for (i = 0; i < otherItems.size(); ++i) {
                currentRoute.addMember((RelationMember)otherItems.elementAt(i));
            }
            this.refreshData();
            for (i = 0; i < relsListModel.size(); ++i) {
                if (currentRoute != ((RouteReference)RoutePatternAction.relsListModel.elementAt((int)i)).route) continue;
                relsList.setSelectedIndex(i);
            }
        } else if ("routePattern.overviewDelete".equals(event.getActionCommand())) {
            DeleteAction.deleteRelation((OsmDataLayer)Main.main.getEditLayer(), (Relation)currentRoute);
            currentRoute = null;
            tabbedPane.setEnabledAt(1, false);
            tabbedPane.setEnabledAt(2, false);
            tabbedPane.setEnabledAt(3, false);
            tabbedPane.setEnabledAt(4, false);
            this.refreshData();
        } else if ("routePattern.tagAddTag".equals(event.getActionCommand())) {
            Vector<String> rowContent = new Vector<String>();
            rowContent.add("");
            rowContent.add("");
            otherTagsData.addRow(rowContent);
        } else if ("routePattern.itineraryFind".equals(event.getActionCommand())) {
            if (mainDataSet == null) {
                return;
            }
            itineraryTable.clearSelection();
            for (int i = 0; i < itineraryData.getRowCount(); ++i) {
                if (RoutePatternAction.itineraryData.ways.elementAt(i) == null || !mainDataSet.isSelected((OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i))) continue;
                itineraryTable.addRowSelectionInterval(i, i);
            }
        } else if ("routePattern.itineraryShow".equals(event.getActionCommand())) {
            box = new BoundingXYVisitor();
            if (itineraryTable.getSelectedRowCount() > 0) {
                for (int i = 0; i < itineraryData.getRowCount(); ++i) {
                    if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    RoutePatternAction.itineraryData.ways.elementAt(i).visit((Visitor)box);
                }
            } else {
                for (int i = 0; i < itineraryData.getRowCount(); ++i) {
                    if (RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    RoutePatternAction.itineraryData.ways.elementAt(i).visit((Visitor)box);
                }
            }
            if (box.getBounds() == null) {
                return;
            }
            box.enlargeBoundingBox();
            Main.map.mapView.recalculateCenterScale(box);
        } else if ("routePattern.itineraryMark".equals(event.getActionCommand())) {
            RelationMember markedWay;
            osmp = new OsmPrimitive[]{null};
            Main.main.getCurrentDataSet().setSelected((PrimitiveId[])osmp);
            markedWays.clear();
            if (itineraryTable.getSelectedRowCount() > 0) {
                for (int i = 0; i < itineraryData.getRowCount(); ++i) {
                    if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    mainDataSet.addSelected(new PrimitiveId[]{(PrimitiveId)RoutePatternAction.itineraryData.ways.elementAt(i)});
                    markedWay = new RelationMember((String)itineraryData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
                    markedWays.addElement(markedWay);
                }
            } else {
                for (int i = 0; i < itineraryData.getRowCount(); ++i) {
                    if (RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    mainDataSet.addSelected(new PrimitiveId[]{(PrimitiveId)RoutePatternAction.itineraryData.ways.elementAt(i)});
                    markedWay = new RelationMember((String)itineraryData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
                    markedWays.addElement(markedWay);
                }
            }
        } else if ("routePattern.itineraryAdd".equals(event.getActionCommand())) {
            int insPos = itineraryTable.getSelectedRow();
            relIter = markedWays.iterator();
            TreeSet<Way> addedWays = new TreeSet<Way>();
            if (mainDataSet == null) {
                return;
            }
            while (relIter.hasNext()) {
                curMember = relIter.next();
                if (!curMember.isWay() || !mainDataSet.isSelected((OsmPrimitive)curMember.getWay())) continue;
                itineraryData.insertRow(insPos, curMember.getWay(), curMember.getRole());
                if (insPos >= 0) {
                    ++insPos;
                }
                addedWays.add(curMember.getWay());
            }
            Collection selectedWays = mainDataSet.getSelectedWays();
            for (Way curMember2 : selectedWays) {
                if (addedWays.contains(curMember2)) continue;
                itineraryData.insertRow(insPos, curMember2, "");
                if (insPos < 0) continue;
                ++insPos;
            }
            if (insPos > 0 && insPos < itineraryData.getRowCount()) {
                while (insPos < itineraryData.getRowCount() && RoutePatternAction.itineraryData.ways.elementAt(insPos) == null) {
                    ++insPos;
                }
                itineraryTable.removeRowSelectionInterval(0, itineraryData.getRowCount() - 1);
                if (insPos < itineraryData.getRowCount()) {
                    itineraryTable.addRowSelectionInterval(insPos, insPos);
                }
            }
            itineraryData.cleanupGaps();
            RoutePatternAction.rebuildWays();
        } else if ("routePattern.itineraryDelete".equals(event.getActionCommand())) {
            for (int i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                RoutePatternAction.itineraryData.ways.removeElementAt(i);
                itineraryData.removeRow(i);
            }
            itineraryData.cleanupGaps();
            RoutePatternAction.rebuildWays();
        } else if ("routePattern.itinerarySort".equals(event.getActionCommand())) {
            int i;
            TreeSet<Way> usedWays = new TreeSet<Way>();
            TreeMap<Node, LinkedList<RelationMember>> frontNodes = new TreeMap<Node, LinkedList<RelationMember>>();
            TreeMap<Node, LinkedList<RelationMember>> backNodes = new TreeMap<Node, LinkedList<RelationMember>>();
            Vector<LinkedList<RelationMember>> loops = new Vector<LinkedList<RelationMember>>();
            int insPos = itineraryTable.getSelectedRow();
            if (itineraryTable.getSelectedRowCount() > 0) {
                for (i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                    if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    if (!usedWays.contains(RoutePatternAction.itineraryData.ways.elementAt(i))) {
                        this.addWayToSortingData(RoutePatternAction.itineraryData.ways.elementAt(i), frontNodes, backNodes, loops);
                        usedWays.add(RoutePatternAction.itineraryData.ways.elementAt(i));
                    }
                    RoutePatternAction.itineraryData.ways.removeElementAt(i);
                    itineraryData.removeRow(i);
                }
            } else {
                for (i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                    if (RoutePatternAction.itineraryData.ways.elementAt(i) == null || usedWays.contains(RoutePatternAction.itineraryData.ways.elementAt(i))) continue;
                    this.addWayToSortingData(RoutePatternAction.itineraryData.ways.elementAt(i), frontNodes, backNodes, loops);
                    usedWays.add(RoutePatternAction.itineraryData.ways.elementAt(i));
                }
                itineraryData.clear();
            }
            Iterator entryIter = frontNodes.entrySet().iterator();
            while (entryIter.hasNext()) {
                for (RelationMember curMember3 : (LinkedList)entryIter.next().getValue()) {
                    itineraryData.insertRow(insPos, curMember3.getWay(), curMember3.getRole());
                    if (insPos < 0) continue;
                    ++insPos;
                }
            }
            Iterator listIter = loops.iterator();
            while (listIter.hasNext()) {
                for (RelationMember curMember4 : (LinkedList)listIter.next()) {
                    itineraryData.insertRow(insPos, curMember4.getWay(), curMember4.getRole());
                    if (insPos < 0) continue;
                    ++insPos;
                }
            }
            itineraryData.cleanupGaps();
            RoutePatternAction.rebuildWays();
        } else if ("routePattern.itineraryReflect".equals(event.getActionCommand())) {
            RelationMember markedWay;
            int i;
            itemsToReflect = new Vector<RelationMember>();
            int insPos = itineraryTable.getSelectedRow();
            if (itineraryTable.getSelectedRowCount() > 0) {
                for (i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                    if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    role = (String)itineraryData.getValueAt(i, 1);
                    role = "backward".equals(role) ? "forward" : ("forward".equals(role) ? "backward" : "backward");
                    markedWay = new RelationMember(role, (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
                    itemsToReflect.addElement(markedWay);
                    RoutePatternAction.itineraryData.ways.removeElementAt(i);
                    itineraryData.removeRow(i);
                }
            } else {
                for (i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                    if (RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    role = (String)itineraryData.getValueAt(i, 1);
                    role = "backward".equals(role) ? "forward" : ("forward".equals(role) ? "backward" : "backward");
                    markedWay = new RelationMember(role, (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
                    itemsToReflect.addElement(markedWay);
                }
                itineraryData.clear();
            }
            int startPos = insPos;
            for (RelationMember curMember5 : itemsToReflect) {
                if (!curMember5.isWay()) continue;
                itineraryData.insertRow(insPos, curMember5.getWay(), curMember5.getRole());
                if (insPos < 0) continue;
                ++insPos;
            }
            if (insPos >= 0) {
                itineraryTable.addRowSelectionInterval(startPos, insPos - 1);
            }
            itineraryData.cleanupGaps();
            RoutePatternAction.rebuildWays();
        } else if ("routePattern.stoplistFind".equals(event.getActionCommand())) {
            if (mainDataSet == null) {
                return;
            }
            stoplistTable.clearSelection();
            for (int i = 0; i < stoplistData.getRowCount(); ++i) {
                if (RoutePatternAction.stoplistData.nodes.elementAt(i) == null || !mainDataSet.isSelected((OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i))) continue;
                stoplistTable.addRowSelectionInterval(i, i);
            }
        } else if ("routePattern.stoplistShow".equals(event.getActionCommand())) {
            box = new BoundingXYVisitor();
            if (stoplistTable.getSelectedRowCount() > 0) {
                for (int i = 0; i < stoplistData.getRowCount(); ++i) {
                    if (!stoplistTable.isRowSelected(i)) continue;
                    RoutePatternAction.stoplistData.nodes.elementAt(i).visit((Visitor)box);
                }
            } else {
                for (int i = 0; i < stoplistData.getRowCount(); ++i) {
                    RoutePatternAction.stoplistData.nodes.elementAt(i).visit((Visitor)box);
                }
            }
            if (box.getBounds() == null) {
                return;
            }
            box.enlargeBoundingBox();
            Main.map.mapView.recalculateCenterScale(box);
        } else if ("routePattern.stoplistMark".equals(event.getActionCommand())) {
            RelationMember markedNode;
            osmp = new OsmPrimitive[]{null};
            Main.main.getCurrentDataSet().setSelected((PrimitiveId[])osmp);
            markedNodes.clear();
            if (stoplistTable.getSelectedRowCount() > 0) {
                for (int i = 0; i < stoplistData.getRowCount(); ++i) {
                    if (!stoplistTable.isRowSelected(i)) continue;
                    mainDataSet.addSelected(new PrimitiveId[]{(PrimitiveId)RoutePatternAction.stoplistData.nodes.elementAt(i)});
                    markedNode = new RelationMember((String)stoplistData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
                    markedNodes.addElement(markedNode);
                }
            } else {
                for (int i = 0; i < stoplistData.getRowCount(); ++i) {
                    mainDataSet.addSelected(new PrimitiveId[]{(PrimitiveId)RoutePatternAction.stoplistData.nodes.elementAt(i)});
                    markedNode = new RelationMember((String)stoplistData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
                    markedNodes.addElement(markedNode);
                }
            }
        } else if ("routePattern.stoplistAdd".equals(event.getActionCommand())) {
            int insPos = stoplistTable.getSelectedRow();
            relIter = markedNodes.iterator();
            TreeSet<Node> addedNodes = new TreeSet<Node>();
            if (mainDataSet == null) {
                return;
            }
            while (relIter.hasNext()) {
                curMember = relIter.next();
                if (!curMember.isNode() || !mainDataSet.isSelected((OsmPrimitive)curMember.getNode())) continue;
                stoplistData.insertRow(insPos, curMember.getNode(), curMember.getRole());
                if (insPos >= 0) {
                    ++insPos;
                }
                addedNodes.add(curMember.getNode());
            }
            Collection selectedNodes = mainDataSet.getSelectedNodes();
            for (Way curMember2 : selectedNodes) {
                if (addedNodes.contains(curMember2)) continue;
                stoplistData.insertRow(insPos, (Node)curMember2, "");
                if (insPos < 0) continue;
                ++insPos;
            }
            if (insPos > 0 && insPos < stoplistData.getRowCount()) {
                while (insPos < stoplistData.getRowCount() && RoutePatternAction.stoplistData.nodes.elementAt(insPos) == null) {
                    ++insPos;
                }
                stoplistTable.removeRowSelectionInterval(0, stoplistData.getRowCount() - 1);
                if (insPos < stoplistData.getRowCount()) {
                    stoplistTable.addRowSelectionInterval(insPos, insPos);
                }
            }
            this.rebuildNodes();
        } else if ("routePattern.stoplistDelete".equals(event.getActionCommand())) {
            for (int i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                if (!stoplistTable.isRowSelected(i)) continue;
                RoutePatternAction.stoplistData.nodes.removeElementAt(i);
                stoplistData.removeRow(i);
            }
            this.rebuildNodes();
        } else if ("routePattern.stoplistSort".equals(event.getActionCommand())) {
            StopReference sr;
            int i;
            segmentMetrics = new Vector<SegmentMetric>();
            for (int i2 = 0; i2 < itineraryData.getRowCount(); ++i2) {
                if (RoutePatternAction.itineraryData.ways.elementAt(i2) != null) {
                    way = RoutePatternAction.itineraryData.ways.elementAt(i2);
                    if (way.isIncomplete()) continue;
                    if ("backward".equals((String)itineraryData.getValueAt(i2, 1))) {
                        for (int j = way.getNodesCount() - 2; j >= 0; --j) {
                            sm = new SegmentMetric(way.getNode(j + 1).getCoor().lat(), way.getNode(j + 1).getCoor().lon(), way.getNode(j).getCoor().lat(), way.getNode(j).getCoor().lon());
                            segmentMetrics.add(sm);
                        }
                        continue;
                    }
                    for (int j = 0; j < way.getNodesCount() - 1; ++j) {
                        sm = new SegmentMetric(way.getNode(j).getCoor().lat(), way.getNode(j).getCoor().lon(), way.getNode(j + 1).getCoor().lat(), way.getNode(j + 1).getCoor().lon());
                        segmentMetrics.add(sm);
                    }
                    continue;
                }
                segmentMetrics.add(null);
            }
            Vector<StopReference> srm = new Vector<StopReference>();
            int insPos = stoplistTable.getSelectedRow();
            if (stoplistTable.getSelectedRowCount() > 0) {
                for (i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                    if (!stoplistTable.isRowSelected(i) || (sr = this.detectMinDistance(RoutePatternAction.stoplistData.nodes.elementAt(i), segmentMetrics, cbRight.isSelected(), cbLeft.isSelected())) == null) continue;
                    if (sr.distance < Double.parseDouble(tfSuggestStopsLimit.getText()) * 9.0 / 1000000.0) {
                        sr.role = (String)stoplistData.getValueAt(i, 1);
                        srm.addElement(sr);
                    } else {
                        sr.role = (String)stoplistData.getValueAt(i, 1);
                        sr.index = segmentMetrics.size() * 2;
                        sr.pos = 0.0;
                        srm.addElement(sr);
                    }
                    RoutePatternAction.stoplistData.nodes.removeElementAt(i);
                    stoplistData.removeRow(i);
                }
            } else {
                for (i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                    sr = this.detectMinDistance(RoutePatternAction.stoplistData.nodes.elementAt(i), segmentMetrics, cbRight.isSelected(), cbLeft.isSelected());
                    if (sr == null) continue;
                    if (sr.distance < Double.parseDouble(tfSuggestStopsLimit.getText()) * 9.0 / 1000000.0) {
                        sr.role = (String)stoplistData.getValueAt(i, 1);
                        srm.addElement(sr);
                        continue;
                    }
                    sr.role = (String)stoplistData.getValueAt(i, 1);
                    sr.index = segmentMetrics.size() * 2;
                    sr.pos = 0.0;
                    srm.addElement(sr);
                }
                stoplistData.clear();
            }
            Collections.sort(srm);
            for (i = 0; i < srm.size(); ++i) {
                stoplistData.insertRow(insPos, ((StopReference)srm.elementAt((int)i)).node, ((StopReference)srm.elementAt((int)i)).role);
                if (insPos < 0) continue;
                ++insPos;
            }
            this.rebuildNodes();
        } else if ("routePattern.stoplistReflect".equals(event.getActionCommand())) {
            RelationMember markedNode;
            int i;
            itemsToReflect = new Vector();
            int insPos = stoplistTable.getSelectedRow();
            if (stoplistTable.getSelectedRowCount() > 0) {
                for (i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                    if (!stoplistTable.isRowSelected(i)) continue;
                    role = (String)stoplistData.getValueAt(i, 1);
                    markedNode = new RelationMember(role, (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
                    itemsToReflect.addElement(markedNode);
                    RoutePatternAction.stoplistData.nodes.removeElementAt(i);
                    stoplistData.removeRow(i);
                }
            } else {
                for (i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                    role = (String)stoplistData.getValueAt(i, 1);
                    markedNode = new RelationMember(role, (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
                    itemsToReflect.addElement(markedNode);
                }
                stoplistData.clear();
            }
            int startPos = insPos;
            for (RelationMember curMember5 : itemsToReflect) {
                if (!curMember5.isNode()) continue;
                stoplistData.insertRow(insPos, curMember5.getNode(), curMember5.getRole());
                if (insPos < 0) continue;
                ++insPos;
            }
            if (insPos >= 0) {
                stoplistTable.addRowSelectionInterval(startPos, insPos - 1);
            }
            this.rebuildNodes();
        } else if ("routePattern.metaSuggestStops".equals(event.getActionCommand())) {
            int i;
            segmentMetrics = new Vector();
            for (int i3 = 0; i3 < itineraryData.getRowCount(); ++i3) {
                if (RoutePatternAction.itineraryData.ways.elementAt(i3) != null) {
                    way = RoutePatternAction.itineraryData.ways.elementAt(i3);
                    if (way.isIncomplete()) continue;
                    if ("backward".equals((String)itineraryData.getValueAt(i3, 1))) {
                        for (int j = way.getNodesCount() - 2; j >= 0; --j) {
                            sm = new SegmentMetric(way.getNode(j + 1).getCoor().lat(), way.getNode(j + 1).getCoor().lon(), way.getNode(j).getCoor().lat(), way.getNode(j).getCoor().lon());
                            segmentMetrics.add(sm);
                        }
                        continue;
                    }
                    for (int j = 0; j < way.getNodesCount() - 1; ++j) {
                        sm = new SegmentMetric(way.getNode(j).getCoor().lat(), way.getNode(j).getCoor().lon(), way.getNode(j + 1).getCoor().lat(), way.getNode(j + 1).getCoor().lon());
                        segmentMetrics.add(sm);
                    }
                    continue;
                }
                segmentMetrics.add(null);
            }
            Vector<StopReference> srm = new Vector<StopReference>();
            mainDataSet = Main.main.getCurrentDataSet();
            if (mainDataSet != null) {
                String stopKey = "";
                String stopValue = "";
                if ("bus".equals(currentRoute.get("route"))) {
                    stopKey = "highway";
                    stopValue = "bus_stop";
                } else if ("tram".equals(currentRoute.get("route"))) {
                    stopKey = "railway";
                    stopValue = "tram_stop";
                } else if ("light_rail".equals(currentRoute.get("route"))) {
                    stopKey = "railway";
                    stopValue = "station";
                } else if ("subway".equals(currentRoute.get("route"))) {
                    stopKey = "railway";
                    stopValue = "station";
                } else if ("rail".equals(currentRoute.get("route"))) {
                    stopKey = "railway";
                    stopValue = "station";
                }
                Collection nodeCollection = mainDataSet.getNodes();
                for (Node currentNode : nodeCollection) {
                    StopReference sr;
                    if (!currentNode.isUsable() || !stopValue.equals(currentNode.get(stopKey)) || (sr = this.detectMinDistance(currentNode, segmentMetrics, cbRight.isSelected(), cbLeft.isSelected())) == null || !(sr.distance < Double.parseDouble(tfSuggestStopsLimit.getText()) * 9.0 / 1000000.0)) continue;
                    srm.addElement(sr);
                }
            } else {
                JOptionPane.showMessageDialog(null, "There exists no dataset. Try to download data from the server or open an OSM file.", "No data found", 0);
                System.out.println("Public Transport: RoutePattern: No data found");
            }
            for (i = 0; i < stoplistData.getRowCount(); ++i) {
            }
            Collections.sort(srm);
            stoplistData.clear();
            for (i = 0; i < srm.size(); ++i) {
                stoplistData.addRow(((StopReference)srm.elementAt((int)i)).node, ((StopReference)srm.elementAt((int)i)).role);
            }
            this.rebuildNodes();
        } else {
            this.refreshData();
            jDialog.setLocationRelativeTo(frame);
            jDialog.setVisible(true);
        }
    }

    private void refreshData() {
        Relation copy = currentRoute;
        relsListModel.clear();
        currentRoute = copy;
        DataSet mainDataSet = Main.main.getCurrentDataSet();
        if (mainDataSet != null) {
            Vector<RouteReference> relRefs = new Vector<RouteReference>();
            Collection relCollection = mainDataSet.getRelations();
            for (Relation currentRel : relCollection) {
                if (currentRel.isDeleted()) continue;
                String routeVal = currentRel.get("route");
                if ("bus".equals(routeVal)) {
                    relRefs.add(new RouteReference(currentRel));
                    continue;
                }
                if ("tram".equals(routeVal)) {
                    relRefs.add(new RouteReference(currentRel));
                    continue;
                }
                if ("light_rail".equals(routeVal)) {
                    relRefs.add(new RouteReference(currentRel));
                    continue;
                }
                if ("subway".equals(routeVal)) {
                    relRefs.add(new RouteReference(currentRel));
                    continue;
                }
                if (!"rail".equals(routeVal)) continue;
                relRefs.add(new RouteReference(currentRel));
            }
            Collections.sort(relRefs);
            Iterator iter = relRefs.iterator();
            while (iter.hasNext()) {
                relsListModel.addElement(iter.next());
            }
        } else {
            JOptionPane.showMessageDialog(null, "There exists no dataset. Try to download data from the server or open an OSM file.", "No data found", 0);
            System.out.println("Public Transport: No data found");
        }
    }

    public static void rebuildWays() {
        currentRoute.setModified(true);
        List members = currentRoute.getMembers();
        ListIterator iter = members.listIterator();
        while (iter.hasNext()) {
            if (!((RelationMember)iter.next()).isWay()) continue;
            iter.remove();
        }
        for (int i = 0; i < itineraryData.getRowCount(); ++i) {
            if (RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
            RelationMember member = new RelationMember((String)itineraryData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
            members.add(member);
        }
        currentRoute.setMembers(members);
    }

    private void rebuildNodes() {
        int i;
        currentRoute.setModified(true);
        for (i = currentRoute.getMembersCount() - 1; i >= 0; --i) {
            if (!currentRoute.getMember(i).isNode()) continue;
            currentRoute.removeMember(i);
        }
        for (i = 0; i < stoplistData.getRowCount(); ++i) {
            RelationMember member = new RelationMember((String)stoplistData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
            currentRoute.addMember(member);
        }
    }

    private void addWayToSortingData(Way way, TreeMap<Node, LinkedList<RelationMember>> frontNodes, TreeMap<Node, LinkedList<RelationMember>> backNodes, Vector<LinkedList<RelationMember>> loops) {
        if (way.getNodesCount() < 1) {
            return;
        }
        Node firstNode = way.getNode(0);
        Node lastNode = way.getNode(way.getNodesCount() - 1);
        if (frontNodes.get(firstNode) != null) {
            LinkedList<RelationMember> list = frontNodes.get(firstNode);
            list.addFirst(new RelationMember("backward", (OsmPrimitive)way));
            frontNodes.remove(firstNode);
            Node lastListNode = null;
            lastListNode = "backward".equals(list.getLast().getRole()) ? list.getLast().getWay().getNode(0) : list.getLast().getWay().getNode(list.getLast().getWay().getNodesCount() - 1);
            if (lastNode.equals((Object)lastListNode)) {
                backNodes.remove(lastListNode);
                loops.add(list);
            } else if (frontNodes.get(lastNode) != null) {
                backNodes.remove(lastListNode);
                LinkedList<RelationMember> listToAppend = frontNodes.get(lastNode);
                for (RelationMember member : list) {
                    if ("backward".equals(member.getRole())) {
                        listToAppend.addFirst(new RelationMember("forward", (OsmPrimitive)member.getWay()));
                        continue;
                    }
                    listToAppend.addFirst(new RelationMember("backward", (OsmPrimitive)member.getWay()));
                }
                frontNodes.remove(lastNode);
                frontNodes.put(lastListNode, listToAppend);
            } else if (backNodes.get(lastNode) != null) {
                backNodes.remove(lastListNode);
                LinkedList<RelationMember> listToAppend = backNodes.get(lastNode);
                for (RelationMember member : list) {
                    listToAppend.addLast(member);
                }
                backNodes.remove(lastNode);
                backNodes.put(lastListNode, listToAppend);
            } else {
                frontNodes.put(lastNode, list);
            }
        } else if (backNodes.get(firstNode) != null) {
            LinkedList<RelationMember> list = backNodes.get(firstNode);
            list.addLast(new RelationMember("forward", (OsmPrimitive)way));
            backNodes.remove(firstNode);
            Node firstListNode = null;
            firstListNode = "backward".equals(list.getFirst().getRole()) ? list.getFirst().getWay().getNode(list.getFirst().getWay().getNodesCount() - 1) : list.getFirst().getWay().getNode(0);
            if (lastNode.equals((Object)firstListNode)) {
                frontNodes.remove(firstListNode);
                loops.add(list);
            } else if (frontNodes.get(lastNode) != null) {
                frontNodes.remove(firstListNode);
                LinkedList<RelationMember> listToAppend = frontNodes.get(lastNode);
                ListIterator<RelationMember> memberIter = list.listIterator(list.size());
                while (memberIter.hasPrevious()) {
                    RelationMember member = memberIter.previous();
                    listToAppend.addFirst(member);
                }
                frontNodes.remove(lastNode);
                frontNodes.put(firstListNode, listToAppend);
            } else if (backNodes.get(lastNode) != null) {
                frontNodes.remove(firstListNode);
                LinkedList<RelationMember> listToAppend = backNodes.get(lastNode);
                ListIterator<RelationMember> memberIter = list.listIterator(list.size());
                while (memberIter.hasPrevious()) {
                    RelationMember member = memberIter.previous();
                    if ("backward".equals(member.getRole())) {
                        listToAppend.addLast(new RelationMember("forward", (OsmPrimitive)member.getWay()));
                        continue;
                    }
                    listToAppend.addLast(new RelationMember("backward", (OsmPrimitive)member.getWay()));
                }
                backNodes.remove(lastNode);
                backNodes.put(firstListNode, listToAppend);
            } else {
                backNodes.put(lastNode, list);
            }
        } else if (frontNodes.get(lastNode) != null) {
            LinkedList<RelationMember> list = frontNodes.get(lastNode);
            list.addFirst(new RelationMember("forward", (OsmPrimitive)way));
            frontNodes.remove(lastNode);
            frontNodes.put(firstNode, list);
        } else if (backNodes.get(lastNode) != null) {
            LinkedList<RelationMember> list = backNodes.get(lastNode);
            list.addLast(new RelationMember("backward", (OsmPrimitive)way));
            backNodes.remove(lastNode);
            backNodes.put(firstNode, list);
        } else {
            LinkedList<RelationMember> newList = new LinkedList<RelationMember>();
            newList.add(new RelationMember("forward", (OsmPrimitive)way));
            frontNodes.put(firstNode, newList);
            backNodes.put(lastNode, newList);
        }
    }

    private void routesSelectionChanged() {
        int selectedPos = relsList.getAnchorSelectionIndex();
        if (relsList.isSelectedIndex(selectedPos)) {
            currentRoute = ((RouteReference)RoutePatternAction.relsListModel.elementAt((int)selectedPos)).route;
            tabbedPane.setEnabledAt(1, true);
            tabbedPane.setEnabledAt(2, true);
            tabbedPane.setEnabledAt(3, true);
            tabbedPane.setEnabledAt(4, true);
            requiredTagsData.readRelation(currentRoute);
            commonTagsData.readRelation(currentRoute);
            otherTagsData.readRelation(currentRoute, tagBlacklist);
            itineraryData.clear();
            List relMembers = currentRoute.getMembers();
            Iterator<Object> relIter = relMembers.iterator();
            this.fillItineraryTable(relIter, 0L, -1);
            stoplistData.clear();
            relMembers = currentRoute.getMembers();
            relIter = relMembers.iterator();
            this.fillStoplistTable(relIter, -1);
        } else {
            currentRoute = null;
            tabbedPane.setEnabledAt(1, false);
            tabbedPane.setEnabledAt(2, false);
            tabbedPane.setEnabledAt(3, false);
            tabbedPane.setEnabledAt(4, false);
        }
    }

    private void fillItineraryTable(Iterator<RelationMember> relIter, long lastNodeId, int insPos) {
        while (relIter.hasNext()) {
            RelationMember curMember = relIter.next();
            if (!curMember.isWay()) continue;
            itineraryData.insertRow(insPos, curMember.getWay(), curMember.getRole());
            if (insPos < 0) continue;
            ++insPos;
        }
        itineraryData.cleanupGaps();
    }

    private void fillStoplistTable(Iterator<RelationMember> relIter, int insPos) {
        while (relIter.hasNext()) {
            RelationMember curMember = relIter.next();
            if (!curMember.isNode()) continue;
            stoplistData.insertRow(insPos, curMember.getNode(), curMember.getRole());
            if (insPos < 0) continue;
            ++insPos;
        }
    }

    private StopReference detectMinDistance(Node node, Vector<SegmentMetric> segmentMetrics, boolean rhsPossible, boolean lhsPossible) {
        int minIndex = -1;
        double position = -1.0;
        double distance = 180.0;
        double lat = node.getCoor().lat();
        double lon = node.getCoor().lon();
        int curIndex = -2;
        double angleLat = 100.0;
        double angleLon = 200.0;
        Iterator<SegmentMetric> iter = segmentMetrics.iterator();
        while (iter.hasNext()) {
            curIndex += 2;
            SegmentMetric sm = iter.next();
            if (sm == null) {
                angleLat = 100.0;
                angleLon = 200.0;
                continue;
            }
            double curPosition = (lat - sm.aLat) * sm.d1 + (lon - sm.aLon) * sm.d2;
            if (curPosition < 0.0) {
                if (angleLat <= 90.0) {
                    double lastSegAngle = Math.atan2(angleLat - sm.aLat, angleLon - sm.aLon);
                    double segAngle = Math.atan2(sm.d1, -sm.o1);
                    double vertexAngle = Math.atan2(lat - sm.aLat, lon - sm.aLon);
                    boolean vertexOnSeg = vertexAngle == segAngle || vertexAngle == lastSegAngle;
                    boolean vertexOnTheLeft = !vertexOnSeg && (lastSegAngle > vertexAngle && vertexAngle > segAngle || vertexAngle > segAngle && segAngle > lastSegAngle || segAngle > lastSegAngle && lastSegAngle > vertexAngle);
                    double currentDistance = Math.sqrt((lat - sm.aLat) * (lat - sm.aLat) + (lon - sm.aLon) * (lon - sm.aLon) * Math.cos(sm.aLat * Math.PI / 180.0) * Math.cos(sm.aLat * Math.PI / 180.0));
                    curPosition = vertexAngle - segAngle;
                    if (vertexOnTheLeft) {
                        curPosition = -curPosition;
                    }
                    if (curPosition < 0.0) {
                        curPosition += Math.PI * 2;
                    }
                    if (Math.abs(currentDistance) < distance && (!vertexOnTheLeft && rhsPossible || vertexOnTheLeft && lhsPossible || vertexOnSeg)) {
                        distance = Math.abs(currentDistance);
                        minIndex = curIndex - 1;
                        position = curPosition;
                    }
                }
                angleLat = 100.0;
                angleLon = 200.0;
                continue;
            }
            if (curPosition > sm.length) {
                angleLat = sm.aLat;
                angleLon = sm.aLon;
                continue;
            }
            double currentDistance = (lat - sm.aLat) * sm.o1 + (lon - sm.aLon) * sm.o2;
            if (Math.abs(currentDistance) < distance && (currentDistance >= 0.0 && rhsPossible || currentDistance <= 0.0 && lhsPossible)) {
                distance = Math.abs(currentDistance);
                minIndex = curIndex;
                position = curPosition;
            }
            angleLat = 100.0;
            angleLon = 200.0;
        }
        if (minIndex == -1) {
            return new StopReference(segmentMetrics.size() * 2, 0.0, 180.0, node.get("name"), "", node);
        }
        return new StopReference(minIndex, position, distance, node.get("name"), "", node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StopReference
    implements Comparable<StopReference> {
        public int index = 0;
        public double pos = 0.0;
        public double distance = 0.0;
        public String name = "";
        public String role = "";
        public Node node;

        public StopReference(int inIndex, double inPos, double inDistance, String inName, String inRole, Node inNode) {
            this.index = inIndex;
            this.pos = inPos;
            this.distance = inDistance;
            this.name = inName;
            this.role = inRole;
            this.node = inNode;
        }

        @Override
        public int compareTo(StopReference sr) {
            if (this.index < sr.index) {
                return -1;
            }
            if (this.index > sr.index) {
                return 1;
            }
            if (this.pos < sr.pos) {
                return -1;
            }
            if (this.pos > sr.pos) {
                return 1;
            }
            return 0;
        }
    }

    private class SegmentMetric {
        public double aLat;
        public double aLon;
        public double length;
        public double d1;
        public double d2;
        public double o1;
        public double o2;

        public SegmentMetric(double fromLat, double fromLon, double toLat, double toLon) {
            this.aLat = fromLat;
            this.aLon = fromLon;
            this.d1 = toLat - fromLat;
            this.d2 = (toLon - fromLon) * Math.cos(fromLat * Math.PI / 180.0);
            this.length = Math.sqrt(this.d1 * this.d1 + this.d2 * this.d2);
            this.d1 /= this.length;
            this.d2 /= this.length;
            this.o1 = -this.d2;
            this.o2 = this.d1;
            this.d2 *= Math.cos(fromLat * Math.PI / 180.0);
            this.o2 *= Math.cos(fromLat * Math.PI / 180.0);
        }
    }

    private class StoplistTableModelListener
    implements TableModelListener {
        private StoplistTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                RoutePatternAction.this.rebuildNodes();
            }
        }
    }

    private class StoplistTableModel
    extends DefaultTableModel {
        public Vector<Node> nodes = new Vector();

        private StoplistTableModel() {
        }

        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public void addRow(Object[] obj) {
            throw new UnsupportedOperationException();
        }

        public void insertRow(int insPos, Object[] obj) {
            throw new UnsupportedOperationException();
        }

        public void addRow(Node node, String role) {
            this.insertRow(-1, node, role);
        }

        public void insertRow(int insPos, Node node, String role) {
            Object[] buf = new String[]{"", ""};
            String curName = node.get("name");
            buf[0] = curName != null ? curName : "[ID] " + new Long(node.getId()).toString();
            buf[1] = role;
            if (insPos == -1) {
                this.nodes.addElement(node);
                super.addRow(buf);
            } else {
                this.nodes.insertElementAt(node, insPos);
                super.insertRow(insPos, buf);
            }
        }

        public void clear() {
            this.nodes.clear();
            super.setRowCount(0);
        }
    }

    private class CustomCellEditorTable
    extends JTable {
        TreeMap<Integer, TableCellEditor> col1 = new TreeMap();
        TreeMap<Integer, TableCellEditor> col2 = new TreeMap();

        public TableCellEditor getCellEditor(int row, int column) {
            TableCellEditor editor = null;
            editor = column == 0 ? this.col1.get(new Integer(row)) : this.col2.get(new Integer(row));
            if (editor == null) {
                return new DefaultCellEditor(new JTextField());
            }
            return editor;
        }

        public void setCellEditor(int row, int column, TableCellEditor editor) {
            if (column == 0) {
                this.col1.put(new Integer(row), editor);
            } else {
                this.col2.put(new Integer(row), editor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TagTableModel
    extends DefaultTableModel
    implements TableModelListener {
        Relation relation = null;
        TreeSet<String> blacklist = null;
        boolean hasFixedKeys = true;

        public TagTableModel(boolean hasFixedKeys) {
            this.hasFixedKeys = hasFixedKeys;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0 || !this.hasFixedKeys;
        }

        public void readRelation(Relation rel) {
            this.relation = rel;
            for (int i = 0; i < this.getRowCount(); ++i) {
                String value = rel.get((String)this.getValueAt(i, 0));
                if (value == null) {
                    value = "";
                }
                this.setValueAt(value, i, 1);
            }
        }

        public void readRelation(Relation rel, TreeSet<String> blacklist) {
            this.relation = rel;
            this.blacklist = blacklist;
            this.setRowCount(0);
            for (Map.Entry entry : rel.getKeys().entrySet()) {
                if (blacklist.contains(entry.getKey())) continue;
                Vector<Object> newRow = new Vector<Object>();
                newRow.add(entry.getKey());
                newRow.add(entry.getValue());
                this.addRow(newRow);
            }
            for (int i = 0; i < this.getRowCount(); ++i) {
                String value = rel.get((String)this.getValueAt(i, 0));
                if (value == null) {
                    value = "";
                }
                this.setValueAt(value, i, 1);
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                this.relation.setModified(true);
                String key = (String)this.getValueAt(e.getFirstRow(), 0);
                if (key == null) {
                    return;
                }
                if (this.blacklist == null || !this.blacklist.contains(key)) {
                    this.relation.setModified(true);
                    if ("".equals(this.getValueAt(e.getFirstRow(), 1))) {
                        this.relation.remove(key);
                    } else {
                        this.relation.put(key, (String)this.getValueAt(e.getFirstRow(), 1));
                    }
                } else if (e.getColumn() == 0) {
                    this.setValueAt("", e.getFirstRow(), 0);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RouteReference
    implements Comparable<RouteReference> {
        Relation route;

        public RouteReference(Relation route) {
            this.route = route;
        }

        @Override
        public int compareTo(RouteReference rr) {
            int result;
            if (this.route.get("route") != null) {
                if (rr.route.get("route") == null) {
                    return -1;
                }
                result = this.route.get("route").compareTo(rr.route.get("route"));
                if (result != 0) {
                    return result;
                }
            } else if (rr.route.get("route") != null) {
                return 1;
            }
            if (this.route.get("ref") != null) {
                if (rr.route.get("ref") == null) {
                    return -1;
                }
                result = this.route.get("ref").compareTo(rr.route.get("ref"));
                if (result != 0) {
                    return result;
                }
            } else if (rr.route.get("ref") != null) {
                return 1;
            }
            if (this.route.get("to") != null) {
                if (rr.route.get("to") == null) {
                    return -1;
                }
                result = this.route.get("to").compareTo(rr.route.get("to"));
                if (result != 0) {
                    return result;
                }
            } else if (rr.route.get("to") != null) {
                return 1;
            }
            if (this.route.get("direction") != null) {
                if (rr.route.get("direction") == null) {
                    return -1;
                }
                result = this.route.get("direction").compareTo(rr.route.get("direction"));
                if (result != 0) {
                    return result;
                }
            } else if (rr.route.get("direction") != null) {
                return 1;
            }
            if (this.route.getId() < rr.route.getId()) {
                return -1;
            }
            if (this.route.getId() > rr.route.getId()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            String buf = this.route.get("route");
            if (this.route.get("ref") != null && this.route.get("ref") != "") {
                buf = this.route.get("to") != null && this.route.get("to") != "" ? buf + " " + this.route.get("ref") + ": " + this.route.get("to") : (this.route.get("direction") != null && this.route.get("direction") != "" ? buf + " " + this.route.get("ref") + ": " + this.route.get("direction") : buf + " " + this.route.get("ref"));
            }
            buf = buf + " [ID " + Long.toString(this.route.getId()) + "]";
            return buf;
        }
    }

    private class RoutesLSL
    implements ListSelectionListener {
        RoutePatternAction root = null;

        public RoutesLSL(RoutePatternAction rpa) {
            this.root = rpa;
        }

        public void valueChanged(ListSelectionEvent e) {
            this.root.routesSelectionChanged();
        }
    }
}

