/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.routes.ConvertedWay;
import org.openstreetmap.josm.plugins.routes.PathBuilder;
import org.openstreetmap.josm.plugins.routes.RouteDefinition;
import org.openstreetmap.josm.plugins.routes.paint.NarrowLinePainter;
import org.openstreetmap.josm.plugins.routes.paint.PathPainter;
import org.openstreetmap.josm.plugins.routes.paint.WideLinePainter;
import org.openstreetmap.josm.plugins.routes.xml.RoutesXMLLayer;
import org.openstreetmap.josm.plugins.routes.xml.RoutesXMLRoute;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteLayer
extends Layer
implements DataSetListenerAdapter.Listener {
    private final PathPainter pathPainter;
    private final PathBuilder pathBuilder = new PathBuilder();
    private final List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    private volatile boolean datasetChanged = true;

    public RouteLayer(RoutesXMLLayer xmlLayer) {
        super(xmlLayer.getName());
        int index = 0;
        for (RoutesXMLRoute route : xmlLayer.getRoute()) {
            if (!route.isEnabled()) continue;
            Color color = ColorHelper.html2color((String)route.getColor());
            if (color == null) {
                color = Color.RED;
                System.err.printf("Routes plugin - unable to convert color (%s)\n", route.getColor());
            }
            this.routes.add(new RouteDefinition(index++, color, route.getPattern()));
        }
        this.pathPainter = "wide".equals(Main.pref.get("routes.painter")) ? new WideLinePainter(this) : new NarrowLinePainter(this);
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)new DataSetListenerAdapter((DataSetListenerAdapter.Listener)this), DatasetEventManager.FireMode.IMMEDIATELY);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"osmdata_small");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        return new Component[0];
    }

    public String getToolTipText() {
        return "Hiking routes";
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    private void addRelation(Relation relation, RouteDefinition route) {
        for (RelationMember member : relation.getMembers()) {
            if (!(member.getMember() instanceof Way)) continue;
            Way way = (Way)member.getMember();
            this.pathBuilder.addWay(way, route);
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        DataSet dataset = Main.main.getCurrentDataSet();
        if (dataset == null) {
            return;
        }
        if (this.datasetChanged) {
            this.datasetChanged = false;
            this.pathBuilder.clear();
            for (Relation relation : dataset.getRelations()) {
                for (RouteDefinition route : this.routes) {
                    if (!route.matches((OsmPrimitive)relation)) continue;
                    this.addRelation(relation, route);
                }
            }
            for (Way way : dataset.getWays()) {
                for (RouteDefinition route : this.routes) {
                    if (!route.matches((OsmPrimitive)way)) continue;
                    this.pathBuilder.addWay(way, route);
                }
            }
        }
        Stroke stroke = g.getStroke();
        Color color = g.getColor();
        for (ConvertedWay way : this.pathBuilder.getConvertedWays()) {
            this.pathPainter.drawWay(way, mv, g);
        }
        g.setStroke(stroke);
        g.setColor(color);
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.datasetChanged = true;
    }
}

