/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.colorscheme;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.ColorPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorSchemePreference
implements PreferenceSetting {
    private static final String PREF_KEY_SCHEMES_PREFIX = "colorschemes.";
    private static final String PREF_KEY_SCHEMES_NAMES = "colorschemes.names";
    public static final String PREF_KEY_COLOR_PREFIX = "color.";
    private JList schemesList;
    private DefaultListModel listModel;
    private List<String> colorKeys;
    private ColorPreference colorPreference;

    public void addGui(final PreferenceTabbedPane gui) {
        Map colorMap = Main.pref.getAllPrefix(PREF_KEY_COLOR_PREFIX);
        this.colorKeys = new ArrayList(colorMap.keySet());
        Collections.sort(this.colorKeys);
        this.listModel = new DefaultListModel();
        this.schemesList = new JList(this.listModel);
        String schemes = Main.pref.get(PREF_KEY_SCHEMES_NAMES);
        StringTokenizer st = new StringTokenizer(schemes, ";");
        while (st.hasMoreTokens()) {
            String schemeName = st.nextToken();
            this.listModel.addElement(schemeName);
        }
        JButton useScheme = new JButton(I18n.tr((String)"Use"));
        useScheme.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ColorSchemePreference.this.schemesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select a scheme to use."));
                } else {
                    String schemeName = (String)ColorSchemePreference.this.listModel.get(ColorSchemePreference.this.schemesList.getSelectedIndex());
                    ColorSchemePreference.this.getColorPreference(gui).setColorModel(ColorSchemePreference.this.getColorMap(schemeName));
                }
            }
        });
        JButton addScheme = new JButton(I18n.tr((String)"Add"));
        addScheme.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String schemeName = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Color Scheme"));
                if (schemeName == null) {
                    return;
                }
                schemeName = schemeName.replaceAll("\\.", "_");
                ColorSchemePreference.this.setColorScheme(schemeName, ColorSchemePreference.this.getColorPreference(gui).getColorModel());
                ColorSchemePreference.this.listModel.addElement(schemeName);
                ColorSchemePreference.this.saveSchemeNamesToPref();
            }
        });
        JButton deleteScheme = new JButton(I18n.tr((String)"Delete"));
        deleteScheme.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ColorSchemePreference.this.schemesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the scheme to delete."));
                } else {
                    String schemeName = (String)ColorSchemePreference.this.listModel.get(ColorSchemePreference.this.schemesList.getSelectedIndex());
                    ColorSchemePreference.this.removeColorSchemeFromPreferences(schemeName);
                    ColorSchemePreference.this.listModel.remove(ColorSchemePreference.this.schemesList.getSelectedIndex());
                    ColorSchemePreference.this.saveSchemeNamesToPref();
                }
            }
        });
        this.schemesList.setVisibleRowCount(3);
        useScheme.setToolTipText(I18n.tr((String)"Use the selected scheme from the list."));
        addScheme.setToolTipText(I18n.tr((String)"Use the current colors as a new color scheme."));
        deleteScheme.setToolTipText(I18n.tr((String)"Delete the selected scheme from the list."));
        gui.map.add((Component)new JLabel(I18n.tr((String)"Color Schemes")), GBC.eol().insets(0, 5, 0, 0));
        gui.map.add((Component)new JScrollPane(this.schemesList), GBC.eol().fill(1));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gui.map.add((Component)buttonPanel, GBC.eol().fill(2));
        buttonPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        buttonPanel.add((Component)useScheme, GBC.std().insets(0, 5, 5, 0));
        buttonPanel.add((Component)addScheme, GBC.std().insets(0, 5, 5, 0));
        buttonPanel.add((Component)deleteScheme, GBC.std().insets(0, 5, 5, 0));
    }

    public void saveSchemeNamesToPref() {
        if (this.schemesList.getModel().getSize() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.schemesList.getModel().getSize(); ++i) {
                sb.append(";" + this.schemesList.getModel().getElementAt(i));
            }
            Main.pref.put(PREF_KEY_SCHEMES_NAMES, sb.toString().substring(1));
        } else {
            Main.pref.put(PREF_KEY_SCHEMES_NAMES, null);
        }
    }

    public boolean ok() {
        return false;
    }

    public void removeColorSchemeFromPreferences(String schemeName) {
        Map colors = Main.pref.getAllPrefix(PREF_KEY_SCHEMES_PREFIX + schemeName + ".");
        for (String key : colors.keySet()) {
            Main.pref.put(key, null);
        }
    }

    public void setColorScheme(String schemeName, Map<String, String> colorMap) {
        for (String colorKey : colorMap.keySet()) {
            String key = PREF_KEY_SCHEMES_PREFIX + schemeName + "." + PREF_KEY_COLOR_PREFIX + colorKey;
            Main.pref.put(key, colorMap.get(colorKey));
        }
    }

    public Map<String, String> getColorMap(String schemeName) {
        String prefix = PREF_KEY_SCHEMES_PREFIX + schemeName + "." + PREF_KEY_COLOR_PREFIX;
        HashMap<String, String> colorMap = new HashMap<String, String>();
        for (String schemeColorKey : Main.pref.getAllPrefix(prefix).keySet()) {
            String colorKey = schemeColorKey.substring(prefix.length());
            colorMap.put(colorKey, Main.pref.get(schemeColorKey));
        }
        return colorMap;
    }

    public ColorPreference getColorPreference(PreferenceTabbedPane gui) {
        if (this.colorPreference == null) {
            for (PreferenceSetting setting : gui.getSettings()) {
                if (!(setting instanceof ColorPreference)) continue;
                this.colorPreference = (ColorPreference)setting;
                break;
            }
        }
        return this.colorPreference;
    }
}

