/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.AddressDialog;
import buildings_tools.Building;
import buildings_tools.BuildingsToolsPlugin;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawBuildingAction
extends MapMode
implements MapViewPaintable,
AWTEventListener,
SelectionChangedListener {
    private final Cursor cursorCrosshair;
    private final Cursor cursorJoinNode;
    private Cursor currCursor;
    private static double width = 0.0;
    private static double lenstep = 0.0;
    private static boolean useAddr;
    private Mode mode = Mode.None;
    private EastNorth p1;
    private EastNorth p2;
    private EastNorth p3;
    private Color selectedColor;
    private Point mousePos;
    private Point drawStartPos;
    Building building = new Building();

    public static void SetAddrDialog(boolean _useAddr) {
        useAddr = _useAddr;
    }

    public static void SetSizes(double newwidth, double newlenstep) {
        width = newwidth;
        lenstep = newlenstep;
    }

    public static double getWidth() {
        return width;
    }

    public static double getLenStep() {
        return lenstep;
    }

    public DrawBuildingAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Draw buildings"), "building", I18n.tr((String)"Draw buildings"), Shortcut.registerShortcut((String)"mapmode:buildings", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Draw buildings")}), (int)87, (int)3), mapFrame, DrawBuildingAction.getCursor());
        this.cursorCrosshair = DrawBuildingAction.getCursor();
        this.cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
        this.currCursor = this.cursorCrosshair;
        this.selectedColor = Main.pref.getColor(I18n.marktr((String)"selected"), Color.red);
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor((String)"crosshair", null);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(1);
        }
    }

    private void setCursor(final Cursor c) {
        if (this.currCursor.equals(c)) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (!(Main.map.mapMode instanceof DrawBuildingAction)) {
                        return;
                    }
                    Main.map.mapView.setCursor(c);
                }
            });
            this.currCursor = c;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void showAddrDialog(Way w) {
        AddressDialog dlg = new AddressDialog();
        int answer = dlg.getValue();
        if (answer == 1) {
            dlg.saveValues();
            String tmp = dlg.getHouseNum();
            if (tmp != null && tmp != "") {
                w.put("addr:housenumber", tmp);
            }
            if ((tmp = dlg.getStreetName()) != null && tmp != "") {
                w.put("addr:street", tmp);
            }
        }
    }

    public void enterMode() {
        super.enterMode();
        this.currCursor = this.cursorCrosshair;
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        DataSet.selListeners.add(this);
        this.UpdateConstraint(this.getCurrentDataSet().getSelected());
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        DataSet.selListeners.remove(this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.mode != Mode.None) {
            Main.map.mapView.repaint();
        }
        this.mode = Mode.None;
    }

    public void cancelDrawing() {
        this.mode = Mode.None;
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        Main.map.mapView.repaint();
    }

    @Override
    public void eventDispatched(AWTEvent arg0) {
        if (!(arg0 instanceof KeyEvent)) {
            return;
        }
        KeyEvent ev = (KeyEvent)arg0;
        if (ev.getKeyCode() == 27) {
            this.cancelDrawing();
        }
    }

    private void ProcessMouseEvent(MouseEvent e) {
        this.mousePos = e.getPoint();
        if (this.mode == Mode.None) {
            return;
        }
        if (this.mode == Mode.Drawing) {
            Node n = e.isControlDown() ? null : Main.map.mapView.getNearestNode(this.mousePos);
            this.p2 = n == null ? BuildingsToolsPlugin.latlon2eastNorth(Main.map.mapView.getLatLon(this.mousePos.x, this.mousePos.y)) : BuildingsToolsPlugin.latlon2eastNorth(n.getCoor());
            this.building.setPlace(this.p2, width, e.isControlDown() ? 0.0 : lenstep);
            Main.map.statusLine.setDist(this.building.getLength());
            return;
        }
        if (this.mode == Mode.DrawingWidth) {
            Node n = e.isControlDown() ? null : Main.map.mapView.getNearestNode(this.mousePos);
            this.p3 = n == null ? BuildingsToolsPlugin.latlon2eastNorth(Main.map.mapView.getLatLon(this.mousePos.x, this.mousePos.y)) : BuildingsToolsPlugin.latlon2eastNorth(n.getCoor());
            double mwidth = ((this.p3.east() - this.p2.east()) * (this.p2.north() - this.p1.north()) + (this.p3.north() - this.p2.north()) * (this.p1.east() - this.p2.east())) / this.p1.distanceSq((Point2D)this.p2) * this.building.getLength();
            this.building.setPlace(this.p2, mwidth, lenstep);
            Main.map.statusLine.setDist(Math.abs(mwidth));
            return;
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.mode == Mode.None) {
            return;
        }
        if (this.building.getLength() == 0.0) {
            return;
        }
        g.setColor(this.selectedColor);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        this.building.paint(g, mv);
        g.setStroke(new BasicStroke(1.0f));
    }

    private void drawingStart(MouseEvent e) {
        this.drawStartPos = this.mousePos = e.getPoint();
        Node n = Main.map.mapView.getNearestNode(this.mousePos);
        if (n == null) {
            this.p1 = BuildingsToolsPlugin.latlon2eastNorth(Main.map.mapView.getLatLon(this.mousePos.x, this.mousePos.y));
            this.building.setBase(this.p1);
        } else {
            this.p1 = BuildingsToolsPlugin.latlon2eastNorth(n.getCoor());
            this.building.setBase(n);
        }
        this.mode = Mode.Drawing;
        this.updateStatusLine();
    }

    private void drawingAdvance(MouseEvent e) {
        this.ProcessMouseEvent(e);
        if (this.building.getLength() > 0.0) {
            if (width == 0.0 && this.mode == Mode.Drawing) {
                this.p2 = this.building.Point2();
                this.mode = Mode.DrawingWidth;
                this.updateStatusLine();
                return;
            }
            Way w = this.building.create();
            if (w != null && useAddr) {
                DrawBuildingAction.showAddrDialog(w);
            }
        }
        Main.map.mapView.repaint();
        this.mode = Mode.None;
        Main.map.statusLine.setHeading(-1.0);
        Main.map.statusLine.setAngle(-1.0);
        this.building.reset();
        this.updateStatusLine();
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        if (this.mode == Mode.None) {
            this.drawingStart(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.ProcessMouseEvent(e);
        this.updCursor();
        if (this.mode != Mode.None) {
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean dragged = true;
        if (this.drawStartPos != null) {
            dragged = e.getPoint().distance(this.drawStartPos) > 10.0;
        }
        this.drawStartPos = null;
        if (this.mode == Mode.Drawing && dragged || this.mode == Mode.DrawingWidth) {
            this.drawingAdvance(e);
        }
    }

    private void updCursor() {
        if (this.mousePos == null) {
            return;
        }
        Node n = Main.map.mapView.getNearestNode(this.mousePos);
        if (n != null) {
            this.setCursor(this.cursorJoinNode);
        } else {
            this.setCursor(this.cursorCrosshair);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.ProcessMouseEvent(e);
        this.updCursor();
        if (this.mode != Mode.None) {
            Main.map.mapView.repaint();
        }
    }

    public String getModeHelpText() {
        if (this.mode == Mode.None) {
            return I18n.tr((String)"Point on angle of building to start drawing");
        }
        if (this.mode == Mode.Drawing) {
            return I18n.tr((String)"Point on opposite end of building");
        }
        if (this.mode == Mode.DrawingWidth) {
            return I18n.tr((String)"Set width of building");
        }
        return "";
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    public void UpdateConstraint(Collection<? extends OsmPrimitive> newSelection) {
        this.building.disableAngConstraint();
        if (newSelection.size() != 2) {
            return;
        }
        Object[] arr = newSelection.toArray();
        if (!(arr[0] instanceof Node) || !(arr[1] instanceof Node)) {
            return;
        }
        EastNorth p1 = BuildingsToolsPlugin.latlon2eastNorth(((Node)arr[0]).getCoor());
        EastNorth p2 = BuildingsToolsPlugin.latlon2eastNorth(((Node)arr[1]).getCoor());
        this.building.setAngConstraint(p1.heading(p2));
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.UpdateConstraint(newSelection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        None,
        Drawing,
        DrawingWidth;

    }
}

