/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.BuildingsToolsPlugin;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.I18n;

class Building {
    private static final double eqlen = 4.0075004E7;
    private EastNorth en1;
    private EastNorth en2;
    private EastNorth en3;
    private EastNorth en4;
    private EastNorth p1;
    private Node node;
    double meter = 0.0;
    private double len = 0.0;
    double lwidth;
    private boolean angconstrainted;
    private double angconstraint = 0.0;

    Building() {
    }

    public void disableAngConstraint() {
        this.angconstrainted = false;
    }

    public void setAngConstraint(double angle) {
        this.angconstrainted = true;
        this.angconstraint = angle;
        while (this.angconstraint > 0.7853981633974483) {
            this.angconstraint -= 0.7853981633974483;
        }
    }

    public double getLength() {
        return this.len;
    }

    public void reset() {
        this.len = 0.0;
        this.en1 = null;
        this.en2 = null;
        this.en3 = null;
        this.en4 = null;
    }

    public EastNorth Point1() {
        return this.en1;
    }

    public EastNorth Point2() {
        return this.en2;
    }

    public EastNorth Point3() {
        return this.en3;
    }

    public EastNorth Point4() {
        return this.en4;
    }

    private void updMetrics() {
        this.meter = Math.PI * 2 / (Math.cos(Math.toRadians(BuildingsToolsPlugin.eastNorth2latlon(this.p1).lat())) * 4.0075004E7);
        this.reset();
    }

    public void setBase(EastNorth base) {
        this.node = null;
        this.p1 = base;
        this.updMetrics();
    }

    public void setBase(Node base) {
        this.node = base;
        this.p1 = BuildingsToolsPlugin.latlon2eastNorth(base.getCoor());
        this.updMetrics();
    }

    public void setPlace(EastNorth p2, double width, double lenstep) {
        double heading = this.p1.heading(p2);
        double hdang = 0.0;
        if (this.angconstrainted) {
            hdang = Math.round((heading - this.angconstraint) / Math.PI * 4.0);
            if (hdang >= 8.0) {
                hdang -= 8.0;
            }
            if (hdang < 0.0) {
                hdang += 8.0;
            }
            heading = hdang * Math.PI / 4.0 + this.angconstraint;
        }
        double distance = BuildingsToolsPlugin.eastNorth2latlon(this.p1).greatCircleDistance(BuildingsToolsPlugin.eastNorth2latlon(p2));
        this.len = lenstep <= 0.0 ? distance : (double)Math.round(distance / lenstep) * lenstep;
        if (this.len == 0.0) {
            return;
        }
        this.en1 = this.p1;
        this.en2 = new EastNorth(this.p1.east() + Math.sin(heading) * this.len * this.meter, this.p1.north() + Math.cos(heading) * this.len * this.meter);
        this.en3 = new EastNorth(this.p1.east() + Math.sin(heading) * this.len * this.meter + Math.cos(heading) * width * this.meter, this.p1.north() + Math.cos(heading) * this.len * this.meter - Math.sin(heading) * width * this.meter);
        this.en4 = new EastNorth(this.p1.east() + Math.cos(heading) * width * this.meter, this.p1.north() - Math.sin(heading) * width * this.meter);
        this.lwidth = width;
        Main.map.statusLine.setHeading(Math.toDegrees(heading));
        if (this.angconstrainted) {
            Main.map.statusLine.setAngle(hdang * 45.0);
        }
    }

    public void paint(Graphics2D g, MapView mv) {
        if (this.len == 0.0) {
            return;
        }
        GeneralPath b = new GeneralPath();
        Point pp1 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en1));
        Point pp2 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en2));
        Point pp3 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en4));
        Point pp4 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en3));
        b.moveTo(pp1.x, pp1.y);
        b.lineTo(pp3.x, pp3.y);
        b.lineTo(pp4.x, pp4.y);
        b.lineTo(pp2.x, pp2.y);
        b.lineTo(pp1.x, pp1.y);
        g.draw(b);
    }

    public Way create() {
        if (this.len == 0.0) {
            return null;
        }
        Node n1 = this.node == null ? new Node(BuildingsToolsPlugin.eastNorth2latlon(this.en1)) : this.node;
        Node n2 = new Node(BuildingsToolsPlugin.eastNorth2latlon(this.en2));
        Node n3 = new Node(BuildingsToolsPlugin.eastNorth2latlon(this.en3));
        Node n4 = new Node(BuildingsToolsPlugin.eastNorth2latlon(this.en4));
        if (n1.getCoor().isOutSideWorld() || n2.getCoor().isOutSideWorld() || n3.getCoor().isOutSideWorld() || n4.getCoor().isOutSideWorld()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot place building outside of the world."));
            return null;
        }
        Way w = new Way();
        w.addNode(n1);
        if (this.lwidth >= 0.0) {
            w.addNode(n2);
            w.addNode(n3);
            w.addNode(n4);
        } else {
            w.addNode(n4);
            w.addNode(n3);
            w.addNode(n2);
        }
        w.addNode(n1);
        w.put("building", "yes");
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        if (this.node == null) {
            cmds.add(new AddCommand((OsmPrimitive)n1));
        }
        cmds.add(new AddCommand((OsmPrimitive)n2));
        cmds.add(new AddCommand((OsmPrimitive)n3));
        cmds.add(new AddCommand((OsmPrimitive)n4));
        cmds.add(new AddCommand((OsmPrimitive)w));
        SequenceCommand c = new SequenceCommand(I18n.tr((String)"Create building"), cmds);
        Main.main.undoRedo.add((Command)c);
        return w;
    }
}

