/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.piclayer.LoadPictureCalibrationAction;
import org.openstreetmap.josm.plugins.piclayer.ResetPictureAllAction;
import org.openstreetmap.josm.plugins.piclayer.ResetPictureAngleAction;
import org.openstreetmap.josm.plugins.piclayer.ResetPicturePositionAction;
import org.openstreetmap.josm.plugins.piclayer.ResetPictureScaleAction;
import org.openstreetmap.josm.plugins.piclayer.SavePictureCalibrationAction;
import org.openstreetmap.josm.tools.I18n;

public abstract class PicLayerAbstract
extends Layer {
    private static int m_counter = 0;
    private BufferedImage m_image = null;
    private EastNorth m_initial_position;
    private EastNorth m_position;
    private double m_angle = 0.0;
    private double m_scalex = 1.0;
    private double m_scaley = 1.0;
    private double m_initial_scale = 0.0;
    private Component[] m_popupmenu = null;
    private Icon m_layericon = null;
    private final String INITIAL_POS_X = "INITIAL_POS_X";
    private final String INITIAL_POS_Y = "INITIAL_POS_y";
    private final String POSITION_X = "POSITION_X";
    private final String POSITION_Y = "POSITION_Y";
    private final String ANGLE = "ANGLE";
    private final String INITIAL_SCALE = "INITIAL_SCALE";
    private final String SCALEX = "SCALEX";
    private final String SCALEY = "SCALEY";

    public PicLayerAbstract() {
        super("PicLayer #" + m_counter);
        ++m_counter;
        JMenu reset_submenu = new JMenu(I18n.tr((String)"Reset"));
        reset_submenu.add((Action)((Object)new ResetPictureAllAction(this)));
        reset_submenu.addSeparator();
        reset_submenu.add((Action)((Object)new ResetPicturePositionAction(this)));
        reset_submenu.add((Action)((Object)new ResetPictureAngleAction(this)));
        reset_submenu.add((Action)((Object)new ResetPictureScaleAction(this)));
        this.m_popupmenu = new Component[]{reset_submenu, new JSeparator(), new JMenuItem((Action)((Object)new SavePictureCalibrationAction(this))), new JMenuItem((Action)((Object)new LoadPictureCalibrationAction(this)))};
        this.m_layericon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(PicLayerAbstract.class.getResource("/images/layericon.png")));
    }

    public void Initialize() throws IOException {
        Image image = this.createImage();
        if (image == null) {
            throw new IOException(I18n.tr((String)"Image not created properly."));
        }
        this.m_image = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics g = this.m_image.getGraphics();
        g.drawImage(image, 0, 0, null);
        if (Main.map == null || Main.map.mapView == null) {
            throw new IOException(I18n.tr((String)"Could not find the map object."));
        }
        this.m_initial_position = this.m_position = Main.map.mapView.getCenter();
        this.m_initial_scale = Main.map.mapView.getDist100Pixel();
    }

    protected abstract Image createImage() throws IOException;

    protected abstract String getPicLayerName();

    public Icon getIcon() {
        return this.m_layericon;
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        return this.m_popupmenu;
    }

    public String getToolTipText() {
        return this.getPicLayerName();
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void paint(Graphics2D g2, MapView mv, Bounds bounds) {
        if (this.m_image != null && g2 instanceof Graphics2D) {
            EastNorth center = Main.map.mapView.getCenter();
            EastNorth leftop = Main.map.mapView.getEastNorth(0, 0);
            double pixel_per_en = (double)Main.map.mapView.getWidth() / 2.0 / (center.east() - leftop.east());
            double pic_offset_x = (this.m_position.east() - leftop.east()) * pixel_per_en;
            double pic_offset_y = (leftop.north() - this.m_position.north()) * pixel_per_en;
            Graphics2D g = (Graphics2D)g2.create();
            g.translate(pic_offset_x, pic_offset_y);
            g.rotate(this.m_angle * Math.PI / 180.0);
            double scalex = this.m_scalex * this.m_initial_scale / Main.map.mapView.getDist100Pixel();
            double scaley = this.m_scaley * this.m_initial_scale / Main.map.mapView.getDist100Pixel();
            g.scale(scalex, scaley);
            g.drawImage((Image)this.m_image, -this.m_image.getWidth() / 2, -this.m_image.getHeight() / 2, null);
            if (Main.map.mapView.getActiveLayer() == this) {
                g.setColor(new Color(0xFF0000));
                g.drawRect(-this.m_image.getWidth() / 2, -this.m_image.getHeight() / 2, this.m_image.getWidth(), this.m_image.getHeight());
            }
        } else {
            System.out.println("PicLayerAbstract::paint - general drawing error (m_image is null or Graphics not 2D");
        }
    }

    public void movePictureBy(double east, double north) {
        this.m_position = this.m_position.add(east, north);
    }

    public void scalePictureBy(double scalex, double scaley) {
        this.m_scalex += scalex;
        this.m_scaley += scaley;
    }

    public void rotatePictureBy(double angle) {
        this.m_angle += angle;
    }

    public void resetPosition() {
        this.m_position = this.m_initial_position;
    }

    public void resetScale() {
        this.m_scalex = 1.0;
        this.m_scaley = 1.0;
    }

    public void resetAngle() {
        this.m_angle = 0.0;
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    public void saveCalibration(Properties props) {
        props.put("INITIAL_POS_X", "" + this.m_initial_position.getX());
        props.put("INITIAL_POS_y", "" + this.m_initial_position.getY());
        props.put("POSITION_X", "" + this.m_position.getX());
        props.put("POSITION_Y", "" + this.m_position.getY());
        props.put("INITIAL_SCALE", "" + this.m_initial_scale);
        props.put("SCALEX", "" + this.m_scalex);
        props.put("SCALEY", "" + this.m_scaley);
        props.put("ANGLE", "" + this.m_angle);
    }

    public void loadCalibration(Properties props) {
        double pos_x = Double.valueOf(props.getProperty("POSITION_X"));
        double pos_y = Double.valueOf(props.getProperty("POSITION_Y"));
        double in_pos_x = Double.valueOf(props.getProperty("INITIAL_POS_X"));
        double in_pos_y = Double.valueOf(props.getProperty("INITIAL_POS_y"));
        double angle = Double.valueOf(props.getProperty("ANGLE"));
        double in_scale = Double.valueOf(props.getProperty("INITIAL_SCALE"));
        double scale_x = Double.valueOf(props.getProperty("SCALEX"));
        double scale_y = Double.valueOf(props.getProperty("SCALEY"));
        this.m_position.setLocation(pos_x, pos_y);
        this.m_initial_position.setLocation(pos_x, pos_y);
        this.m_angle = angle;
        this.m_scalex = scale_x;
        this.m_scaley = scale_y;
        this.m_initial_scale = in_scale;
        Main.map.mapView.repaint();
    }
}

