/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.editgpx.EditGpxLayer;
import org.openstreetmap.josm.plugins.editgpx.EditGpxMode;
import org.openstreetmap.josm.tools.I18n;

public class EditGpxPlugin
extends Plugin {
    private IconToggleButton btn;
    private EditGpxMode mode;
    protected static EditGpxLayer eGpxLayer;
    protected static DataSet dataSet;
    public static boolean active;

    public EditGpxPlugin(PluginInformation info) {
        super(info);
        dataSet = new DataSet();
        this.mode = new EditGpxMode(Main.map, "editgpx", I18n.tr((String)"edit gpx tracks"), dataSet);
        this.btn = new IconToggleButton((Action)((Object)this.mode));
        this.btn.setVisible(true);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            this.mode.setFrame(newFrame);
            if (Main.map != null) {
                Main.map.addMapMode(this.btn);
            }
            active = this.btn.isSelected();
            this.btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    active = EditGpxPlugin.this.btn.isSelected();
                    if (active) {
                        Main.worker.execute(new Runnable(){

                            public void run() {
                                EditGpxPlugin.this.updateLayer();
                            }
                        });
                    }
                }
            });
        }
    }

    private void updateLayer() {
        if (eGpxLayer == null) {
            eGpxLayer = new EditGpxLayer(I18n.tr((String)"EditGpx"), dataSet);
            Main.main.addLayer((Layer)eGpxLayer);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)new MapView.LayerChangeListener(){

                public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                    if (newLayer instanceof EditGpxLayer) {
                        eGpxLayer = (EditGpxLayer)newLayer;
                    }
                }

                public void layerAdded(Layer newLayer) {
                }

                public void layerRemoved(Layer oldLayer) {
                    if (oldLayer == eGpxLayer) {
                        eGpxLayer = null;
                        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
                    }
                }
            });
            eGpxLayer.initializeImport();
        }
        Main.map.mapView.repaint();
    }

    public static ImageIcon loadIcon(String name) {
        URL url = EditGpxPlugin.class.getResource("/images/editgpx.png");
        return new ImageIcon(url);
    }

    static {
        active = false;
    }
}

